/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.linkage.Union;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptions;

public class BBoxManager {
    public GraphicOptions theGraphicOptions;
    public HashMap<Residue, Rectangle> parent_bboxes = new HashMap();
    public HashMap<Residue, Rectangle> current_bboxes = new HashMap();
    public HashMap<Residue, Rectangle> border_bboxes = new HashMap();
    public HashMap<Residue, Rectangle> complete_bboxes = new HashMap();
    public HashMap<Residue, Rectangle> support_bboxes = new HashMap();
    public HashMap<Residue, ArrayList<Residue>> linked_residues = new HashMap();

    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptions opt) {
        this.theGraphicOptions = opt;
    }

    public Iterator<Map.Entry<Residue, Rectangle>> iterator() {
        return this.current_bboxes.entrySet().iterator();
    }

    public void reset() {
        this.parent_bboxes.clear();
        this.current_bboxes.clear();
        this.border_bboxes.clear();
        this.complete_bboxes.clear();
        this.support_bboxes.clear();
        this.linked_residues.clear();
    }

    public ArrayList<Residue> getLinkedResidues(Residue node) {
        ArrayList ret = this.linked_residues.get(node);
        return ret == null ? new ArrayList() : ret;
    }

    public void linkSubtree(Residue dest, Residue root_other) {
        if (dest != root_other) {
            ArrayList<Residue> lst_red = new ArrayList<Residue>();
            if (this.linked_residues.get(dest) == null) {
                lst_red.add(root_other);
                this.linked_residues.put(dest, lst_red);
            } else {
                this.linked_residues.get(dest).add(root_other);
            }
        }
        for (Linkage l : root_other.getChildrenLinkages()) {
            this.linkSubtree(dest, l.getChildResidue());
        }
    }

    public void linkSubtrees(Residue root_dest, Residue root_other) throws Exception {
        if (root_dest == null) {
            return;
        }
        if (!root_dest.subtreeEquals(root_other)) {
            throw new Exception("Subtrees do not match");
        }
        this.linkSubtreesPVT(root_dest, root_other);
    }

    private void linkSubtreesPVT(Residue root_dest, Residue root_other) {
        ArrayList<Residue> lst_red = new ArrayList<Residue>();
        if (this.linked_residues.get(root_dest) == null) {
            lst_red.add(root_other);
            this.linked_residues.put(root_dest, lst_red);
        } else {
            this.linked_residues.get(root_dest).add(root_other);
        }
        for (int i = 0; i < root_dest.getNoChildren(); ++i) {
            this.linkSubtreesPVT(root_dest.getLinkageAt(i).getChildResidue(), root_other.getLinkageAt(i).getChildResidue());
        }
    }

    public Rectangle getBBox(Glycan structure, boolean show_redend) {
        if (structure == null) {
            return null;
        }
        return Geometry.union(this.getComplete(structure.getRoot(show_redend)), this.getComplete(structure.getBracket()));
    }

    public void setAllBBoxes(Residue node, Rectangle bbox) {
        this.setParent(node, new Rectangle(bbox));
        this.setCurrent(node, new Rectangle(bbox));
        this.setBorder(node, new Rectangle(bbox));
        this.setComplete(node, new Rectangle(bbox));
        this.setSupport(node, new Rectangle(bbox));
    }

    public void setParent(Residue node, Rectangle bbox) {
        if (node != null && bbox != null) {
            this.parent_bboxes.put(node, new Rectangle(bbox));
        }
    }

    public Rectangle getParent(Residue node) {
        if (node == null) {
            return null;
        }
        return this.parent_bboxes.get(node);
    }

    public void setCurrent(Residue node, Rectangle bbox) {
        if (node != null && bbox != null) {
            this.current_bboxes.put(node, new Rectangle(bbox));
        }
    }

    public Rectangle getCurrent(Residue node) {
        if (node == null) {
            return null;
        }
        return this.current_bboxes.get(node);
    }

    public void setBorder(Residue node, Rectangle bbox) {
        if (node != null && bbox != null) {
            this.border_bboxes.put(node, new Rectangle(bbox));
        }
    }

    public Rectangle getBorder(Residue node) {
        if (node == null) {
            return null;
        }
        return this.border_bboxes.get(node);
    }

    public void setComplete(Residue node, Rectangle bbox) {
        if (node != null && bbox != null) {
            this.complete_bboxes.put(node, new Rectangle(bbox));
        }
    }

    public Rectangle getComplete(Residue node) {
        if (node == null) {
            return null;
        }
        return this.complete_bboxes.get(node);
    }

    public void setSupport(Residue node, Rectangle bbox) {
        if (node != null && bbox != null) {
            this.support_bboxes.put(node, new Rectangle(bbox));
        }
    }

    public Rectangle getSupport(Residue node) {
        if (node == null) {
            return null;
        }
        return this.support_bboxes.get(node);
    }

    public Residue getNodeAtPoint(Point p) {
        if (p == null) {
            return null;
        }
        for (Map.Entry<Residue, Rectangle> e : this.current_bboxes.entrySet()) {
            if (!e.getValue().contains(p)) continue;
            return e.getKey();
        }
        return null;
    }

    public LinkedList<Residue> getNodesInside(Rectangle r) {
        if (r == null) {
            return null;
        }
        LinkedList<Residue> nodes = new LinkedList<Residue>();
        for (Map.Entry<Residue, Rectangle> e : this.current_bboxes.entrySet()) {
            if (!r.intersects(e.getValue())) continue;
            nodes.add(e.getKey());
        }
        return nodes;
    }

    public Rectangle getComplete(List<Residue> nodes) {
        Rectangle bbox = null;
        for (Residue r : nodes) {
            bbox = Geometry.union(this.getComplete(r), bbox);
        }
        return bbox;
    }

    public Rectangle getCurrent(List<Residue> nodes) {
        int n = nodes.size();
        if (n == 0) {
            return null;
        }
        if (n % 2 == 1) {
            return this.getCurrent(nodes.get(n / 2));
        }
        return Geometry.union(this.getCurrent(nodes.get(n / 2 - 1)), this.getCurrent(nodes.get(n / 2)));
    }

    private Rectangle getCurrentComplete(List<Residue> nodes) {
        Rectangle bbox = null;
        if (nodes != null) {
            for (Residue r : nodes) {
                bbox = Geometry.union(bbox, this.getCurrent(r));
            }
        }
        return bbox;
    }

    private LinkedList<Rectangle> getAll(List<Residue> v) throws Exception {
        LinkedList<Rectangle> ret = new LinkedList<Rectangle>();
        if (v != null) {
            for (Residue r : v) {
                this.getAll(r, ret);
            }
        }
        return ret;
    }

    private LinkedList<Rectangle> getAll(Residue r) throws Exception {
        LinkedList<Rectangle> ret = new LinkedList<Rectangle>();
        this.getAll(r, ret);
        return ret;
    }

    private void getAll(Residue r, List<Rectangle> buffer) throws Exception {
        if (r == null) {
            throw new Exception("Empty node");
        }
        Rectangle cur = this.getCurrent(r);
        if (cur == null) {
            throw new Exception("Empty bbox");
        }
        buffer.add(cur);
        for (Linkage l : r.getChildrenLinkages()) {
            this.getAll(l.getChildResidue(), buffer);
        }
    }

    public static double distanceCW(double ref_angle, double other_angle) {
        if (other_angle > ref_angle) {
            return other_angle - ref_angle;
        }
        return Math.PI * 2 + other_angle - ref_angle;
    }

    public static double distanceCCW(double ref_angle, double other_angle) {
        if (other_angle < ref_angle) {
            return ref_angle - other_angle;
        }
        return Math.PI * 2 + ref_angle - other_angle;
    }

    public double getScreenAngle(Residue node, Residue parent) {
        Rectangle node_bbox = this.getCurrent(node);
        Rectangle par_bbox = this.getCurrent(parent);
        if (node_bbox == null || par_bbox == null) {
            return 0.0;
        }
        return Geometry.angle(Geometry.center(node_bbox), Geometry.center(par_bbox));
    }

    public Residue getNearestCW(Residue node, Collection<Residue> brothers) {
        if (node == null) {
            return null;
        }
        Residue parent = node.getParent();
        if (parent == null) {
            return null;
        }
        double best_dist = 0.0;
        Residue best_residue = null;
        double node_angle = this.getScreenAngle(node, parent);
        for (Residue other : brothers) {
            double other_angle = this.getScreenAngle(other, parent);
            double dist = BBoxManager.distanceCW(node_angle, other_angle);
            if (!(dist < 1.5707963267948966) || best_residue != null && !(dist < best_dist)) continue;
            best_residue = other;
            best_dist = dist;
        }
        return best_residue;
    }

    public Residue getNearestCCW(Residue node, Collection<Residue> brothers) {
        if (node == null) {
            return null;
        }
        Residue parent = node.getParent();
        if (parent == null) {
            return null;
        }
        double best_dist = 0.0;
        Residue best_residue = null;
        double node_angle = this.getScreenAngle(node, parent);
        for (Residue other : brothers) {
            double other_angle = this.getScreenAngle(other, parent);
            double dist = BBoxManager.distanceCCW(node_angle, other_angle);
            if (!(dist < 1.5707963267948966) || best_residue != null && !(dist < best_dist)) continue;
            best_residue = other;
            best_dist = dist;
        }
        return best_residue;
    }

    public Residue getNearestUp(Residue node) {
        return this.getNearestUp(node, this.current_bboxes.keySet().iterator());
    }

    public Residue getNearestUp(Residue node, Collection<Residue> brothers) {
        return this.getNearestUp(node, brothers.iterator());
    }

    public Residue getNearestUp(Residue node, Iterator<Residue> first) {
        if (node == null || first == null) {
            return null;
        }
        Rectangle cur_rect = this.getCurrent(node);
        Residue best_node = null;
        Rectangle best_rect = null;
        double best_dist = 0.0;
        Iterator<Residue> i = first;
        while (i.hasNext()) {
            Residue nav_node = i.next();
            Rectangle nav_rect = this.getCurrent(nav_node);
            if (!Geometry.isUp(nav_rect, cur_rect)) continue;
            double nav_dist = Geometry.distance(nav_rect, cur_rect);
            if (best_node != null && !(nav_dist < best_dist) && (nav_dist != best_dist || best_rect.x <= nav_rect.x)) continue;
            best_node = nav_node;
            best_rect = nav_rect;
            best_dist = nav_dist;
        }
        return best_node;
    }

    public Residue getNearestDown(Residue node) {
        return this.getNearestDown(node, this.current_bboxes.keySet().iterator());
    }

    public Residue getNearestDown(Residue node, Collection<Residue> brothers) {
        return this.getNearestDown(node, brothers.iterator());
    }

    public Residue getNearestDown(Residue node, Iterator<Residue> first) {
        if (node == null || first == null) {
            return null;
        }
        Rectangle cur_rect = this.getCurrent(node);
        Residue best_node = null;
        Rectangle best_rect = null;
        double best_dist = 0.0;
        Iterator<Residue> i = first;
        while (i.hasNext()) {
            Residue nav_node = i.next();
            Rectangle nav_rect = this.getCurrent(nav_node);
            if (!Geometry.isDown(nav_rect, cur_rect)) continue;
            double nav_dist = Geometry.distance(nav_rect, cur_rect);
            if (best_node != null && !(nav_dist < best_dist) && (nav_dist != best_dist || best_rect.x <= nav_rect.x)) continue;
            best_node = nav_node;
            best_rect = nav_rect;
            best_dist = nav_dist;
        }
        return best_node;
    }

    public Residue getNearestLeft(Residue node) {
        return this.getNearestLeft(node, this.current_bboxes.keySet().iterator());
    }

    public Residue getNearestLeft(Residue node, Collection<Residue> brothers) {
        return this.getNearestLeft(node, brothers.iterator());
    }

    public Residue getNearestLeft(Residue node, Iterator<Residue> first) {
        if (node == null || first == null) {
            return null;
        }
        Rectangle cur_rect = this.getCurrent(node);
        Residue best_node = null;
        Rectangle best_rect = null;
        double best_dist = 0.0;
        Iterator<Residue> i = first;
        while (i.hasNext()) {
            Residue nav_node = i.next();
            Rectangle nav_rect = this.getCurrent(nav_node);
            if (!Geometry.isLeft(nav_rect, cur_rect)) continue;
            double nav_dist = Geometry.distance(nav_rect, cur_rect);
            if (best_node != null && !(nav_dist < best_dist) && (nav_dist != best_dist || best_rect.y <= nav_rect.y)) continue;
            best_node = nav_node;
            best_rect = nav_rect;
            best_dist = nav_dist;
        }
        return best_node;
    }

    public Residue getNearestRight(Residue node) {
        return this.getNearestRight(node, this.current_bboxes.keySet().iterator());
    }

    public Residue getNearestRight(Residue node, Collection<Residue> brothers) {
        return this.getNearestRight(node, brothers.iterator());
    }

    public Residue getNearestRight(Residue node, Iterator<Residue> first) {
        if (node == null || first == null) {
            return null;
        }
        Rectangle cur_rect = this.getCurrent(node);
        Residue best_node = null;
        Rectangle best_rect = null;
        double best_dist = 0.0;
        Iterator<Residue> i = first;
        while (i.hasNext()) {
            Residue nav_node = i.next();
            Rectangle nav_rect = this.getCurrent(nav_node);
            if (!Geometry.isRight(nav_rect, cur_rect)) continue;
            double nav_dist = Geometry.distance(nav_rect, cur_rect);
            if (best_node != null && !(nav_dist < best_dist) && (nav_dist != best_dist || best_rect.y <= nav_rect.y)) continue;
            best_node = nav_node;
            best_rect = nav_rect;
            best_dist = nav_dist;
        }
        return best_node;
    }

    public void translate(int sx, int sy, List<Residue> nodes) {
        if (nodes != null) {
            Iterator<Residue> i = nodes.iterator();
            while (i.hasNext()) {
                this.translate(sx, sy, i.next());
            }
        }
    }

    public void translate(Dimension s, List<Residue> nodes) {
        if (nodes != null) {
            Iterator<Residue> i = nodes.iterator();
            while (i.hasNext()) {
                this.translate(s, i.next());
            }
        }
    }

    public void translate(Dimension s, Collection<Glycan> c) {
        this.translate(s.width, s.height, c);
    }

    public void translate(int sx, int sy, Collection<Glycan> c) {
        for (Glycan g : c) {
            this.translate(sx, sy, g);
        }
    }

    public void translate(Dimension s, Glycan g) {
        if (s != null) {
            this.translate(s.width, s.height, g);
        }
    }

    public void translate(int sx, int sy, Glycan g) {
        if (g != null) {
            this.translate(sx, sy, g.getRoot());
            this.translate(sx, sy, g.getBracket());
        }
    }

    public void translate(Dimension s, Residue node) {
        if (s != null) {
            this.translate(s.width, s.height, node);
        }
    }

    public void translate(int sx, int sy, Residue node) {
        if (node != null) {
            BBoxManager.translate(sx, sy, this.parent_bboxes.get(node));
            BBoxManager.translate(sx, sy, this.current_bboxes.get(node));
            BBoxManager.translate(sx, sy, this.border_bboxes.get(node));
            BBoxManager.translate(sx, sy, this.complete_bboxes.get(node));
            BBoxManager.translate(sx, sy, this.support_bboxes.get(node));
            Iterator<Linkage> i = node.iterator();
            while (i.hasNext()) {
                this.translate(sx, sy, i.next().getChildResidue());
            }
        }
    }

    public static void translate(int sx, int sy, Rectangle r) {
        if (r != null) {
            r.translate(sx, sy);
        }
    }

    private LinkedList<Rectangle> singleton(Rectangle r) {
        LinkedList<Rectangle> ret = new LinkedList<Rectangle>();
        if (r != null) {
            ret.add(r);
        }
        return ret;
    }

    private LinkedList<Residue> singleton(Residue r) {
        LinkedList<Residue> ret = new LinkedList<Residue>();
        if (r != null) {
            ret.add(r);
        }
        return ret;
    }

    private static void assertAlignment(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (ref_all_bboxes == null || ref_all_bboxes.size() == 0) {
            throw new Exception("Empty reference bbox set");
        }
        if (ref_sup_bbox == null) {
            throw new Exception("Empty reference bbox");
        }
        if (cur_all_bboxes == null || cur_all_bboxes.size() == 0) {
            throw new Exception("Empty current bbox set");
        }
        if (cur_sup_bbox == null) {
            throw new Exception("Empty current bbox");
        }
        if (space < 0) {
            throw new Exception("Negative distance");
        }
    }

    public void alignLeftsOnTop(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnTop(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignLeftsOnTop(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnTop(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignLeftsOnTop(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnTop(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignLeftsOnTop(Residue ref_node, Residue node, int space) throws Exception {
        this.alignLeftsOnTop(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignLeftsOnTop(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignLeftsOnTop(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignLeftsOnTop(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnTop(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignLeftsOnTop(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnTop(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignLeftsOnTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnTop(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignLeftsOnTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(Geometry.left(ref_sup_bbox) - Geometry.left(cur_sup_bbox), 0, nodes);
            this.translate(0, this.shiftToTop(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), nodes);
        }
    }

    public void alignLeftsOnBottom(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnBottom(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignLeftsOnBottom(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnBottom(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignLeftsOnBottom(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnBottom(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignLeftsOnBottom(Residue ref_node, Residue node, int space) throws Exception {
        this.alignLeftsOnBottom(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignLeftsOnBottom(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignLeftsOnBottom(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignLeftsOnBottom(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnBottom(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignLeftsOnBottom(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnBottom(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignLeftsOnBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignLeftsOnBottom(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignLeftsOnBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(Geometry.left(ref_sup_bbox) - Geometry.left(cur_sup_bbox), 0, nodes);
            this.translate(0, this.shiftToBottom(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), nodes);
        }
    }

    public void alignRightsOnTop(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnTop(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignRightsOnTop(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnTop(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignRightsOnTop(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnTop(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignRightsOnTop(Residue ref_node, Residue node, int space) throws Exception {
        this.alignRightsOnTop(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignRightsOnTop(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignRightsOnTop(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignRightsOnTop(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnTop(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignRightsOnTop(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnTop(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignRightsOnTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnTop(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignRightsOnTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(Geometry.right(ref_sup_bbox) - Geometry.right(cur_sup_bbox), 0, nodes);
            this.translate(0, this.shiftToTop(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), nodes);
        }
    }

    public void alignRightsOnBottom(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnBottom(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignRightsOnBottom(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnBottom(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignRightsOnBottom(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnBottom(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignRightsOnBottom(Residue ref_node, Residue node, int space) throws Exception {
        this.alignRightsOnBottom(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignRightsOnBottom(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignRightsOnBottom(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignRightsOnBottom(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnBottom(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignRightsOnBottom(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnBottom(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignRightsOnBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignRightsOnBottom(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignRightsOnBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(Geometry.right(ref_sup_bbox) - Geometry.right(cur_sup_bbox), 0, nodes);
            this.translate(0, this.shiftToBottom(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), nodes);
        }
    }

    public void alignCentersOnTop(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnTop(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignCentersOnTop(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnTop(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignCentersOnTop(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnTop(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignCentersOnTop(Residue ref_node, Residue node, int space) throws Exception {
        this.alignCentersOnTop(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignCentersOnTop(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignCentersOnTop(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignCentersOnTop(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnTop(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignCentersOnTop(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnTop(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignCentersOnTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnTop(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignCentersOnTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(Geometry.midx(ref_sup_bbox) - Geometry.midx(cur_sup_bbox), 0, nodes);
            this.translate(0, this.shiftToTop(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), nodes);
        }
    }

    public void alignCentersOnBottom(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnBottom(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignCentersOnBottom(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnBottom(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignCentersOnBottom(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnBottom(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignCentersOnBottom(Residue ref_node, Residue node, int space) throws Exception {
        this.alignCentersOnBottom(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignCentersOnBottom(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignCentersOnBottom(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignCentersOnBottom(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnBottom(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignCentersOnBottom(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnBottom(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignCentersOnBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnBottom(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignCentersOnBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(Geometry.midx(ref_sup_bbox) - Geometry.midx(cur_sup_bbox), 0, nodes);
            this.translate(0, this.shiftToBottom(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), nodes);
        }
    }

    public void alignCornersOnTopAtLeft(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnTopAtLeft(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnTopAtLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(Geometry.left(ref_sup_bbox) - Geometry.right(cur_sup_bbox) - xspace, 0, nodes);
            this.translate(0, this.shiftToTop(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, yspace), nodes);
        }
    }

    public void alignCornersOnTopAtRight(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnTopAtRight(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnTopAtRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(Geometry.right(ref_sup_bbox) - Geometry.left(cur_sup_bbox) + xspace, 0, nodes);
            this.translate(0, this.shiftToTop(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, yspace), nodes);
        }
    }

    public void alignCornersOnBottomAtLeft(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnBottomAtLeft(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnBottomAtLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(Geometry.left(ref_sup_bbox) - Geometry.right(cur_sup_bbox) - xspace, 0, nodes);
            this.translate(0, this.shiftToBottom(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, yspace), nodes);
        }
    }

    public void alignCornersOnBottomAtRight(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnBottomAtRight(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnBottomAtRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(Geometry.right(ref_sup_bbox) - Geometry.left(cur_sup_bbox) + xspace, 0, nodes);
            this.translate(0, this.shiftToBottom(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, yspace), nodes);
        }
    }

    private int shiftToTop(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space) throws Exception {
        return this.shiftToTop(ref_bboxes, ref_bbox, cur_bboxes, cur_bbox, space, 0);
    }

    private int shiftToTop(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space, int min_ref_space) throws Exception {
        int toll = this.theGraphicOptions.NODE_SPACE / 2 - 1;
        int shift = Geometry.top(ref_bbox) - Math.max(space, min_ref_space) - Geometry.bottom(cur_bbox);
        for (Rectangle cur : cur_bboxes) {
            for (Rectangle ref : ref_bboxes) {
                if (!Geometry.overlapx(cur, ref, toll)) continue;
                shift = Math.min(shift, Geometry.top(ref) - space - Geometry.bottom(cur));
            }
        }
        return shift;
    }

    private int shiftToBottom(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space) throws Exception {
        return this.shiftToBottom(ref_bboxes, ref_bbox, cur_bboxes, cur_bbox, space, 0);
    }

    private int shiftToBottom(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space, int min_ref_space) throws Exception {
        int toll = this.theGraphicOptions.NODE_SPACE / 2 - 1;
        int shift = Geometry.bottom(ref_bbox) + Math.max(space, min_ref_space) - Geometry.top(cur_bbox);
        for (Rectangle cur : cur_bboxes) {
            for (Rectangle ref : ref_bboxes) {
                if (!Geometry.overlapx(cur, ref, toll)) continue;
                shift = Math.max(shift, Geometry.bottom(ref) + space - Geometry.top(cur));
            }
        }
        return shift;
    }

    public void alignTopsOnLeft(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnLeft(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignTopsOnLeft(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnLeft(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignTopsOnLeft(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnLeft(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignTopsOnLeft(Residue ref_node, Residue node, int space) throws Exception {
        this.alignTopsOnLeft(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignTopsOnLeft(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignTopsOnLeft(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignTopsOnLeft(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnLeft(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignTopsOnLeft(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnLeft(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignTopsOnLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnLeft(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignTopsOnLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(0, Geometry.top(ref_sup_bbox) - Geometry.top(cur_sup_bbox), nodes);
            this.translate(this.shiftToLeft(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, nodes);
        }
    }

    public void alignTopsOnRight(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnRight(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignTopsOnRight(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnRight(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignTopsOnRight(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnRight(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignTopsOnRight(Residue ref_node, Residue node, int space) throws Exception {
        this.alignTopsOnRight(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignTopsOnRight(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignTopsOnRight(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignTopsOnRight(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnRight(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignTopsOnRight(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnRight(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignTopsOnRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignTopsOnRight(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignTopsOnRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(0, Geometry.top(ref_sup_bbox) - Geometry.top(cur_sup_bbox), nodes);
            this.translate(this.shiftToRight(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, nodes);
        }
    }

    public void alignBottomsOnLeft(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnLeft(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignBottomsOnLeft(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnLeft(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignBottomsOnLeft(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnLeft(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignBottomsOnLeft(Residue ref_node, Residue node, int space) throws Exception {
        this.alignBottomsOnLeft(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignBottomsOnLeft(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignBottomsOnLeft(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignBottomsOnLeft(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnLeft(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignBottomsOnLeft(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnLeft(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignBottomsOnLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnLeft(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignBottomsOnLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(0, Geometry.bottom(ref_sup_bbox) - Geometry.bottom(cur_sup_bbox), nodes);
            this.translate(this.shiftToLeft(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, nodes);
        }
    }

    public void alignBottomsOnRight(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnRight(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignBottomsOnRight(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnRight(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignBottomsOnRight(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnRight(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignBottomsOnRight(Residue ref_node, Residue node, int space) throws Exception {
        this.alignBottomsOnRight(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignBottomsOnRight(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignBottomsOnRight(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignBottomsOnRight(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnRight(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignBottomsOnRight(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnRight(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignBottomsOnRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignBottomsOnRight(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignBottomsOnRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(0, Geometry.bottom(ref_sup_bbox) - Geometry.bottom(cur_sup_bbox), nodes);
            this.translate(this.shiftToRight(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, nodes);
        }
    }

    public void alignCentersOnLeft(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnLeft(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignCentersOnLeft(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnLeft(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignCentersOnLeft(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnLeft(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignCentersOnLeft(Residue ref_node, Residue node, int space) throws Exception {
        this.alignCentersOnLeft(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignCentersOnLeft(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignCentersOnLeft(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignCentersOnLeft(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnLeft(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignCentersOnLeft(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnLeft(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignCentersOnLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnLeft(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignCentersOnLeft(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(0, Geometry.midy(ref_sup_bbox) - Geometry.midy(cur_sup_bbox), nodes);
            this.translate(this.shiftToLeft(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, nodes);
        }
    }

    public void alignCentersOnRight(List<Residue> ref_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnRight(this.getAll(ref_nodes), this.getCurrent(ref_nodes), nodes, space);
    }

    public void alignCentersOnRight(Residue ref_node, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnRight(this.getAll(ref_node), this.getCurrent(ref_node), nodes, space);
    }

    public void alignCentersOnRight(Rectangle ref_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnRight(this.singleton(ref_bbox), ref_bbox, nodes, space);
    }

    public void alignCentersOnRight(Residue ref_node, Residue node, int space) throws Exception {
        this.alignCentersOnRight(this.getAll(ref_node), this.getCurrent(ref_node), this.singleton(node), space);
    }

    public void alignCentersOnRight(Rectangle ref_bbox, Residue node, int space) throws Exception {
        this.alignCentersOnRight(this.singleton(ref_bbox), ref_bbox, this.singleton(node), space);
    }

    public void alignCentersOnRight(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnRight(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    public void alignCentersOnRight(List<Residue> ref_sup_nodes, List<Residue> ref_nodes, List<Residue> sup_nodes, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnRight(new Union<Rectangle>((Collection<Rectangle>)this.getAll(ref_sup_nodes)).and(this.getAll(ref_nodes)), this.getCurrent(ref_sup_nodes), this.getAll(nodes), this.getCurrent(sup_nodes), nodes, space);
    }

    private void alignCentersOnRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Residue> nodes, int space) throws Exception {
        this.alignCentersOnRight(ref_all_bboxes, ref_sup_bbox, this.getAll(nodes), this.getCurrent(nodes), nodes, space);
    }

    private void alignCentersOnRight(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int space) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, space);
            this.translate(0, Geometry.midy(ref_sup_bbox) - Geometry.midy(cur_sup_bbox), nodes);
            this.translate(this.shiftToRight(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, nodes);
        }
    }

    public void alignCornersOnLeftAtTop(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnLeftAtTop(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnLeftAtTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(0, Geometry.top(ref_sup_bbox) - Geometry.bottom(cur_sup_bbox) - yspace, nodes);
            this.translate(this.shiftToLeft(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, xspace), 0, nodes);
        }
    }

    public void alignCornersOnLeftAtBottom(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnLeftAtBottom(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnLeftAtBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(0, Geometry.bottom(ref_sup_bbox) - Geometry.top(cur_sup_bbox) + yspace, nodes);
            this.translate(this.shiftToLeft(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, xspace), 0, nodes);
        }
    }

    public void alignCornersOnRightAtTop(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnRightAtTop(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnRightAtTop(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(0, Geometry.top(ref_sup_bbox) - Geometry.bottom(cur_sup_bbox) - yspace, nodes);
            this.translate(this.shiftToRight(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, xspace), 0, nodes);
        }
    }

    public void alignCornersOnRightAtBottom(Rectangle ref_bbox, List<Residue> ref_nodes, List<Residue> nodes, int xspace, int yspace) throws Exception {
        this.alignCornersOnRightAtBottom(new Union<Rectangle>(ref_bbox).and(this.getAll(ref_nodes)), ref_bbox, this.getAll(nodes), this.getCurrentComplete(nodes), nodes, xspace, yspace);
    }

    private void alignCornersOnRightAtBottom(List<Rectangle> ref_all_bboxes, Rectangle ref_sup_bbox, List<Rectangle> cur_all_bboxes, Rectangle cur_sup_bbox, List<Residue> nodes, int xspace, int yspace) throws Exception {
        if (nodes != null && nodes.size() > 0) {
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, nodes, xspace);
            this.translate(0, Geometry.bottom(ref_sup_bbox) - Geometry.top(cur_sup_bbox) + yspace, nodes);
            this.translate(this.shiftToRight(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, xspace), 0, nodes);
        }
    }

    private int shiftToLeft(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space) throws Exception {
        return this.shiftToLeft(ref_bboxes, ref_bbox, cur_bboxes, cur_bbox, space, 0);
    }

    private int shiftToLeft(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space, int min_ref_space) throws Exception {
        int toll = this.theGraphicOptions.NODE_SPACE / 2 - 1;
        int shift = Geometry.left(ref_bbox) - Math.max(space, min_ref_space) - Geometry.right(cur_bbox);
        for (Rectangle cur : cur_bboxes) {
            for (Rectangle ref : ref_bboxes) {
                if (!Geometry.overlapy(cur, ref, toll)) continue;
                shift = Math.min(shift, Geometry.left(ref) - space - Geometry.right(cur));
            }
        }
        return shift;
    }

    private int shiftToRight(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space) throws Exception {
        return this.shiftToRight(ref_bboxes, ref_bbox, cur_bboxes, cur_bbox, space, 0);
    }

    private int shiftToRight(List<Rectangle> ref_bboxes, Rectangle ref_bbox, List<Rectangle> cur_bboxes, Rectangle cur_bbox, int space, int min_ref_space) throws Exception {
        int toll = this.theGraphicOptions.NODE_SPACE / 2 - 1;
        int shift = Geometry.right(ref_bbox) + Math.max(space, min_ref_space) - Geometry.left(cur_bbox);
        for (Rectangle cur : cur_bboxes) {
            for (Rectangle ref : ref_bboxes) {
                if (!Geometry.overlapy(cur, ref, toll)) continue;
                shift = Math.max(shift, Geometry.right(ref) + space - Geometry.left(cur));
            }
        }
        return shift;
    }

    public void alignSymmetricOnLeft(Rectangle ref_sup_bbox, List<Residue> ref_nodes, List<Residue> nodes_t, List<Residue> nodes_b, int space, int min_ref_space) throws Exception {
        if (nodes_t != null && nodes_t.size() > 0 && nodes_b != null && nodes_b.size() > 0) {
            Union<Rectangle> ref_all_bboxes = new Union<Rectangle>(ref_sup_bbox).and(this.getAll(ref_nodes));
            Rectangle cur_sup_bbox_t = this.getCurrentComplete(nodes_t);
            LinkedList<Rectangle> cur_all_bboxes_t = this.getAll(nodes_t);
            Rectangle cur_sup_bbox_b = this.getCurrentComplete(nodes_b);
            LinkedList<Rectangle> cur_all_bboxes_b = this.getAll(nodes_b);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_t, cur_sup_bbox_t, nodes_t, space);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_b, cur_sup_bbox_b, nodes_b, space);
            this.translate(Geometry.right(cur_sup_bbox_t) - Geometry.right(cur_sup_bbox_b), 0, nodes_b);
            this.translate(0, this.shiftToBottom(cur_all_bboxes_t, cur_sup_bbox_t, cur_all_bboxes_b, cur_sup_bbox_b, space, min_ref_space), nodes_b);
            Union<Residue> nodes = new Union<Residue>((Collection<Residue>)nodes_t).and(nodes_b);
            cur_sup_bbox_t = this.getCurrentComplete(nodes_t);
            cur_sup_bbox_b = this.getCurrentComplete(nodes_b);
            Rectangle cur_sup_bbox = Geometry.union(cur_sup_bbox_t, cur_sup_bbox_b);
            LinkedList<Rectangle> cur_all_bboxes = this.getAll(nodes);
            this.translate(0, Geometry.midy(ref_sup_bbox) - (Geometry.bottom(cur_sup_bbox_t) + Geometry.top(cur_sup_bbox_b)) / 2, (List<Residue>)nodes);
            this.translate(this.shiftToLeft(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, (List<Residue>)nodes);
        }
    }

    public void alignSymmetricOnRight(Rectangle ref_sup_bbox, List<Residue> ref_nodes, List<Residue> nodes_t, List<Residue> nodes_b, int space, int min_ref_space) throws Exception {
        if (nodes_t != null && nodes_t.size() > 0 && nodes_b != null && nodes_b.size() > 0) {
            Union<Rectangle> ref_all_bboxes = new Union<Rectangle>(ref_sup_bbox).and(this.getAll(ref_nodes));
            Rectangle cur_sup_bbox_t = this.getCurrentComplete(nodes_t);
            LinkedList<Rectangle> cur_all_bboxes_t = this.getAll(nodes_t);
            Rectangle cur_sup_bbox_b = this.getCurrentComplete(nodes_b);
            LinkedList<Rectangle> cur_all_bboxes_b = this.getAll(nodes_b);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_t, cur_sup_bbox_t, nodes_t, space);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_b, cur_sup_bbox_b, nodes_b, space);
            this.translate(Geometry.left(cur_sup_bbox_t) - Geometry.left(cur_sup_bbox_b), 0, nodes_b);
            this.translate(0, this.shiftToBottom(cur_all_bboxes_t, cur_sup_bbox_t, cur_all_bboxes_b, cur_sup_bbox_b, space, min_ref_space), nodes_b);
            Union<Residue> nodes = new Union<Residue>((Collection<Residue>)nodes_t).and(nodes_b);
            cur_sup_bbox_t = this.getCurrentComplete(nodes_t);
            cur_sup_bbox_b = this.getCurrentComplete(nodes_b);
            Rectangle cur_sup_bbox = Geometry.union(cur_sup_bbox_t, cur_sup_bbox_b);
            LinkedList<Rectangle> cur_all_bboxes = this.getAll(nodes);
            this.translate(0, Geometry.midy(ref_sup_bbox) - (Geometry.bottom(cur_sup_bbox_t) + Geometry.top(cur_sup_bbox_b)) / 2, (List<Residue>)nodes);
            this.translate(this.shiftToRight(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), 0, (List<Residue>)nodes);
        }
    }

    public void alignSymmetricOnBottom(Rectangle ref_sup_bbox, List<Residue> ref_nodes, List<Residue> nodes_l, List<Residue> nodes_r, int space, int min_ref_space) throws Exception {
        if (nodes_l != null && nodes_l.size() > 0 && nodes_r != null && nodes_r.size() > 0) {
            Union<Rectangle> ref_all_bboxes = new Union<Rectangle>(ref_sup_bbox).and(this.getAll(ref_nodes));
            Rectangle cur_sup_bbox_l = this.getCurrentComplete(nodes_l);
            LinkedList<Rectangle> cur_all_bboxes_l = this.getAll(nodes_l);
            Rectangle cur_sup_bbox_r = this.getCurrentComplete(nodes_r);
            LinkedList<Rectangle> cur_all_bboxes_r = this.getAll(nodes_r);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_l, cur_sup_bbox_l, nodes_l, space);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_r, cur_sup_bbox_r, nodes_r, space);
            this.translate(Geometry.top(cur_sup_bbox_l) - Geometry.top(cur_sup_bbox_r), 0, nodes_r);
            this.translate(this.shiftToRight(cur_all_bboxes_l, cur_sup_bbox_l, cur_all_bboxes_r, cur_sup_bbox_r, space, min_ref_space), 0, nodes_r);
            Union<Residue> nodes = new Union<Residue>((Collection<Residue>)nodes_l).and(nodes_r);
            cur_sup_bbox_l = this.getCurrentComplete(nodes_l);
            cur_sup_bbox_r = this.getCurrentComplete(nodes_r);
            Rectangle cur_sup_bbox = Geometry.union(cur_sup_bbox_l, cur_sup_bbox_r);
            LinkedList<Rectangle> cur_all_bboxes = this.getAll(nodes);
            this.translate(Geometry.midx(ref_sup_bbox) - (Geometry.right(cur_sup_bbox_l) + Geometry.left(cur_sup_bbox_r)) / 2, 0, (List<Residue>)nodes);
            this.translate(0, this.shiftToBottom(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), (List<Residue>)nodes);
        }
    }

    public void alignSymmetricOnTop(Rectangle ref_sup_bbox, List<Residue> ref_nodes, List<Residue> nodes_l, List<Residue> nodes_r, int space, int min_ref_space) throws Exception {
        if (nodes_l != null && nodes_l.size() > 0 && nodes_r != null && nodes_r.size() > 0) {
            Union<Rectangle> ref_all_bboxes = new Union<Rectangle>(ref_sup_bbox).and(this.getAll(ref_nodes));
            Rectangle cur_sup_bbox_l = this.getCurrentComplete(nodes_l);
            LinkedList<Rectangle> cur_all_bboxes_l = this.getAll(nodes_l);
            Rectangle cur_sup_bbox_r = this.getCurrentComplete(nodes_r);
            LinkedList<Rectangle> cur_all_bboxes_r = this.getAll(nodes_r);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_l, cur_sup_bbox_l, nodes_l, space);
            BBoxManager.assertAlignment(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes_r, cur_sup_bbox_r, nodes_r, space);
            this.translate(Geometry.bottom(cur_sup_bbox_l) - Geometry.bottom(cur_sup_bbox_r), 0, nodes_r);
            this.translate(this.shiftToRight(cur_all_bboxes_l, cur_sup_bbox_l, cur_all_bboxes_r, cur_sup_bbox_r, space, min_ref_space), 0, nodes_r);
            Union<Residue> nodes = new Union<Residue>((Collection<Residue>)nodes_l).and(nodes_r);
            cur_sup_bbox_l = this.getCurrentComplete(nodes_l);
            cur_sup_bbox_r = this.getCurrentComplete(nodes_r);
            Rectangle cur_sup_bbox = Geometry.union(cur_sup_bbox_l, cur_sup_bbox_r);
            LinkedList<Rectangle> cur_all_bboxes = this.getAll(nodes);
            this.translate(Geometry.midx(ref_sup_bbox) - (Geometry.right(cur_sup_bbox_l) + Geometry.left(cur_sup_bbox_r)) / 2, 0, (List<Residue>)nodes);
            this.translate(0, this.shiftToTop(ref_all_bboxes, ref_sup_bbox, cur_all_bboxes, cur_sup_bbox, space), (List<Residue>)nodes);
        }
    }
}

