/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.linkage.LinkageStyle;
import org.eurocarbdb.application.glycanbuilder.renderutil.AbstractLinkageRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.Paintable;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class LinkageRendererAWT
extends AbstractLinkageRenderer {
    public LinkageRendererAWT() {
    }

    public LinkageRendererAWT(GlycanRenderer src) {
        super(src);
    }

    @Override
    public void paintEdge(Paintable paintable, Linkage link, boolean selected, Rectangle parent_bbox, Rectangle parent_border_bbox, Rectangle child_bbox, Rectangle child_border_bbox) {
        if (link == null) {
            return;
        }
        Graphics2D g2d = paintable.getGraphics2D();
        Stroke edge_stroke = this.createStroke(link, selected);
        Shape edge_shape = this.createShape(link, parent_bbox, child_bbox);
        if (edge_shape != null) {
            g2d.setStroke(edge_stroke);
            g2d.setColor(Color.black);
            g2d.draw(edge_shape);
            g2d.setStroke(new BasicStroke(1.0f));
        }
    }

    @Override
    public void paintInfo(Paintable paintable, Linkage link, Rectangle parent_bbox, Rectangle parent_border_bbox, Rectangle child_bbox, Rectangle child_border_bbox) {
        if (link == null || !this.theGraphicOptions.SHOW_INFO) {
            return;
        }
        Graphics2D g2d = paintable.getGraphics2D();
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        Font old_font = g2d.getFont();
        Font new_font = new Font(this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, 0, this.theGraphicOptions.LINKAGE_INFO_SIZE);
        g2d.setFont(new_font);
        Residue child = link.getChildResidue();
        if (child.isAlternative()) {
            return;
        }
        if (style.showParentLinkage(link) && this.checkEdgeConditionParentLinkage(link)) {
            this.paintInfo(paintable, this.createParentPosiitonProbability(link), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, true, false, link.hasMultipleBonds());
        }
        if (style.showAnomericCarbon(link)) {
            this.paintInfo(paintable, link.getChildPositionsString(), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, false, true, link.hasMultipleBonds());
        }
        if (style.showAnomericState(link, child.getAnomericState()) && this.checkAnomericPosition(link)) {
            this.paintInfo(paintable, TextUtils.toGreek(child.getAnomericState()), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, false, false, link.hasMultipleBonds());
        }
        g2d.setFont(old_font);
    }

    @Override
    protected void paintInfo(Paintable paintable, String text, Rectangle p, Rectangle pb, Rectangle c, Rectangle cb, boolean toparent, boolean above, boolean multiple) {
        Graphics2D g2d = paintable.getGraphics2D();
        Dimension tb = Geometry.textBounds(text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
        Point pos = this.computePosition(tb, p, pb, c, cb, toparent, above, multiple);
        g2d.clearRect(pos.x, (int)((double)pos.y - tb.getHeight()), (int)tb.getWidth(), (int)tb.getHeight());
        g2d.drawString(text, pos.x, pos.y);
    }

    protected Stroke createStroke(Linkage link, boolean selected) {
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        if (style.isDashed()) {
            float[] dashes = new float[]{5.0f, 5.0f};
            return new BasicStroke(selected ? 2.0f : 1.0f, 0, 1, 1.0f, dashes, 0.0f);
        }
        return new BasicStroke(selected ? 2.0f : 1.0f);
    }

    private boolean checkEdgeConditionParentLinkage(Linkage link) {
        boolean a_bIsShow = false;
        if (!(link.getChildResidue().isComposition() || link.getParentResidue().isStartRepetition() || link.getParentResidue().isReducingEnd() || link.getChildResidue().isStartRepetition() || link.getChildResidue().isStartCyclic())) {
            a_bIsShow = true;
        }
        if (link.getParentResidue().isSaccharide() && link.getChildResidue().isStartRepetition()) {
            a_bIsShow = true;
        }
        return a_bIsShow;
    }

    private boolean checkAnomericPosition(Linkage link) {
        if (link.getChildResidue().getAnomericState() == 'o') {
            return false;
        }
        return !link.getParentResidue().isReducingEnd() || !link.getChildResidue().isStartRepetition();
    }

    private String createParentPosiitonProbability(Linkage _linkage) {
        StringBuilder probability = new StringBuilder("");
        int high = _linkage.getBonds().get(0).getProbabilityHigh();
        int low = _linkage.getBonds().get(0).getProbabilityLow();
        if (high != 100 && low != 100 && high == low) {
            probability.append("(").append(high == -100 ? "?" : Integer.valueOf(high)).append("%").append(")");
            probability.append(_linkage.getParentPositionsString());
            return probability.toString();
        }
        if (low != 100) {
            probability.append("(");
            probability.append(low == -100 ? "?" : Integer.valueOf(low));
        }
        if (high != 100 || low < 100) {
            if (probability.length() != 0) {
                probability.append(",");
                probability.append(high == -100 ? "?" : Integer.valueOf(high));
            } else {
                probability.append("(");
                probability.append(high == -100 ? "?" : Integer.valueOf(high));
            }
        }
        if (probability.length() > 0) {
            probability.append("%)");
        }
        probability.append(_linkage.getParentPositionsString());
        return probability.toString();
    }
}

