/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

public class ResAngle {
    protected int angle;

    public ResAngle() {
        this.angle = 0;
    }

    public ResAngle(int _angle) {
        this.angle = ResAngle.normalize(_angle);
        this.angle -= (this.angle + 180) % 45;
    }

    public ResAngle(String init) {
        this.angle = ResAngle.normalize(Integer.parseInt(init));
        this.angle -= (this.angle + 180) % 45;
    }

    private static int normalize(int angle) {
        while (angle <= -180) {
            angle += 360;
        }
        while (angle > 180) {
            angle -= 360;
        }
        return angle;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ResAngle)) {
            return false;
        }
        return this.angle == ((ResAngle)other).angle;
    }

    public int hashCode() {
        return Integer.valueOf(this.angle).hashCode();
    }

    public boolean equals(int other) {
        return this.angle == ResAngle.normalize(other);
    }

    public ResAngle combine(ResAngle other) {
        ResAngle ret = new ResAngle();
        ret.angle = ResAngle.normalize(this.angle + other.angle);
        return ret;
    }

    public ResAngle combine(int other_angle) {
        ResAngle ret = new ResAngle();
        ret.angle = ResAngle.normalize(this.angle + other_angle);
        return ret;
    }

    public boolean isOpposite(ResAngle other) {
        return Math.abs(this.angle - other.angle) == 180;
    }

    public ResAngle opposite() {
        ResAngle ret = new ResAngle();
        ret.angle = ResAngle.normalize(this.angle + 180);
        return ret;
    }

    public double getAngle() {
        return Math.PI * (double)this.angle / 180.0;
    }

    public int getIntAngle() {
        return this.angle;
    }

    public String toString() {
        return Integer.toString(this.angle);
    }
}

