/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.renderutil.AbstractResidueRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.Paintable;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;
import org.eurocarbdb.application.glycanbuilder.util.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;
import org.glycoinfo.application.glycanbuilder.util.GlycanUtils;

public class ResidueRendererAWT
extends AbstractResidueRenderer {
    boolean showAnom = true;

    public ResidueRendererAWT(GlycanRenderer src) {
        super(src);
    }

    @Override
    public Icon getIcon(ResidueType type, int max_y_size) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        BufferedImage img = GraphicUtils.createCompatibleImage(bbox.width + 8, bbox.height + 8, false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.paint(new DefaultPaintable(g2d), node, false, false, null, bbox, null, new ResAngle());
        this.theGraphicOptions.ORIENTATION = orientation;
        return new ImageIcon(img);
    }

    public BufferedImage getBufferedImage(ResidueType type, int max_y_size, boolean a_bIsShowAnom) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        this.showAnom = a_bIsShowAnom;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        BufferedImage img = GraphicUtils.createCompatibleImage(bbox.width + 8, bbox.height + 8, false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.paint(new DefaultPaintable(g2d), node, false, false, null, bbox, null, new ResAngle());
        this.theGraphicOptions.ORIENTATION = orientation;
        this.showAnom = true;
        return img;
    }

    @Override
    public Image getImage(ResidueType type, int max_y_size) {
        return Toolkit.getDefaultToolkit().createImage(this.getBufferedImage(type, max_y_size, false).getSource());
    }

    @Override
    public void paint(Paintable paintable, Residue node, boolean selected, boolean active, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        if (node == null) {
            return;
        }
        Graphics2D g2d = paintable.getGraphics2D();
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        if (this.haveSymbol(node)) {
            style = ResidueStyle.assignedSNFG(node);
        }
        boolean isSNFG = !this.checkComposiiton(node).isEmpty();
        Point pp = par_bbox != null ? Geometry.center(par_bbox) : Geometry.center(cur_bbox);
        Point ps = sup_bbox != null ? Geometry.center(sup_bbox) : Geometry.center(cur_bbox);
        Shape shape = this.createShape(node, par_bbox, cur_bbox, sup_bbox, orientation, style);
        Shape text_shape = this.createTextShape(node, par_bbox, cur_bbox, sup_bbox, orientation, style);
        Shape fill_shape = this.createFillShape(node, cur_bbox, style, orientation, Geometry.angle(pp, ps));
        Color shape_color = style.getShapeColor();
        Color fill_color = style.getFillColor();
        Color text_color = style.getTextColor();
        if (selected) {
            fill_color = new Color(ResidueRendererAWT.sig(fill_color.getRed()), ResidueRendererAWT.sig(fill_color.getGreen()), ResidueRendererAWT.sig(fill_color.getBlue()));
        }
        if (!active) {
            shape_color = new Color(ResidueRendererAWT.sig(shape_color.getRed()), ResidueRendererAWT.sig(shape_color.getGreen()), ResidueRendererAWT.sig(shape_color.getBlue()));
            fill_color = new Color(ResidueRendererAWT.sig(fill_color.getRed()), ResidueRendererAWT.sig(fill_color.getGreen()), ResidueRendererAWT.sig(fill_color.getBlue()));
            text_color = new Color(ResidueRendererAWT.sig(text_color.getRed()), ResidueRendererAWT.sig(text_color.getGreen()), ResidueRendererAWT.sig(text_color.getBlue()));
        }
        if (shape != null && !on_border) {
            if (fill_shape != null) {
                Object old_hint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                Shape old_clip = g2d.getClip();
                g2d.clip(shape);
                g2d.setColor(style.isFillNegative() ? fill_color : Color.white);
                g2d.fill(shape);
                g2d.setColor(style.isFillNegative() ? Color.white : fill_color);
                g2d.fill(fill_shape);
                if (old_hint != null) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old_hint);
                }
                g2d.setColor(shape_color);
                g2d.draw(fill_shape);
                g2d.setClip(old_clip);
            }
            g2d.setStroke(selected ? new BasicStroke(2.0f) : new BasicStroke(1.0f));
            g2d.setColor(shape_color);
            g2d.draw(shape);
            g2d.setStroke(new BasicStroke(1.0f));
        } else if (selected) {
            float[] dashes = new float[]{5.0f, 5.0f};
            g2d.setStroke(new BasicStroke(2.0f, 0, 1, 1.0f, dashes, 0.0f));
            g2d.setColor(shape_color);
            g2d.draw(cur_bbox);
            g2d.setStroke(new BasicStroke(1.0f));
        }
        if (text_shape != null) {
            g2d.setColor(shape_color);
            g2d.fill(text_shape);
        }
        if (shape == null || on_border || style.getText() != null || isSNFG) {
            Rectangle2D.Double text_rect;
            if (shape == null || on_border) {
                orientation = this.theGraphicOptions.getOrientationAngle();
            } else if (style.getText() != null) {
                orientation = new ResAngle(0);
            }
            String text = this.getText(node, on_border);
            if (isSNFG) {
                ArrayList<String> configurations = this.checkComposiiton(node);
                if (shape != null) {
                    if (configurations.size() == 1) {
                        text = configurations.get(0);
                    }
                    if (configurations.size() == 2) {
                        text = configurations.get(0) + configurations.get(1);
                    }
                    if (configurations.size() == 3) {
                        text = configurations.get(0) + configurations.get(1) + configurations.get(2);
                    }
                } else {
                    for (String configuration : configurations) {
                        if (configuration.equals("p") || configuration.equals("f")) {
                            text = text + configuration;
                        }
                        if (!configuration.equals("D") && !configuration.equals("L")) continue;
                        text = configuration + text;
                    }
                }
            }
            int font_size = isSNFG && text.length() < 3 ? 10 : this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = Geometry.textBounds((String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            if (shape != null) {
                font_size = ResidueRendererAWT.sat(8 * font_size * cur_bbox.width / x_size / 10, font_size);
            }
            Font new_font = null;
            new_font = isSNFG && node.isAlditol() && text.equals("o") || node.isAldehyde() && text.equals("a") ? new Font(this.theGraphicOptions.NODE_FONT_FACE, 2, font_size) : new Font(this.theGraphicOptions.NODE_FONT_FACE, 0, font_size);
            Font old_font = g2d.getFont();
            g2d.setFont(new_font);
            Rectangle2D.Double text_bound = new Rectangle2D.Double();
            text_bound.setRect(new TextLayout(text, new_font, g2d.getFontRenderContext()).getBounds());
            g2d.setColor(text_color);
            if (orientation.equals(0) || orientation.equals(180)) {
                text_rect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.width / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.height / 2.0, text_bound.width, text_bound.height);
                if (shape == null || fill_shape == null) {
                    g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                }
                g2d.drawString(text, (int)text_rect.x, (int)(text_rect.y + text_rect.height));
            }
            if (orientation.equals(-90) || orientation.equals(90)) {
                if (isSNFG) {
                    text_rect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.width / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.height / 2.0, text_bound.width, text_bound.height);
                    if (shape == null || fill_shape == null) {
                        g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                    }
                    g2d.drawString(text, (int)text_rect.x, (int)(text_rect.y + text_rect.height));
                } else {
                    text_rect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.height / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.width / 2.0, text_bound.height, text_bound.width);
                    if (shape == null || fill_shape == null) {
                        g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                    }
                    g2d.rotate(-1.5707963267948966);
                    g2d.drawString(text, -((int)(text_rect.y + text_rect.height)), (int)(text_rect.x + text_rect.width));
                    g2d.rotate(1.5707963267948966);
                }
            }
            g2d.setFont(old_font);
        }
        boolean isShow = false;
        if (node.isSaccharide()) {
            isShow = GlycanUtils.isFacingAnom(node);
        }
        if (!this.theGraphicOptions.SHOW_REDEND_CANVAS && node.isSaccharide()) {
            String viewType = this.theGraphicOptions.DISPLAY;
            boolean bl = isShow = node.equals(node.getTreeRoot().firstChild()) && !node.isAlditol() && !node.getTreeRoot().isBracket() && viewType == "normal" && viewType == "compact";
            if (node.equals(node.getTreeRoot().firstChild()) && !node.isAlditol() && !node.getTreeRoot().isBracket() && viewType == "normalinfo") {
                isShow = true;
            }
        }
        if (shape != null && isShow) {
            this.showAnomericState(g2d, node, orientation, cur_bbox);
        }
        g2d.setColor(Color.black);
    }

    private Graphics2D showAnomericState(Graphics2D g2d, Residue node, ResAngle orientation, Rectangle cur_bbox) {
        String anomString = TextUtils.toGreek(node.getAnomericState());
        Font oldFont = g2d.getFont();
        Font newFont = new Font(this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, 0, this.theGraphicOptions.LINKAGE_INFO_SIZE);
        Rectangle2D.Double text_bound = new Rectangle2D.Double();
        g2d.setFont(newFont);
        text_bound.setRect(new TextLayout(TextUtils.toGreek(node.getAnomericState()), newFont, g2d.getFontRenderContext()).getBounds());
        Rectangle2D.Double txtRect = null;
        int margine = 0;
        if (orientation.equals(0) || orientation.equals(180)) {
            margine = orientation.equals(0) ? -15 : 15;
            txtRect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.width / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.height / 2.0, text_bound.width, text_bound.height);
            g2d.drawString(anomString, (int)txtRect.x + margine, (int)(txtRect.y + txtRect.height));
        } else {
            margine = orientation.equals(90) ? -15 : 15;
            txtRect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.height / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.width / 2.0, text_bound.height, text_bound.width);
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(anomString, -((int)(txtRect.y + txtRect.height + (double)margine)), (int)(txtRect.x + txtRect.width));
            g2d.rotate(1.5707963267948966);
        }
        g2d.setFont(oldFont);
        return g2d;
    }

    private boolean haveSymbol(Residue _node) {
        if (!this.theGraphicOptions.NOTATION.equals("snfg")) {
            return false;
        }
        if (!_node.isSaccharide()) {
            return false;
        }
        if (_node.isBridge()) {
            return false;
        }
        if (_node.getType().getDescription().equals("no glycosidic linkages")) {
            return false;
        }
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(_node);
        return style.getShape() == null;
    }
}

