/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.renderutil.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.GroupingSVGGraphics2D;
import org.eurocarbdb.application.glycanbuilder.renderutil.PositionManager;
import org.glycoinfo.application.glycanbuilder.util.GlycanUtils;

class SVGGlycanRenderer
extends GlycanRendererAWT {
    Glycan theStructure = null;

    public SVGGlycanRenderer(GlycanRendererAWT src) {
        this.theResidueRenderer = src.theResidueRenderer;
        this.theLinkageRenderer = src.theLinkageRenderer;
        this.theResiduePlacementDictionary = src.theResiduePlacementDictionary;
        this.theResidueStyleDictionary = src.theResidueStyleDictionary;
        this.theLinkageStyleDictionary = src.theLinkageStyleDictionary;
        this.theGraphicOptions = src.theGraphicOptions;
    }

    public void paint(GroupingSVGGraphics2D g2d, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null || structure.getRoot(show_redend) == null) {
            return;
        }
        this.theStructure = structure;
        boolean isAlditol = show_redend;
        if (!structure.isComposition()) {
            isAlditol = GlycanUtils.isShowRedEnd(structure, this.theGraphicOptions, show_redend);
        }
        this.assignID(structure);
        selected_residues = selected_residues != null ? selected_residues : new HashSet<Residue>();
        HashSet<Linkage> hashSet = selected_linkages = selected_linkages != null ? selected_linkages : new HashSet<Linkage>();
        if (!structure.isComposition()) {
            this.paintResidue(g2d, structure.getRoot(isAlditol), selected_residues, selected_linkages, null, posManager, bboxManager);
        }
        this.paintBracket(g2d, structure, selected_residues, selected_linkages, null, posManager, bboxManager);
        if (this.theGraphicOptions.NOTATION.equals("snfg")) {
            g2d.addGroup("legend", structure, null);
            this.displayLegend(new DefaultPaintable(g2d), structure, show_redend, bboxManager);
        }
        if (show_mass) {
            g2d.addGroup("m", structure, null);
            this.displayMass(new DefaultPaintable(g2d), structure, show_redend, bboxManager);
        }
    }

    public void paintResidue(GroupingSVGGraphics2D g2d, Residue node, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, PositionManager posManager, BBoxManager bboxManager) {
        if (node == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(node);
        Rectangle node_bbox = bboxManager.getCurrent(node);
        Rectangle border_bbox = bboxManager.getBorder(node);
        Rectangle support_bbox = bboxManager.getSupport(node);
        if (node_bbox == null) {
            return;
        }
        for (Linkage link : node.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            g2d.addGroup("l", this.theStructure, node, child);
            boolean selected = selected_residues.contains(node) && selected_residues.contains(child) || selected_linkages.contains(link);
            boolean active = active_residues == null || active_residues.contains(node) && active_residues.contains(child);
            this.theLinkageRenderer.paintEdge(new DefaultPaintable(g2d), link, selected, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
        g2d.addGroup("r", this.theStructure, node);
        boolean selected = selected_residues.contains(node);
        boolean active = active_residues == null || active_residues.contains(node);
        this.theResidueRenderer.paint(new DefaultPaintable(g2d), node, selected, active, posManager.isOnBorder(node), parent_bbox, node_bbox, support_bbox, posManager.getOrientation(node));
        for (Linkage link : node.getChildrenLinkages()) {
            this.paintResidue(g2d, link.getChildResidue(), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
        }
        for (Linkage link : node.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            g2d.addGroup("li", this.theStructure, node, child);
            this.theLinkageRenderer.paintInfo(new DefaultPaintable(g2d), link, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
    }

    public void paintBracket(GroupingSVGGraphics2D g2d, Glycan _glycan, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, PositionManager posManager, BBoxManager bboxManager) {
        boolean active;
        if (_glycan == null || _glycan.getBracket() == null) {
            return;
        }
        Residue bracket = _glycan.getBracket();
        Rectangle parent_bbox = bboxManager.getParent(bracket);
        Rectangle bracket_bbox = bboxManager.getCurrent(bracket);
        Rectangle support_bbox = bboxManager.getSupport(bracket);
        g2d.addGroup("b", this.theStructure, bracket);
        boolean selected = selected_residues.contains(bracket);
        boolean bl = active = active_residues == null || active_residues.contains(bracket);
        if (!_glycan.isComposition()) {
            this.theResidueRenderer.paint(new DefaultPaintable(g2d), bracket, selected, active, false, parent_bbox, bracket_bbox, support_bbox, posManager.getOrientation(bracket));
        }
        for (Linkage link : bracket.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            if (child.getType().getDescription().equals("no glycosidic linkages")) continue;
            int quantity = bboxManager.getLinkedResidues(child).size() + 1;
            Rectangle node_bbox = bboxManager.getParent(child);
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null) continue;
            if (!posManager.isOnBorder(child)) {
                g2d.addGroup("l", this.theStructure, bracket, child);
                selected = selected_residues.contains(bracket) && selected_residues.contains(child) || selected_linkages.contains(link);
                boolean bl2 = active = active_residues == null || active_residues.contains(bracket) && active_residues.contains(child);
                if (!_glycan.isComposition() && !link.getChildResidue().getParentsOfFragment().isEmpty()) {
                    this.theLinkageRenderer.paintEdge(new DefaultPaintable(g2d), link, selected, node_bbox, node_bbox, child_bbox, child_border_bbox);
                }
            }
            this.paintResidue(new DefaultPaintable(g2d), child, selected_residues, selected_linkages, active_residues, posManager, bboxManager);
            if (!posManager.isOnBorder(child)) {
                if (_glycan.isComposition()) {
                    node_bbox.x += this.theGraphicOptions.NODE_SPACE;
                }
                g2d.addGroup("li", this.theStructure, bracket, child);
                this.theLinkageRenderer.paintInfo(new DefaultPaintable(g2d), link, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            if (quantity <= 1) continue;
            this.paintQuantity(new DefaultPaintable(g2d), child, quantity, bboxManager);
        }
    }
}

