/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;

class ImageTransferable
implements Transferable {
    private static DataFlavor[] imageFlavors = new DataFlavor[4];
    public static DataFlavor imageFlavor;
    public static DataFlavor bmpFlavor;
    public static DataFlavor pngFlavor;
    public static DataFlavor jpegFlavor;
    private BufferedImage theImage = null;

    public ImageTransferable(BufferedImage img) {
        this.theImage = img;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return imageFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor parFlavor) {
        if (parFlavor == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < imageFlavors.length; ++i) {
            if (!parFlavor.equals(imageFlavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException, IOException {
        if (parFlavor == null) {
            throw new NullPointerException();
        }
        if (this.theImage != null) {
            if (parFlavor.equals(imageFlavor)) {
                return this.getImage();
            }
            if (parFlavor.equals(bmpFlavor)) {
                return this.getImageStream("bmp");
            }
            if (parFlavor.equals(pngFlavor)) {
                return this.getImageStream("png");
            }
            if (parFlavor.equals(jpegFlavor)) {
                return this.getImageStream("jpeg");
            }
        }
        throw new UnsupportedFlavorException(parFlavor);
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public InputStream getImageStream(String format) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.getImage(), format, bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    static {
        ImageTransferable.imageFlavors[0] = imageFlavor = DataFlavor.imageFlavor;
        ImageTransferable.imageFlavors[1] = bmpFlavor = new DataFlavor("image/bmp", "image/bmp");
        ImageTransferable.imageFlavors[2] = pngFlavor = new DataFlavor("image/png", "image/png");
        ImageTransferable.imageFlavors[3] = jpegFlavor = new DataFlavor("image/jpeg", "image/jpeg");
    }
}

