/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.util.EscapeDialog;
import org.jdesktop.layout.GroupLayout;

public class ReadDialog
extends EscapeDialog
implements ActionListener,
ItemListener {
    private JButton button_cancel;
    private JButton button_ok;
    private JComboBox list_format;
    private JTextField field_input_text;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private String str_input = "";
    private GlycanDocument a_objGD;

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableItems();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.closeDialog();
        }
    }

    public ReadDialog(Frame owner, GlycanDocument _a_objGD) {
        super(owner, true);
        this.a_objGD = _a_objGD;
        this.initComponents();
        this.fillComponents();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(owner);
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void fillComponents() {
        this.list_format.setModel(new DefaultComboBoxModel<String>(new String[]{"GlycoCT{condensed}", "LinearCode", "KCF", "LINUCS", "WURCS2.0"}));
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent(this.field_input_text);
        tp.addComponent(this.button_ok);
        tp.addComponent(this.button_cancel);
        this.setFocusTraversalPolicy(tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void enableItems() {
        this.list_format.setEnabled(true);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void retrieveData() {
        this.str_input = this.field_input_text.getText();
        if (this.str_input.equals("")) {
            return;
        }
        String format = this.getSelectedValueChar(this.list_format);
        this.a_objGD.importFrom(this.str_input, format);
    }

    private String getSelectedValueChar(JComboBox field) {
        return String.valueOf(field.getSelectedItem());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.field_input_text = new JTextField();
        this.list_format = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ReadDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Input text");
        this.jLabel2.setText("Format");
        this.field_input_text.setText("");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.list_format.setModel(new DefaultComboBoxModel<String>(new String[]{"GlycoCT", "LinearCode", "KCF", "LINUCS", "WURCS2.0"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(12, 12, 12).add(this.button_ok).addPreferredGap(0).add(this.button_cancel)).add(this.jSeparator1, -1, 183, Short.MAX_VALUE).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jLabel1).add(this.jLabel2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.field_input_text, -1, 74, Short.MAX_VALUE).add(this.list_format, 0, 66, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel1).add(this.field_input_text, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.list_format, -2, -1, -2)).addPreferredGap(0).add(this.jSeparator1, -2, 10, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.button_ok).add(this.button_cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }
}

