/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Periodic;

public class Isotope {
    private int id;
    private Periodic element;
    private String periodicSymbol;
    private Integer neutrons;
    private Double mass;
    private Double abundance;
    private String spin;
    private Boolean stable;
    private String halfLife;
    private String commonName;

    public Isotope() {
        this.init();
    }

    public Isotope(Periodic elem, Integer neutronCount) {
        this.init();
        this.setElement(elem);
        this.setNeutrons(neutronCount);
    }

    public Isotope(Periodic elem, String periodicSym, Integer neutr, Double massDbl, Double abund, String spinStr, Boolean isStable, String halfLifeStr, String commonNameStr) {
        this.init();
        this.setElement(elem);
        this.setPeriodicSymbol(periodicSym);
        this.setNeutrons(neutr);
        this.setMass(massDbl);
        this.setAbundance(abund);
        this.setSpin(spinStr);
        this.setStable(isStable);
        this.setHalfLife(halfLifeStr);
        this.setCommonName(commonNameStr);
    }

    public Isotope(String periodicSym, Integer neutr, Double massDbl, Double abund, String spinStr, Boolean isStable, String halfLifeStr, String commonNameStr) {
        this.init();
        try {
            this.setElement(Periodic.getElementBySymbol(periodicSym));
        }
        catch (ResourcesDbException resourcesDbException) {
            // empty catch block
        }
        this.setPeriodicSymbol(periodicSym);
        this.setNeutrons(neutr);
        this.setMass(massDbl);
        this.setAbundance(abund);
        this.setSpin(spinStr);
        this.setStable(isStable);
        this.setHalfLife(halfLifeStr);
        this.setCommonName(commonNameStr);
    }

    public Double getAbundance() {
        return this.abundance;
    }

    public void setAbundance(Double abundance) {
        this.abundance = abundance;
    }

    public void setAbundance(double abundance) {
        this.abundance = new Double(abundance);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public Periodic getElement() {
        return this.element;
    }

    public void setElement(Periodic element) {
        this.element = element;
    }

    public String getHalfLife() {
        return this.halfLife;
    }

    public void setHalfLife(String halfLife) {
        this.halfLife = halfLife;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Double getMass() {
        return this.mass;
    }

    public void setMass(Double mass) {
        this.mass = mass;
    }

    public void setMass(double mass) {
        this.mass = new Double(mass);
    }

    public Integer getNeutrons() {
        return this.neutrons;
    }

    public void setNeutrons(Integer neutrons) {
        this.neutrons = neutrons;
    }

    public String getSpin() {
        return this.spin;
    }

    public void setSpin(String spin) {
        this.spin = spin;
    }

    public boolean isStable() {
        if (this.getStable() == null) {
            return false;
        }
        return this.getStable();
    }

    public Boolean getStable() {
        return this.stable;
    }

    public void setStable(boolean stable) {
        this.stable = new Boolean(stable);
    }

    public void setStable(Boolean stable) {
        this.stable = stable;
    }

    public String getPeriodicSymbol() {
        return this.periodicSymbol;
    }

    public void setPeriodicSymbol(String periodicSymbol) {
        this.periodicSymbol = periodicSymbol;
    }

    public void init() {
        this.setAbundance(null);
        this.setCommonName(null);
        this.setElement(null);
        this.setHalfLife(null);
        this.setId(0);
        this.setMass(null);
        this.setNeutrons(null);
        this.setSpin(null);
        this.setStable(null);
        this.setPeriodicSymbol(null);
    }

    public String toString() {
        String outStr = "Isotope: ";
        outStr = String.valueOf(outStr) + this.getElement().getSymbol() + " " + this.getMass();
        outStr = String.valueOf(outStr) + " | neutrons " + this.getNeutrons();
        outStr = String.valueOf(outStr) + " | spin " + this.getSpin();
        outStr = String.valueOf(outStr) + " | stable " + this.isStable();
        return outStr;
    }

    public String getName() {
        return this.getNeutrons() + this.getPeriodicSymbol();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

