/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;

public class Mol2Type {
    public static final String C_1 = "C.1";
    public static final String C_2 = "C.2";
    public static final String C_3 = "C.3";
    public static final String C_AR = "C.ar";
    public static final String C_CAT = "C.cat";
    public static final String O_CO2 = "O.co2";
    public static final String O_2 = "O.2";
    public static final String O_3 = "O.3";
    public static final String N_1 = "N.1";
    public static final String N_2 = "N.2";
    public static final String N_3 = "N.3";
    public static final String N_PL3 = "N.pl3";
    public static final String N_4 = "N.4";
    public static final String N_AR = "N.ar";
    public static final String N_AM = "N.am";
    public static final String S_O = "S.o";
    public static final String S_O2 = "S.o2";
    public static final String S_2 = "S.2";
    public static final String S_3 = "S.3";
    public static final String H = "H";
    public static final String P_3 = "P.3";
    public static final String CO_OH = "Co.oh";
    public static final String RU_OH = "Ru.oh";
    public static final String TI_TH = "Ti.th";
    public static final String TI_OH = "Ti.oh";
    public static final String CR_TH = "Cr.th";
    public static final String CR_OH = "Cr.oh";
    public static final String DUMMY = "Du";
    private static String[] nonMetalAtoms = new String[]{"H", "C", "O", "N", "F", "Si", "P", "S", "Cl", "As", "Se", "Br", "Te", "I", "At", "He", "Ne", "Ar", "Kr", "Xe", "Rn", "D", "B"};

    public static boolean isNonMetalAtom(Atom a) {
        String[] stringArray = nonMetalAtoms;
        int n = nonMetalAtoms.length;
        int n2 = 0;
        while (n2 < n) {
            String nonMetalSymbol = stringArray[n2];
            if (nonMetalSymbol.equals(a.getElementSymbol())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int countNonmetalBonds(Atom a) {
        int bondcount = 0;
        if (a.getConnections() != null) {
            for (AtomConnection acon : a.getConnections()) {
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(a)) {
                    toAtom = acon.getFromAtom();
                }
                if (!Mol2Type.isNonMetalAtom(toAtom)) continue;
                ++bondcount;
            }
        }
        return bondcount;
    }

    public static int countNonmetalSingleBonds(Atom a) {
        int bondcount = 0;
        if (a.getConnections() != null) {
            for (AtomConnection acon : a.getConnections()) {
                if (acon.getBondOrder() != 1.0) continue;
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(a)) {
                    toAtom = acon.getFromAtom();
                }
                if (!Mol2Type.isNonMetalAtom(toAtom)) continue;
                ++bondcount;
            }
        }
        return bondcount;
    }

    public static int countNonmetalDoubleBonds(Atom a) {
        int bondcount = 0;
        if (a.getConnections() != null) {
            for (AtomConnection acon : a.getConnections()) {
                if (acon.getBondOrder() != 2.0) continue;
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(a)) {
                    toAtom = acon.getFromAtom();
                }
                if (!Mol2Type.isNonMetalAtom(toAtom)) continue;
                ++bondcount;
            }
        }
        return bondcount;
    }

    public static int countNonmetalTripleBonds(Atom a) {
        int bondcount = 0;
        if (a.getConnections() != null) {
            for (AtomConnection acon : a.getConnections()) {
                if (acon.getBondOrder() != 3.0) continue;
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(a)) {
                    toAtom = acon.getFromAtom();
                }
                if (!Mol2Type.isNonMetalAtom(toAtom)) continue;
                ++bondcount;
            }
        }
        return bondcount;
    }

    public static Atom getConnectedNonmetalAtom(Atom a, int index) {
        int count = 0;
        if (a.getConnections() != null) {
            for (AtomConnection acon : a.getConnections()) {
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(a)) {
                    toAtom = acon.getFromAtom();
                }
                if (!Mol2Type.isNonMetalAtom(toAtom) || ++count != index) continue;
                return toAtom;
            }
        }
        return null;
    }

    public static String getMol2Type(Atom a) {
        String elementSymbol = a.getElementSymbol();
        if (elementSymbol != null) {
            if (elementSymbol.equals("P")) {
                return P_3;
            }
            if (elementSymbol.equals("Co")) {
                return CO_OH;
            }
            if (elementSymbol.equals("Ru")) {
                return RU_OH;
            }
            if (elementSymbol.equals("C")) {
                if (a.countBonds() >= 4 && a.countSingleBonds() == a.countBonds()) {
                    return C_3;
                }
                if (a.countBonds() >= 2 && a.countAromaticBonds() == 2) {
                    return C_AR;
                }
                if (a.countBonds() <= 2 && a.countTripleBonds() == 1) {
                    return C_1;
                }
                return C_2;
            }
            if (elementSymbol.equals("O")) {
                Atom o;
                Atom toAtom;
                if (Mol2Type.countNonmetalBonds(a) == 1 && (toAtom = Mol2Type.getConnectedNonmetalAtom(a, 1)).getElementSymbol().equals("C") && toAtom.countBonds() == 3 && (o = toAtom.getConnectedAtom("O", 1)) != null && Mol2Type.countNonmetalBonds(o) == 1 && (o = toAtom.getConnectedAtom("O", 2)) != null && Mol2Type.countNonmetalBonds(o) == 1) {
                    return O_CO2;
                }
                if (a.countBonds() >= 2 && a.countBonds() == a.countSingleBonds()) {
                    return O_3;
                }
                return O_2;
            }
            if (elementSymbol.equals("N")) {
                if (Mol2Type.countNonmetalBonds(a) == 4 && Mol2Type.countNonmetalSingleBonds(a) == 4) {
                    return N_4;
                }
                if (a.countBonds() >= 2 && a.countAromaticBonds() == 2) {
                    return N_AR;
                }
                if (Mol2Type.countNonmetalBonds(a) == 1 && Mol2Type.countNonmetalTripleBonds(a) == 1) {
                    return N_1;
                }
                if (Mol2Type.countNonmetalBonds(a) == 2 && (Mol2Type.countNonmetalDoubleBonds(a) == 2 || Mol2Type.countNonmetalSingleBonds(a) == 1 && Mol2Type.countNonmetalTripleBonds(a) == 1)) {
                    return N_1;
                }
                if (Mol2Type.countNonmetalBonds(a) == 3) {
                    int i = 1;
                    while (i <= 3) {
                        Atom c = a.getConnectedAtom("C", i);
                        if (c != null) {
                            for (AtomConnection acon : c.getConnections()) {
                                if (acon.getBondOrder() != 2.0) continue;
                                if (acon.getToAtom().getElementSymbol().equals("O")) {
                                    return N_AM;
                                }
                                if (!acon.getToAtom().getElementSymbol().equals("S")) continue;
                                return N_AM;
                            }
                        }
                        ++i;
                    }
                    if (Mol2Type.countNonmetalSingleBonds(a) == 2) {
                        return N_PL3;
                    }
                    return N_3;
                }
                return N_2;
            }
            if (elementSymbol.equals("S")) {
                Atom o;
                int i;
                int oCount;
                if (Mol2Type.countNonmetalBonds(a) == 3) {
                    oCount = 0;
                    i = 1;
                    while (i <= 3) {
                        o = a.getConnectedAtom("O", i);
                        if (o != null && Mol2Type.countNonmetalBonds(o) == 1) {
                            ++oCount;
                        }
                        ++i;
                    }
                    if (oCount == 1) {
                        return S_O;
                    }
                }
                if (Mol2Type.countNonmetalBonds(a) == 4) {
                    oCount = 0;
                    i = 1;
                    while (i <= 4) {
                        o = a.getConnectedAtom("O", i);
                        if (o != null && Mol2Type.countNonmetalBonds(o) == 1) {
                            ++oCount;
                        }
                        ++i;
                    }
                    if (oCount == 2) {
                        return S_O2;
                    }
                }
                if (a.countBonds() >= 2 && a.countBonds() == a.countSingleBonds()) {
                    return S_3;
                }
                return S_2;
            }
            if (elementSymbol.equals("Ti")) {
                if (a.countBonds() <= 4) {
                    return TI_TH;
                }
                return TI_OH;
            }
            if (elementSymbol.equals("Cr")) {
                if (a.countBonds() <= 4) {
                    return CR_TH;
                }
                return CR_OH;
            }
            return elementSymbol;
        }
        return DUMMY;
    }
}

