/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomTemplate;
import org.eurocarbdb.resourcesdb.atom.Composition;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideLinkingPosition;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideSynonym;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.representation.Fischer;
import org.eurocarbdb.resourcesdb.representation.Haworth;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentation;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationFormat;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationType;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonosaccharideDataBuilder {
    public static void buildSynonyms(Monosaccharide ms, TemplateContainer container) {
        MonosaccharideDataBuilder.buildSynonyms(ms, container, null);
    }

    public static void buildSynonyms(Monosaccharide ms, TemplateContainer container, GlycanNamescheme scheme) {
        block32: {
            MonosaccharideSynonym alias;
            MonosaccharideSynonym msTrivialAlias;
            MonosaccharideSynonym msNoTrivialAlias;
            MonosaccharideExchangeObject forceTrivialMsObj;
            MonosaccharideExchangeObject allowTrivialMsObj;
            MonosaccharideExchangeObject noTrivialMsObj;
            MonosaccharideConverter forceTrivialConverter;
            MonosaccharideConverter allowTrivialConverter;
            MonosaccharideConverter noTrivialConverter;
            block31: {
                block30: {
                    block29: {
                        ms.initSynonyms();
                        if (container == null) {
                            container = ms.getTemplateContainer();
                        }
                        Config noTrivialNamesConf = Config.getGlobalConfig().clone();
                        noTrivialNamesConf.setAllowTrivialNames(false);
                        Config allowTrivialNamesConf = Config.getGlobalConfig().clone();
                        allowTrivialNamesConf.setAllowTrivialNames(true);
                        allowTrivialNamesConf.setForceTrivialNames(false);
                        Config forceTrivialNamesConf = Config.getGlobalConfig().clone();
                        forceTrivialNamesConf.setAllowTrivialNames(true);
                        forceTrivialNamesConf.setForceTrivialNames(true);
                        noTrivialConverter = new MonosaccharideConverter(noTrivialNamesConf, container);
                        allowTrivialConverter = new MonosaccharideConverter(allowTrivialNamesConf, container);
                        forceTrivialConverter = new MonosaccharideConverter(forceTrivialNamesConf, container);
                        noTrivialMsObj = null;
                        allowTrivialMsObj = null;
                        forceTrivialMsObj = null;
                        if (scheme == null || scheme.equals((Object)GlycanNamescheme.CARBBANK)) {
                            try {
                                noTrivialMsObj = noTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.CARBBANK);
                                forceTrivialMsObj = forceTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.CARBBANK);
                                msNoTrivialAlias = new MonosaccharideSynonym(noTrivialMsObj);
                                msNoTrivialAlias.setIsTrivialName(false);
                                ms.addSynonym(msNoTrivialAlias);
                                if (noTrivialMsObj.getMonosaccharideName().equals(forceTrivialMsObj.getMonosaccharideName())) {
                                    msNoTrivialAlias.setIsPrimary(true);
                                } else {
                                    allowTrivialMsObj = allowTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.CARBBANK);
                                    msTrivialAlias = new MonosaccharideSynonym(forceTrivialMsObj);
                                    msTrivialAlias.setIsTrivialName(true);
                                    if (forceTrivialMsObj.getMonosaccharideName().equals(allowTrivialMsObj.getMonosaccharideName())) {
                                        msTrivialAlias.setIsPrimary(true);
                                        msNoTrivialAlias.setIsPrimary(false);
                                    } else {
                                        msTrivialAlias.setIsPrimary(false);
                                        msNoTrivialAlias.setIsPrimary(true);
                                    }
                                    ms.addSynonym(msTrivialAlias);
                                }
                            }
                            catch (ResourcesDbException ex) {
                                if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block29;
                                System.err.println("Exception in building synonyms: " + ex);
                            }
                        }
                    }
                    if (scheme == null || scheme.equals((Object)GlycanNamescheme.GLYCOSCIENCES)) {
                        try {
                            noTrivialMsObj = noTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.GLYCOSCIENCES);
                            allowTrivialMsObj = allowTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.GLYCOSCIENCES);
                            forceTrivialMsObj = forceTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.GLYCOSCIENCES);
                            msNoTrivialAlias = new MonosaccharideSynonym(noTrivialMsObj);
                            msNoTrivialAlias.setIsTrivialName(false);
                            ms.addSynonym(msNoTrivialAlias);
                            if (noTrivialMsObj.getMonosaccharideName().equals(forceTrivialMsObj.getMonosaccharideName())) {
                                msNoTrivialAlias.setIsPrimary(true);
                            } else {
                                msTrivialAlias = new MonosaccharideSynonym(forceTrivialMsObj);
                                msTrivialAlias.setIsTrivialName(true);
                                if (forceTrivialMsObj.getMonosaccharideName().equals(allowTrivialMsObj.getMonosaccharideName())) {
                                    msTrivialAlias.setIsPrimary(true);
                                    msNoTrivialAlias.setIsPrimary(false);
                                } else {
                                    msTrivialAlias.setIsPrimary(false);
                                    msNoTrivialAlias.setIsPrimary(true);
                                }
                                ms.addSynonym(msTrivialAlias);
                            }
                        }
                        catch (ResourcesDbException ex) {
                            if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block30;
                            System.err.println("Exception in building synonyms: " + ex);
                            ex.printStackTrace();
                        }
                    }
                }
                if (scheme == null || scheme.equals((Object)GlycanNamescheme.GLYCOCT)) {
                    try {
                        noTrivialMsObj = noTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.GLYCOCT);
                        alias = new MonosaccharideSynonym(noTrivialMsObj);
                        alias.setIsTrivialName(false);
                        alias.setIsPrimary(true);
                        ms.addSynonym(alias);
                    }
                    catch (ResourcesDbException ex) {
                        if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block31;
                        System.err.println("Exception in building synonyms: " + ex);
                        ex.printStackTrace();
                    }
                }
            }
            if (scheme == null || scheme.equals((Object)GlycanNamescheme.CFG)) {
                try {
                    allowTrivialMsObj = allowTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.CFG);
                    if (allowTrivialMsObj.getMonosaccharideName() != null) {
                        alias = new MonosaccharideSynonym(allowTrivialMsObj);
                        alias.setIsTrivialName(false);
                        alias.setIsPrimary(true);
                        ms.addSynonym(alias);
                    }
                }
                catch (ResourcesDbException alias2) {
                    // empty catch block
                }
            }
            if (scheme == null || scheme.equals((Object)GlycanNamescheme.BCSDB)) {
                try {
                    noTrivialMsObj = noTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.BCSDB);
                    allowTrivialMsObj = allowTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.BCSDB);
                    forceTrivialMsObj = forceTrivialConverter.convertMonosaccharide(ms, GlycanNamescheme.BCSDB);
                    msNoTrivialAlias = new MonosaccharideSynonym(noTrivialMsObj);
                    msNoTrivialAlias.setIsTrivialName(false);
                    if (noTrivialMsObj.getMonosaccharideName().equals(forceTrivialMsObj.getMonosaccharideName())) {
                        msNoTrivialAlias.setIsPrimary(true);
                        ms.addSynonym(msNoTrivialAlias);
                    } else {
                        msTrivialAlias = new MonosaccharideSynonym(forceTrivialMsObj);
                        msTrivialAlias.setIsTrivialName(true);
                        if (forceTrivialMsObj.getMonosaccharideName().equals(allowTrivialMsObj.getMonosaccharideName())) {
                            msTrivialAlias.setIsPrimary(true);
                            msNoTrivialAlias.setIsPrimary(false);
                            ms.addSynonym(msTrivialAlias);
                        } else {
                            msTrivialAlias.setIsPrimary(false);
                            msNoTrivialAlias.setIsPrimary(true);
                            ms.addSynonym(msNoTrivialAlias);
                        }
                    }
                }
                catch (ResourcesDbException ex) {
                    if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block32;
                    System.err.println("Exception in building synonyms: " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void adjustCompositionByLinkageType(Composition compo, LinkageType linktype) throws ResourcesDbException {
        if (linktype.equals((Object)LinkageType.DEOXY)) {
            compo.decreaseCount(Periodic.O);
            compo.decreaseCount(Periodic.H);
        } else if (linktype.equals((Object)LinkageType.H_AT_OH)) {
            compo.decreaseCount(Periodic.H);
        } else if (linktype.equals((Object)LinkageType.H_LOSE)) {
            compo.decreaseCount(Periodic.H);
        } else if (linktype.equals((Object)LinkageType.R_CONFIG)) {
            compo.decreaseCount(Periodic.H);
        } else if (linktype.equals((Object)LinkageType.S_CONFIG)) {
            compo.decreaseCount(Periodic.H);
        } else {
            throw new MonosaccharideException("Cannot build monosaccharide composition: unexpected LinkageType (" + linktype.getType() + ")");
        }
    }

    public static void buildComposition(Monosaccharide ms) throws ResourcesDbException {
        if (ms.getBasetype().getComposition() == null) {
            try {
                ms.getBasetype().buildComposition();
            }
            catch (ResourcesDbException me) {
                MonosaccharideException me2 = new MonosaccharideException("Cannot build basetype composition");
                me2.initCause(me);
                throw me2;
            }
        }
        Composition compo = new Composition(ms.getBasetype().getComposition());
        for (Substitution subst : ms.getSubstitutions()) {
            Composition substCompos = subst.getTemplate().getComposition();
            if (substCompos == null) {
                throw new MonosaccharideException("Cannot build monosaccharide composition: No composition set for substitutent " + subst.getName());
            }
            compo.addComposition(substCompos);
            LinkageType linktype = subst.getLinkagetype1();
            if (linktype == null) {
                throw new MonosaccharideException("Cannot build monosaccharide composition: LinkageType is null for substitution " + subst.toString());
            }
            MonosaccharideDataBuilder.adjustCompositionByLinkageType(compo, linktype);
            if (subst.getValence() != 2) continue;
            linktype = subst.getLinkagetype2();
            if (linktype == null) {
                throw new MonosaccharideException("Cannot build monosaccharide composition: LinkageType2 is null for substitution " + subst.toString());
            }
            MonosaccharideDataBuilder.adjustCompositionByLinkageType(compo, linktype);
        }
        ms.setComposition(compo);
    }

    public static Haworth buildHaworth(Monosaccharide ms) throws ResourcesDbException {
        Haworth h = new Haworth();
        h.drawMonosaccharide(ms);
        return h;
    }

    public static Fischer buildFischer(Monosaccharide ms) throws ResourcesDbException {
        Fischer f = new Fischer();
        f.drawMonosaccharide(ms);
        return f;
    }

    public static void addHaworthRepresentations(Monosaccharide ms) {
        block9: {
            try {
                Haworth h;
                block8: {
                    h = MonosaccharideDataBuilder.buildHaworth(ms);
                    ResidueRepresentation monoRepSvg = new ResidueRepresentation();
                    monoRepSvg.setFormat(ResidueRepresentationFormat.SVG);
                    monoRepSvg.setType(ResidueRepresentationType.HAWORTH);
                    monoRepSvg.setWidth(h.getSvgWidth());
                    monoRepSvg.setHeight(h.getSvgHeight());
                    monoRepSvg.setData(h.getSvgByteArr());
                    if (monoRepSvg.getData() != null) {
                        ms.addRepresentation(monoRepSvg);
                    }
                    ResidueRepresentation monoRepPng = new ResidueRepresentation();
                    monoRepPng.setFormat(ResidueRepresentationFormat.PNG);
                    monoRepPng.setType(ResidueRepresentationType.HAWORTH);
                    monoRepPng.setWidth(h.getSvgWidth());
                    monoRepPng.setHeight(h.getSvgHeight());
                    try {
                        monoRepPng.setData(h.createPngImage());
                        ms.addRepresentation(monoRepPng);
                    }
                    catch (Exception ex) {
                        if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block8;
                        System.err.println("Exception in addHaworthRepresentation(): " + ex);
                    }
                }
                ResidueRepresentation monoRepJpg = new ResidueRepresentation();
                monoRepJpg.setFormat(ResidueRepresentationFormat.JPG);
                monoRepJpg.setType(ResidueRepresentationType.HAWORTH);
                monoRepJpg.setWidth(h.getSvgWidth());
                monoRepJpg.setHeight(h.getSvgHeight());
                try {
                    monoRepJpg.setData(h.createJpgImage());
                    ms.addRepresentation(monoRepJpg);
                }
                catch (Exception ex) {
                    if (Config.getGlobalConfig().isPrintErrorMsgs(1)) {
                        System.err.println("Exception in addHaworthRepresentation(): " + ex);
                    }
                }
            }
            catch (ResourcesDbException me) {
                if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block9;
                System.err.println("ResourcesDbException in buildHaworth(): " + me.getMessage());
            }
        }
    }

    public static void updateHaworthRepresentations(Monosaccharide ms) {
        ResidueRepresentation monoRep;
        Haworth h;
        block11: {
            block10: {
                try {
                    h = MonosaccharideDataBuilder.buildHaworth(ms);
                }
                catch (ResourcesDbException me) {
                    if (Config.getGlobalConfig().isPrintErrorMsgs(1)) {
                        System.err.println("ResourcesDbException in buildHaworth(): " + me.getMessage());
                    }
                    return;
                }
                monoRep = ms.getRepresentation(ResidueRepresentationType.HAWORTH, ResidueRepresentationFormat.PNG);
                if (monoRep == null) {
                    monoRep = new ResidueRepresentation(ResidueRepresentationType.HAWORTH, ResidueRepresentationFormat.PNG);
                    ms.addRepresentation(monoRep);
                }
                monoRep.setSize(h.getSvgWidth(), h.getSvgHeight());
                try {
                    monoRep.setData(h.createPngImage());
                }
                catch (Exception ex) {
                    if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block10;
                    System.err.println("Exception in updateHaworthRepresentation(): " + ex);
                }
            }
            monoRep = ms.getRepresentation(ResidueRepresentationType.HAWORTH, ResidueRepresentationFormat.JPG);
            if (monoRep == null) {
                monoRep = new ResidueRepresentation(ResidueRepresentationType.HAWORTH, ResidueRepresentationFormat.JPG);
                ms.addRepresentation(monoRep);
            }
            monoRep.setSize(h.getSvgWidth(), h.getSvgHeight());
            try {
                monoRep.setData(h.createJpgImage());
            }
            catch (Exception ex) {
                if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block11;
                System.err.println("Exception in updateHaworthRepresentation(): " + ex);
            }
        }
        monoRep = ms.getRepresentation(ResidueRepresentationType.HAWORTH, ResidueRepresentationFormat.SVG);
        if (monoRep == null) {
            monoRep = new ResidueRepresentation(ResidueRepresentationType.HAWORTH, ResidueRepresentationFormat.SVG);
            ms.addRepresentation(monoRep);
        }
        monoRep.setSize(h.getSvgWidth(), h.getSvgHeight());
        monoRep.setData(h.getSvgByteArr());
    }

    public static void addFischerRepresentations(Monosaccharide ms) {
        block9: {
            Fischer f;
            block8: {
                try {
                    f = MonosaccharideDataBuilder.buildFischer(ms);
                }
                catch (ResourcesDbException me) {
                    if (Config.getGlobalConfig().isPrintErrorMsgs(1)) {
                        System.err.println("ResourcesDbException in buildFischer(): " + me.getMessage());
                    }
                    return;
                }
                ResidueRepresentation monoRepSvg = new ResidueRepresentation();
                monoRepSvg.setFormat(ResidueRepresentationFormat.SVG);
                monoRepSvg.setType(ResidueRepresentationType.FISCHER);
                monoRepSvg.setWidth(f.getSvgWidth());
                monoRepSvg.setHeight(f.getSvgHeight());
                monoRepSvg.setData(f.getSvgByteArr());
                if (monoRepSvg.getData() != null) {
                    ms.addRepresentation(monoRepSvg);
                }
                ResidueRepresentation monoRepPng = new ResidueRepresentation();
                monoRepPng.setFormat(ResidueRepresentationFormat.PNG);
                monoRepPng.setType(ResidueRepresentationType.FISCHER);
                monoRepPng.setWidth(f.getSvgWidth());
                monoRepPng.setHeight(f.getSvgHeight());
                try {
                    monoRepPng.setData(f.createPngImage());
                    ms.addRepresentation(monoRepPng);
                }
                catch (Exception ex) {
                    if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block8;
                    System.err.println("Exception in addFischerRepresentation(): " + ex);
                }
            }
            ResidueRepresentation monoRepJpg = new ResidueRepresentation();
            monoRepJpg.setFormat(ResidueRepresentationFormat.JPG);
            monoRepJpg.setType(ResidueRepresentationType.FISCHER);
            monoRepJpg.setWidth(f.getSvgWidth());
            monoRepJpg.setHeight(f.getSvgHeight());
            try {
                monoRepJpg.setData(f.createJpgImage());
                ms.addRepresentation(monoRepJpg);
            }
            catch (Exception ex) {
                if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block9;
                System.err.println("Exception in addFischerRepresentation(): " + ex);
            }
        }
    }

    public static void updateFischerRepresentations(Monosaccharide ms) {
        ResidueRepresentation monoRep;
        Fischer f;
        block11: {
            block10: {
                try {
                    f = MonosaccharideDataBuilder.buildFischer(ms);
                }
                catch (ResourcesDbException me) {
                    if (Config.getGlobalConfig().isPrintErrorMsgs(1)) {
                        System.err.println("ResourcesDbException in buildFischer(): " + me.getMessage());
                        me.printStackTrace();
                    }
                    return;
                }
                monoRep = ms.getRepresentation(ResidueRepresentationType.FISCHER, ResidueRepresentationFormat.PNG);
                if (monoRep == null) {
                    monoRep = new ResidueRepresentation(ResidueRepresentationType.FISCHER, ResidueRepresentationFormat.PNG);
                    ms.addRepresentation(monoRep);
                }
                monoRep.setSize(f.getSvgWidth(), f.getSvgHeight());
                try {
                    monoRep.setData(f.createPngImage());
                }
                catch (Exception ex) {
                    if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block10;
                    System.err.println("Exception in updateFischerRepresentation(): " + ex);
                }
            }
            monoRep = ms.getRepresentation(ResidueRepresentationType.FISCHER, ResidueRepresentationFormat.JPG);
            if (monoRep == null) {
                monoRep = new ResidueRepresentation(ResidueRepresentationType.FISCHER, ResidueRepresentationFormat.JPG);
                ms.addRepresentation(monoRep);
            }
            monoRep.setSize(f.getSvgWidth(), f.getSvgHeight());
            try {
                monoRep.setData(f.createJpgImage());
            }
            catch (Exception ex) {
                if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block11;
                System.err.println("Exception in updateFischerRepresentation(): " + ex);
            }
        }
        monoRep = ms.getRepresentation(ResidueRepresentationType.FISCHER, ResidueRepresentationFormat.SVG);
        if (monoRep == null) {
            monoRep = new ResidueRepresentation(ResidueRepresentationType.FISCHER, ResidueRepresentationFormat.SVG);
            ms.addRepresentation(monoRep);
        }
        monoRep.setSize(f.getSvgWidth(), f.getSvgHeight());
        monoRep.setData(f.getSvgByteArr());
    }

    public static void buildAtoms(Monosaccharide ms) throws ResourcesDbException {
        MonosaccharideDataBuilder.buildAtoms(ms, Config.getGlobalConfig());
    }

    public static void buildAtoms(Monosaccharide ms, Config conf) throws ResourcesDbException {
        if (ms.getBasetype().getAtoms() == null || ms.getBasetype().getAtoms().size() == 0) {
            ms.getBasetype().buildAtoms(conf);
        }
        ms.setAtoms(ms.getBasetype().getAtomListClone());
        for (Substitution subst : ms.getSubstitutions()) {
            if (subst.hasUncertainLinkagePosition()) {
                throw new MonosaccharideException("Cannot build atoms for monosaccharide with uncertain substitution position.");
            }
            if (subst.hasUncertainSubstituentPosition()) {
                throw new MonosaccharideException("Cannot build atoms for monosaccharide with uncertain substituent position.");
            }
            List<Atom> substAtomsClone = subst.getTemplate().getAtomListClone();
            if (subst.getReplacedAtom1() != null) {
                Atom.removeAtomFromList(substAtomsClone, subst.getReplacedAtom1(), true);
            }
            if (subst.getReplacedAtom2() != null) {
                Atom.removeAtomFromList(substAtomsClone, subst.getReplacedAtom2(), true);
            }
            Atom substLinkAtom1 = null;
            Atom substLinkAtom2 = null;
            for (Atom a : substAtomsClone) {
                if (a.equals(subst.getLinkingAtom1())) {
                    substLinkAtom1 = a;
                }
                if (!subst.hasPosition2() || !a.equals(subst.getLinkingAtom2())) continue;
                substLinkAtom2 = a;
            }
            if (substLinkAtom1 == null) {
                throw new ResourcesDbException("Cannot find substituent atom to link to the basetype");
            }
            if (subst.hasPosition2() && substLinkAtom2 == null) {
                throw new ResourcesDbException("Cannot find substituent atom2 to link to the basetype");
            }
            if (subst.getIntValuePosition1() == ms.getRingEnd()) {
                Atom anomericAtom;
                int hCount = substLinkAtom1.countConnectedAtoms("H");
                if (hCount > 0) {
                    Atom h = substLinkAtom1.getConnectedAtom("H", hCount);
                    Atom.removeAtomFromList(substAtomsClone, h, false);
                }
                if ((anomericAtom = ms.getAtomByName(AtomTemplate.BB_C.formatAtomName(ms.getRingStart()))) == null) {
                    throw new ResourcesDbException("Cannot find anomeric carbon in basetype atoms.");
                }
                substLinkAtom1.addConnection(anomericAtom, 1.0);
            }
            int pos1 = subst.getIntValuePosition1();
            for (Atom a : substAtomsClone) {
                a.setName(String.valueOf(a.getName()) + "_" + pos1);
            }
            ms.getAtoms().addAll(substAtomsClone);
            MonosaccharideDataBuilder.linkSubstituentToMs(ms, pos1, subst.getLinkagetype1(), substLinkAtom1, subst.getBondOrder1());
            if (!subst.hasPosition2()) continue;
            MonosaccharideDataBuilder.linkSubstituentToMs(ms, subst.getIntValuePosition2(), subst.getLinkagetype2(), substLinkAtom2, subst.getBondOrder2());
        }
    }

    public static void linkSubstituentToMs(Monosaccharide ms, int pos, LinkageType linktype, Atom substLinkatom, double bo) throws ResourcesDbException {
        Atom msLinkatom = null;
        Atom msRemoveAtom = null;
        if (linktype.equals((Object)LinkageType.H_AT_OH)) {
            msLinkatom = ms.getAtomByName(AtomTemplate.BB_O.formatAtomName(pos));
            if (msLinkatom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to link the substituent not found.");
            }
            msRemoveAtom = ms.getAtomByName(AtomTemplate.BB_HO.formatAtomName(pos));
            if (msRemoveAtom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to be removed not found.");
            }
            ms.removeAtom(msRemoveAtom, true);
        } else if (linktype.equals((Object)LinkageType.DEOXY)) {
            msLinkatom = ms.getAtomByName(AtomTemplate.BB_C.formatAtomName(pos));
            if (msLinkatom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to link the substituent not found.");
            }
            msRemoveAtom = ms.getAtomByName(AtomTemplate.BB_O.formatAtomName(pos));
            if (msRemoveAtom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to be removed not found.");
            }
            ms.removeAtom(msRemoveAtom, true);
        } else if (linktype.equals((Object)LinkageType.H_LOSE)) {
            msLinkatom = ms.getAtomByName(AtomTemplate.BB_C.formatAtomName(pos));
            if (msLinkatom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to link the substituent not found.");
            }
            msRemoveAtom = ms.getAtomByName(AtomTemplate.BB_H.formatAtomName(pos));
            if (msRemoveAtom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to be removed not found.");
            }
            ms.removeAtom(msRemoveAtom, true);
        } else if (linktype.equals((Object)LinkageType.R_CONFIG)) {
            msLinkatom = ms.getAtomByName(AtomTemplate.BB_C.formatAtomName(pos));
            if (msLinkatom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to link the substituent not found.");
            }
            msRemoveAtom = ms.getAtomByName(AtomTemplate.BB_HX.formatAtomName(pos, 0));
            if (msRemoveAtom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to be removed not found.");
            }
            ms.removeAtom(msRemoveAtom, true);
            ms.getAtomByName(AtomTemplate.BB_HX.formatAtomName(pos, 1)).setName(AtomTemplate.BB_H.formatAtomName(pos));
        } else if (linktype.equals((Object)LinkageType.S_CONFIG)) {
            msLinkatom = ms.getAtomByName(AtomTemplate.BB_C.formatAtomName(pos));
            if (msLinkatom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to link the substituent not found.");
            }
            msRemoveAtom = ms.getAtomByName(AtomTemplate.BB_HX.formatAtomName(pos, 0));
            if (msRemoveAtom == null) {
                throw new MonosaccharideException("Cannot link substituent to ms: ms atom to be removed not found.");
            }
            ms.removeAtom(msRemoveAtom, true);
            ms.getAtomByName(AtomTemplate.BB_HX.formatAtomName(pos, 1)).setName(AtomTemplate.BB_H.formatAtomName(pos));
        }
        msLinkatom.addConnection(substLinkatom, bo);
        substLinkatom.addConnection(msLinkatom, bo);
    }

    public static ArrayList<MonosaccharideLinkingPosition> buildPossibleLinkagePositions(Monosaccharide ms) {
        ArrayList<MonosaccharideLinkingPosition> linkPosList = new ArrayList<MonosaccharideLinkingPosition>();
        int pos = 1;
        while (pos <= ms.getSize()) {
            if (pos != ms.getRingEnd() && (pos != ms.getRingStart() || ms.getRingEnd() != -1)) {
                boolean isLinkable = true;
                for (CoreModification mod : ms.getCoreModificationsByPosition(pos)) {
                    if (CoreModificationTemplate.DEOXY.equals((Object)mod.getTemplate())) {
                        isLinkable = false;
                        break;
                    }
                    if (CoreModificationTemplate.ACID.equals((Object)mod.getTemplate())) {
                        isLinkable = false;
                        break;
                    }
                    if (CoreModificationTemplate.ANHYDRO.equals((Object)mod.getTemplate())) {
                        isLinkable = false;
                        break;
                    }
                    if (CoreModificationTemplate.YN.equals((Object)mod.getTemplate())) {
                        isLinkable = false;
                        break;
                    }
                    if (CoreModificationTemplate.LACTONE.equals((Object)mod.getTemplate())) {
                        isLinkable = false;
                        break;
                    }
                    if (!CoreModificationTemplate.KETO.equals((Object)mod.getTemplate()) || pos == ms.getRingStart()) continue;
                    isLinkable = false;
                    break;
                }
                if (isLinkable) {
                    MonosaccharideLinkingPosition linkPos = new MonosaccharideLinkingPosition(pos);
                    if (pos == ms.getRingStart() && ms.getRingEnd() > 0) {
                        linkPos.setIsAnomeric(true);
                    }
                    for (Substitution subst : ms.getSubstitutionsByPosition(pos)) {
                        if (!LinkageType.DEOXY.equals((Object)subst.getLinkagetypeByPosition(pos)) && !LinkageType.H_AT_OH.equals((Object)subst.getLinkagetypeByPosition(pos))) continue;
                        if (subst.getTemplate().isLinkable()) {
                            linkPos.setLinkingSubstitution(subst);
                            continue;
                        }
                        isLinkable = false;
                        break;
                    }
                    if (isLinkable) {
                        linkPosList.add(linkPos);
                    }
                }
            }
            ++pos;
        }
        return linkPosList;
    }

    public static void buildDerivativeData(Monosaccharide ms, TemplateContainer container) throws ResourcesDbException {
        ms.getBasetype().buildName();
        ms.getBasetype().buildAtoms();
        ms.getBasetype().buildComposition();
        ms.getBasetype().getConfiguration();
        ms.buildName();
        MonosaccharideDataBuilder.buildSynonyms(ms, container);
        try {
            MonosaccharideDataBuilder.buildAtoms(ms);
        }
        catch (ResourcesDbException ex) {
            ms.setAtoms(new ArrayList<Atom>());
        }
        try {
            MonosaccharideDataBuilder.buildComposition(ms);
        }
        catch (ResourcesDbException ex) {
            ms.setComposition(new Composition());
        }
        ms.calculateMassesFromComposition();
    }
}

