/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.fragment.PersubstitutionType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.eurocarbdb.resourcesdb.monosaccharide.Modification;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentAlias;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplateContainer;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Substitution
extends Modification
implements Cloneable {
    private SubstituentTemplate template = null;
    private LinkageType linkagetype1 = null;
    private LinkageType linkagetype2 = null;
    private LinkageType sourceLinkagetype1 = null;
    private LinkageType sourceLinkagetype2 = null;
    private ArrayList<Integer> substituentPosition1 = new ArrayList();
    private ArrayList<Integer> substituentPosition2 = new ArrayList();
    private int dbId;
    private boolean hasSeparateDisplayPart = false;

    public Substitution(String name, int position1) throws ResourcesDbException {
        this(name, position1, null);
    }

    public Substitution(String name, int position1, TemplateContainer cont) throws ResourcesDbException {
        this.setTemplateContainer(cont);
        this.setTemplate(this.getSubstContainer().forName(GlycanNamescheme.GLYCOCT, name));
        if (this.getTemplate() == null) {
            throw new ResourcesDbException("Unknown substituent name: " + name);
        }
        this.setName(this.getTemplate().getName());
        this.setPosition1(position1);
        this.setSubstituentPosition1(this.getTemplate().getDefaultLinkingPosition1());
        this.setLinkagetype1(this.getTemplate().getDefaultLinkagetype1());
    }

    public Substitution(String name, int position1, LinkageType linktype1, int substPosition1) throws ResourcesDbException {
        this(name, position1, linktype1, substPosition1, null);
    }

    public Substitution(String name, int position1, LinkageType linktype1, int substPosition1, TemplateContainer cont) throws ResourcesDbException {
        this.setTemplateContainer(cont);
        this.setTemplate(this.getSubstContainer().forName(GlycanNamescheme.GLYCOCT, name));
        if (this.getTemplate() == null) {
            throw new ResourcesDbException("Unknown substituent name: " + name);
        }
        this.setName(this.getTemplate().getName());
        this.setPosition1(position1);
        this.setSubstituentPosition1(substPosition1);
        this.setLinkagetype1(linktype1);
    }

    public Substitution(String name, int position1, int position2) throws ResourcesDbException {
        this(name, position1, position2, null);
    }

    public Substitution(String name, int position1, int position2, TemplateContainer cont) throws ResourcesDbException {
        this.setTemplateContainer(cont);
        this.setTemplate(this.getSubstContainer().forName(GlycanNamescheme.GLYCOCT, name));
        if (this.getTemplate() == null) {
            throw new MonosaccharideException("Unknown substituent name: " + name);
        }
        if (this.getTemplate().getMaxValence() != 2) {
            throw new MonosaccharideException("Cannot handle " + this.getTemplate().getName() + " as a divalent substituent");
        }
        this.setPosition1(position1);
        this.addSubstituentPosition1(this.getTemplate().getDefaultLinkingPosition1());
        this.setLinkagetype1(this.getTemplate().getDefaultLinkagetype1());
        this.setPosition2(position2);
        this.addSubstituentPosition2(this.getTemplate().getDefaultLinkingPosition2());
        this.setLinkagetype2(this.getTemplate().getDefaultLinkagetype2());
    }

    public Substitution(String name, int position1, LinkageType linktype1, int substPosition1, int position2, LinkageType linktype2, int substPosition2) throws ResourcesDbException {
        this(name, position1, linktype1, substPosition1, position2, linktype2, substPosition2, null, null);
    }

    public Substitution(String name, int position1, LinkageType linktype1, int substPosition1, int position2, LinkageType linktype2, int substPosition2, Config conf, TemplateContainer cont) throws ResourcesDbException {
        this.setConfig(conf);
        this.setTemplateContainer(cont);
        this.setTemplate(this.getSubstContainer().forName(GlycanNamescheme.GLYCOCT, name));
        if (this.getTemplate() == null) {
            throw new MonosaccharideException("Unknown substituent name: " + name);
        }
        if (this.getTemplate().getMaxValence() != 2) {
            throw new MonosaccharideException("Cannot handle " + this.getTemplate().getName() + " as a divalent substituent");
        }
        this.setName(this.getTemplate().getName());
        this.setPosition1(position1);
        this.setSubstituentPosition1(substPosition1);
        this.setLinkagetype1(linktype1);
        this.setPosition2(position2);
        this.setSubstituentPosition2(substPosition2);
        this.setLinkagetype2(linktype2);
    }

    public Substitution(SubstituentExchangeObject exchSubst) throws ResourcesDbException {
        this(exchSubst, exchSubst.getConfig(), exchSubst.getTemplateContainer());
    }

    public Substitution(SubstituentExchangeObject exchSubst, TemplateContainer cont) throws ResourcesDbException {
        this(exchSubst, exchSubst.getConfig(), cont);
    }

    public Substitution(SubstituentExchangeObject exchSubst, Config conf, TemplateContainer cont) throws ResourcesDbException {
        this(exchSubst, exchSubst.getNamescheme(), conf, cont);
    }

    public Substitution(SubstituentExchangeObject exchSubst, GlycanNamescheme sourceScheme, Config conf, TemplateContainer cont) throws ResourcesDbException {
        this.setTemplateContainer(cont);
        this.setConfig(conf);
        this.setTemplate(this.getSubstContainer().forName(sourceScheme, exchSubst.getName()));
        if (this.getTemplate() == null) {
            throw new MonosaccharideException("cannot get template for substituent " + exchSubst.getName());
        }
        this.setName(this.getTemplate().getName());
        this.setLinkagetype1(exchSubst.getLinkagetype1());
        this.setLinkagetype2(exchSubst.getLinkagetype2());
        this.setSourceLinkagetype1(exchSubst.getLinkagetype1());
        this.setSourceLinkagetype2(exchSubst.getLinkagetype2());
        this.setSubstituentPosition1(exchSubst.getSubstituentPosition1());
        this.setSubstituentPosition2(exchSubst.getSubstituentPosition2());
        this.setPosition1(exchSubst.getPosition1());
        this.setPosition2(exchSubst.getPosition2());
        this.setSourceName(exchSubst.getName());
        if (this.getPosition2() != null && this.getPosition2().size() > 0) {
            this.setValence(2);
        } else {
            this.setValence(1);
        }
    }

    public Substitution() {
        this((TemplateContainer)null);
    }

    public Substitution(TemplateContainer cont) {
        this.setTemplateContainer(cont);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name == null) {
            this.setTemplate(null);
        } else if (this.getTemplate() == null || !this.getTemplate().getName().equals(name)) {
            try {
                this.setTemplate(this.getSubstContainer().forName(GlycanNamescheme.GLYCOCT, name));
            }
            catch (ResourcesDbException rex) {
                if (this.getConfig().isPrintErrorMsgs()) {
                    System.err.println("exception in Substitution.setName(): " + rex);
                }
                this.setTemplate(null);
            }
        }
    }

    public void setNameWithoutTemplateAdjustment(String name) {
        super.setName(name);
    }

    public SubstituentTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(SubstituentTemplate template) {
        this.template = template;
        if (template == null) {
            super.setName(null);
        } else {
            super.setName(template.getName());
        }
    }

    public SubstituentAlias getName(GlycanNamescheme scheme) throws ResourcesDbException {
        return this.template.getPrimaryAlias(scheme, this.getLinkagetype1());
    }

    public LinkageType getLinkagetype1() {
        return this.linkagetype1;
    }

    public String getLinkagetypeStr1() {
        return this.getLinkagetype1().name();
    }

    public void setLinkagetype1(LinkageType linkagetype) {
        this.linkagetype1 = linkagetype;
    }

    public void setLinkagetypeStr1(String linktypeStr) {
        this.linkagetype1 = SubstituentTemplate.getLinkageTypeByLinkageName(linktypeStr);
    }

    public LinkageType getLinkagetype2() {
        return this.linkagetype2;
    }

    public String getLinkagetypeStr2() {
        if (this.getLinkagetype2() == null) {
            return null;
        }
        return this.getLinkagetype2().name();
    }

    public void setLinkagetype2(LinkageType linkagetype) {
        this.linkagetype2 = linkagetype;
    }

    public void setLinkagetypeStr2(String linktypeStr) {
        this.linkagetype2 = SubstituentTemplate.getLinkageTypeByLinkageName(linktypeStr);
    }

    public LinkageType getLinkagetypeByPosition(int pos) {
        for (Integer posInt : this.getPosition1()) {
            if (posInt != pos) continue;
            return this.getLinkagetype1();
        }
        for (Integer posInt : this.getPosition2()) {
            if (posInt != pos) continue;
            return this.getLinkagetype2();
        }
        return null;
    }

    public LinkageType getSourceLinkagetype1() {
        return this.sourceLinkagetype1;
    }

    public void setSourceLinkagetype1(LinkageType sourceLinkagetype1) {
        this.sourceLinkagetype1 = sourceLinkagetype1;
    }

    public LinkageType getSourceLinkagetype2() {
        return this.sourceLinkagetype2;
    }

    public void setSourceLinkagetype2(LinkageType sourceLinkagetype2) {
        this.sourceLinkagetype2 = sourceLinkagetype2;
    }

    public ArrayList<Integer> getSubstituentPosition1() {
        return this.substituentPosition1;
    }

    public int getIntValueSubstituentPosition1() {
        if (this.getSubstituentPosition1().size() == 0) {
            return -1;
        }
        if (this.getSubstituentPosition1().size() == 1) {
            return this.getSubstituentPosition1().get(0);
        }
        return 0;
    }

    public void setIntValueSubstituentPosition1(int position) throws MonosaccharideException {
        this.setSubstituentPosition1(position);
    }

    public ArrayList<Integer> getSubstituentPosition1Clone() {
        return Utils.cloneIntegerList(this.substituentPosition1);
    }

    public String getSubstituentPosition1Str(String delimiter, String unknownPositionLabel) {
        return Utils.formatPositionsString(this.getSubstituentPosition1(), delimiter, unknownPositionLabel);
    }

    public void setSubstituentPosition1(ArrayList<Integer> substituentPosition1) {
        this.substituentPosition1 = substituentPosition1;
    }

    public void setSubstituentPosition1(int position1) {
        if (this.getSubstituentPosition1() == null) {
            this.setSubstituentPosition1(new ArrayList<Integer>());
        } else {
            this.getSubstituentPosition1().clear();
        }
        if (position1 != -1) {
            this.addSubstituentPosition1(position1);
        }
    }

    public void addSubstituentPosition1(int position) {
        this.getSubstituentPosition1().add(position);
    }

    public ArrayList<Integer> getSubstituentPosition2() {
        return this.substituentPosition2;
    }

    public int getIntValueSubstituentPosition2() {
        if (this.getSubstituentPosition2().size() == 0) {
            return -1;
        }
        if (this.getSubstituentPosition2().size() == 1) {
            return this.getSubstituentPosition2().get(0);
        }
        return 0;
    }

    public void setIntValueSubstituentPosition2(int position) throws MonosaccharideException {
        this.setSubstituentPosition2(position);
    }

    public ArrayList<Integer> getSubstituentPosition2Clone() {
        return Utils.cloneIntegerList(this.substituentPosition2);
    }

    public String getSubstitutentPosition2Str(String delimiter, String unknownPositionLabel) {
        return Utils.formatPositionsString(this.getSubstituentPosition2(), delimiter, unknownPositionLabel);
    }

    public void setSubstituentPosition2(ArrayList<Integer> substituentPosition2) {
        this.substituentPosition2 = substituentPosition2;
    }

    public void setSubstituentPosition2(int position2) {
        if (this.getSubstituentPosition2() == null) {
            this.setSubstituentPosition2(new ArrayList<Integer>());
        } else {
            this.getSubstituentPosition2().clear();
        }
        if (position2 != -1) {
            this.addSubstituentPosition2(position2);
        }
    }

    public void addSubstituentPosition2(int position) {
        this.getSubstituentPosition2().add(position);
    }

    public boolean hasUncertainSubstituentPosition() {
        if (this.getIntValueSubstituentPosition1() == 0) {
            return true;
        }
        return this.hasPosition2() && this.getIntValueSubstituentPosition2() == 0;
    }

    public Atom getLinkingAtom1() throws ResourcesDbException {
        return this.getTemplate().getLinkingAtom(this.getIntValueSubstituentPosition1());
    }

    public Atom getLinkingAtom2() throws ResourcesDbException {
        return this.getTemplate().getLinkingAtom(this.getIntValueSubstituentPosition2());
    }

    public double getBondOrder1() throws ResourcesDbException {
        return this.getTemplate().getBondOrder(this.getIntValueSubstituentPosition1());
    }

    public double getBondOrder2() throws ResourcesDbException {
        return this.getTemplate().getBondOrder(this.getIntValueSubstituentPosition2());
    }

    public Atom getReplacedAtom1() {
        try {
            return this.getTemplate().getReplacedAtom(this.getIntValueSubstituentPosition1());
        }
        catch (ResourcesDbException e) {
            return null;
        }
    }

    public Atom getReplacedAtom2() {
        if (!this.hasPosition2()) {
            return null;
        }
        try {
            return this.getTemplate().getReplacedAtom(this.getIntValueSubstituentPosition2());
        }
        catch (ResourcesDbException e) {
            return null;
        }
    }

    public void setSubstitution(SubstituentTemplate substTemplate, int position) throws MonosaccharideException {
        if (substTemplate == null) {
            this.setSubstitution(null, position, null);
        } else {
            this.setSubstitution(substTemplate, position, substTemplate.getDefaultLinkagetype1());
        }
    }

    public void setSubstitution(SubstituentTemplate substTemplate, int position, LinkageType linktype) throws MonosaccharideException {
        if (substTemplate == null) {
            this.setSubstitution(null, position, linktype, 0);
        } else {
            this.setSubstitution(substTemplate, position, linktype, substTemplate.getDefaultLinkingPosition1());
        }
    }

    public void setSubstitution(SubstituentTemplate substTemplate, int position, LinkageType linktype, int substPosition) throws MonosaccharideException {
        if (substTemplate == null) {
            this.setName(null);
        } else {
            this.setName(substTemplate.getName());
        }
        this.setTemplate(substTemplate);
        this.setPosition1(position);
        this.setSubstituentPosition1(substPosition);
        this.setLinkagetype1(linktype);
        this.setValence(1);
    }

    public void setDivalentSubstitution(SubstituentTemplate substTemplate, int position1, int position2) throws MonosaccharideException {
        this.setName(substTemplate.getName());
        this.setTemplate(substTemplate);
        if (position1 > position2 && position2 != 0) {
            int tmpPosition = position1;
            position1 = position2;
            position2 = tmpPosition;
        }
        this.setPosition1(position1);
        this.setPosition2(position2);
        this.setValence(2);
        this.setSubstituentPosition1(substTemplate.getDefaultLinkingPosition1());
        this.setLinkagetype1(this.getTemplate().getDefaultLinkagetype1());
        this.setSubstituentPosition2(substTemplate.getDefaultLinkingPosition2());
        this.setLinkagetype2(this.getTemplate().getDefaultLinkagetype2());
    }

    public void setDivalentSubstitution(SubstituentTemplate substTemplate, int position1, LinkageType linktype1, int substPosition1, int position2, LinkageType linktype2, int substPosition2) throws MonosaccharideException {
        this.setName(substTemplate.getName());
        this.setTemplate(substTemplate);
        if (position1 > position2 && position2 != 0) {
            int tmpPosition = position1;
            position1 = position2;
            position2 = tmpPosition;
        }
        this.setPosition1(position1);
        this.setPosition2(position2);
        this.setValence(2);
        this.setSubstituentPosition1(substPosition1);
        this.setLinkagetype1(linktype1);
        this.setSubstituentPosition2(substPosition2);
        this.setLinkagetype2(linktype2);
    }

    public void alterSubstituentTemplate(SubstituentTemplate substTemplate) throws MonosaccharideException {
        if (substTemplate.getMaxValence() < this.getValence() || substTemplate.getMinValence() > this.getValence()) {
            throw new MonosaccharideException("Valence mismatch when altering substituent");
        }
        this.setTemplate(substTemplate);
    }

    public String getResidueIncludedName(GlycanNamescheme scheme) throws ResourcesDbException {
        String name = this.getTemplate().getResidueIncludedName(scheme, this.getLinkagetype1());
        return name;
    }

    public String getSeparateDisplay(GlycanNamescheme scheme) throws ResourcesDbException {
        return this.getTemplate().getSeparateDisplay(scheme, this.getLinkagetype1());
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public SubstituentTemplateContainer getSubstContainer() {
        return this.getTemplateContainer().getSubstituentTemplateContainer();
    }

    public boolean isHasSeparateDisplayPart() {
        return this.hasSeparateDisplayPart;
    }

    public void setHasSeparateDisplayPart(boolean hasSeparateDisplayPart) {
        this.hasSeparateDisplayPart = hasSeparateDisplayPart;
    }

    public void setDefaultLinkageDataFromTemplate(GlycanNamescheme scheme, SubstituentTemplate tmpl) {
        this.setLinkagetype1(this.template.getDefaultLinkagetype1());
        this.setLinkagetype2(this.template.getDefaultLinkagetype2());
        this.getSubstituentPosition1().clear();
        this.addSubstituentPosition1(this.template.getDefaultLinkingPosition1());
        this.getSubstituentPosition2().clear();
        this.addSubstituentPosition2(this.template.getDefaultLinkingPosition2());
    }

    public double getMonoMass(PersubstitutionType persubst) {
        return 0.0;
    }

    public double getAvgMass(PersubstitutionType persubst) {
        return 0.0;
    }

    @Override
    public void init() {
        super.init();
        this.setLinkagetype1(null);
        this.setLinkagetype2(null);
        this.setDbId(0);
        this.setSubstituentPosition1(new ArrayList<Integer>());
        this.setSubstituentPosition2(new ArrayList<Integer>());
        this.setTemplate(null);
    }

    @Override
    public Substitution clone() {
        Substitution substClone = new Substitution();
        substClone.setName(this.getName());
        substClone.setTemplate(this.getTemplate());
        substClone.setValence(this.getValence());
        substClone.setPosition1(this.getPosition1Clone());
        substClone.setPosition2(this.getPosition2Clone());
        substClone.setLinkagetype1(this.getLinkagetype1());
        substClone.setLinkagetype2(this.getLinkagetype1());
        substClone.setSubstituentPosition1(this.getSubstituentPosition1Clone());
        substClone.setSubstituentPosition2(this.getSubstituentPosition2Clone());
        substClone.setTemplateContainer(this.getTemplateContainer());
        return substClone;
    }

    @Override
    public String toString() {
        String outStr = super.toString();
        outStr = outStr.substring(0, outStr.length() - 1);
        outStr = String.valueOf(outStr) + "; Linkage: " + (Object)((Object)this.getLinkagetype1()) + this.getSubstituentPosition1();
        if (this.hasPosition2()) {
            outStr = String.valueOf(outStr) + "/" + (Object)((Object)this.getLinkagetype2()) + this.getSubstituentPosition2();
        }
        outStr = String.valueOf(outStr) + "]";
        return outStr;
    }
}

