/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.representation;

import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationFormat;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationType;

public class ResidueRepresentation {
    private ResidueRepresentationType type;
    private ResidueRepresentationFormat format;
    private int residueId;
    private int dbId;
    private int width;
    private int height;
    private boolean locked;
    private byte[] data;

    public ResidueRepresentation() {
        this.init();
    }

    public ResidueRepresentation(ResidueRepresentationType type, ResidueRepresentationFormat format) {
        this.init();
        this.setType(type);
        this.setFormat(format);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setData(String dataStr) {
        this.setData(dataStr.getBytes());
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public ResidueRepresentationFormat getFormat() {
        return this.format;
    }

    public void setFormat(ResidueRepresentationFormat repFormat) {
        this.format = repFormat;
    }

    public String getFormatStr() {
        if (this.getFormat() == null) {
            return null;
        }
        return this.getFormat().getFormatName();
    }

    public void setFormatStr(String formatName) {
        ResidueRepresentationFormat repFormat = ResidueRepresentationFormat.forName(formatName);
        this.setFormat(repFormat);
    }

    public boolean checkFormatAndTypeConsistency() {
        return this.getFormat() != null && this.getType() != null && this.getFormat().getFormatType().equals(this.getType().getFormatType());
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMonosaccharideId() {
        return this.residueId;
    }

    public void setMonosaccharideId(int monosaccharideId) {
        this.residueId = monosaccharideId;
    }

    public ResidueRepresentationType getType() {
        return this.type;
    }

    public void setType(ResidueRepresentationType type) {
        this.type = type;
    }

    public String getTypeStr() {
        if (this.getType() == null) {
            return null;
        }
        return this.getType().getTypeName();
    }

    public void setTypeStr(String typeStr) {
        this.setType(ResidueRepresentationType.forName(typeStr));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean lockedFlag) {
        this.locked = lockedFlag;
    }

    public void init() {
        this.setDbId(0);
        this.setMonosaccharideId(0);
        this.setData((byte[])null);
        this.setFormat(null);
        this.setType(null);
        this.setWidth(0);
        this.setHeight(0);
        this.setLocked(false);
    }

    public String toString() {
        String outStr = "";
        outStr = String.valueOf(outStr) + "ResidueRepresentation[type: " + this.getTypeStr() + " format: " + this.getFormatStr() + " width: " + this.getWidth() + " height: " + this.getHeight() + " data size: ";
        outStr = this.getData() == null ? String.valueOf(outStr) + "0" : String.valueOf(outStr) + this.getData().length;
        outStr = String.valueOf(outStr) + "]";
        return outStr;
    }
}

