/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentAlias;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentSubpartTreeNode;
import org.eurocarbdb.resourcesdb.template.NonBasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstituentTemplate
extends NonBasetypeTemplate {
    public static String AMINOTEMPLATENAME = "amino";
    private boolean canReplaceRingOxygen = false;
    private boolean isLinkable = false;
    private String ringOxygenPositionName = null;
    private String haworthName;
    private String mirroredHaworthName;
    private String oLinkedEquivalent;
    private HashMap<GlycanNamescheme, HashMap<LinkageType, SubstituentAlias>> primaryAliasMap = new HashMap();
    private List<SubstituentAlias> aliasList;
    private SubstituentSubpartTreeNode subparts;
    private int dbId;

    public SubstituentTemplate() {
        this.init();
    }

    public String getHaworthName() {
        return this.haworthName;
    }

    public void setHaworthName(String haworthName) {
        this.haworthName = haworthName;
    }

    public String getMirroredHaworthName() {
        return this.mirroredHaworthName;
    }

    public void setMirroredHaworthName(String mirroredName) {
        this.mirroredHaworthName = mirroredName;
    }

    public String getRingOxygenPositionName() {
        return this.ringOxygenPositionName;
    }

    public void setRingOxygenPositionName(String ropName) {
        this.ringOxygenPositionName = ropName;
    }

    public LinkageType getDefaultLinkagetype1() {
        if (this.getValidLinkingPosition(this.getDefaultLinkingPosition1()) != null) {
            return this.getValidLinkingPosition(this.getDefaultLinkingPosition1()).getDefaultLinktype();
        }
        return null;
    }

    public LinkageType getDefaultLinkagetype2() {
        if (this.getValidLinkingPosition(this.getDefaultLinkingPosition2()) != null) {
            return this.getValidLinkingPosition(this.getDefaultLinkingPosition2()).getDefaultLinktype();
        }
        return null;
    }

    public boolean isCanReplaceRingOxygen() {
        return this.canReplaceRingOxygen;
    }

    public void setCanReplaceRingOxygen(boolean canReplaceRingOxygen) {
        this.canReplaceRingOxygen = canReplaceRingOxygen;
    }

    public SubstituentAlias getPrimaryAlias(GlycanNamescheme namescheme, LinkageType linktype) throws ResourcesDbException {
        HashMap<LinkageType, SubstituentAlias> tempMap = this.primaryAliasMap.get((Object)namescheme);
        if (tempMap == null && (tempMap = this.primaryAliasMap.get((Object)namescheme.getBaseScheme())) == null) {
            throw new ResourcesDbException("No primary alias set for substituent " + this.getName() + " and namescheme " + (Object)((Object)namescheme));
        }
        SubstituentAlias alias = tempMap.get((Object)linktype);
        if (alias == null) {
            throw new ResourcesDbException("No primary alias set for substituent " + this.getName() + ", namescheme " + (Object)((Object)namescheme) + " and linkage type " + (Object)((Object)linktype));
        }
        return alias;
    }

    private HashMap<LinkageType, SubstituentAlias> getPrimaryAliasMap(GlycanNamescheme namescheme) {
        return this.primaryAliasMap.get((Object)namescheme);
    }

    public void setPrimaryAlias(GlycanNamescheme namescheme, LinkageType link, SubstituentAlias alias) {
        HashMap<LinkageType, SubstituentAlias> tempMap = this.getPrimaryAliasMap(namescheme);
        if (tempMap == null) {
            tempMap = new HashMap();
            this.primaryAliasMap.put(namescheme, tempMap);
        }
        tempMap.put(link, alias);
    }

    public List<SubstituentAlias> getAliasList() {
        return this.aliasList;
    }

    public List<SubstituentAlias> getAliasList(GlycanNamescheme scheme, LinkageType linktype) {
        ArrayList<SubstituentAlias> retList = new ArrayList<SubstituentAlias>();
        for (SubstituentAlias substAlias : this.getAliasList()) {
            if (scheme != null && !scheme.equals((Object)substAlias.getNamescheme()) || linktype != null && !linktype.equals((Object)substAlias.getLinktype1())) continue;
            retList.add(substAlias);
        }
        return retList;
    }

    public void setAliasList(List<SubstituentAlias> aliasList) {
        this.aliasList = aliasList;
    }

    public void addAlias(SubstituentAlias alias) {
        List<SubstituentAlias> aliases = this.getAliasList();
        if (aliases == null) {
            aliases = new ArrayList<SubstituentAlias>();
            this.setAliasList(aliases);
        }
        alias.setPrimaryTemplate(this);
        aliases.add(alias);
        if (alias.isPrimary()) {
            this.setPrimaryAlias(alias.getNamescheme(), alias.getLinktype1(), alias);
        }
    }

    public String getSeparateDisplay(GlycanNamescheme scheme, LinkageType linktype) throws ResourcesDbException {
        if (scheme == null) {
            throw new MonosaccharideException("Namescheme must not be null in getSeparateDisplay(scheme, linktype)");
        }
        if (linktype == null) {
            throw new MonosaccharideException("Linkage type must not be null in getSeparateDisplay(scheme, linktype)");
        }
        SubstituentAlias primAlias = this.getPrimaryAlias(scheme, linktype);
        if (primAlias == null) {
            return null;
        }
        return primAlias.getSeparateDisplayName();
    }

    public SubstituentTemplate getSeparateDisplayTemplate(GlycanNamescheme scheme, LinkageType linktype, SubstituentTemplateContainer stContainer) throws ResourcesDbException {
        String separateName = this.getSeparateDisplay(scheme, linktype);
        if (separateName != null) {
            return stContainer.forName(scheme, separateName);
        }
        return null;
    }

    public String getResidueIncludedName(GlycanNamescheme scheme, LinkageType linktype) throws ResourcesDbException {
        if (scheme == null) {
            throw new MonosaccharideException("Namescheme must not be null in getResidueIncludedName(scheme, linktype)");
        }
        if (linktype == null) {
            throw new MonosaccharideException("Linkage type must not be null in getResidueIncludedName(scheme, linktype)");
        }
        SubstituentAlias primAlias = this.getPrimaryAlias(scheme, linktype);
        if (primAlias == null) {
            return null;
        }
        return primAlias.getResidueIncludedName();
    }

    public boolean isSplit(GlycanNamescheme scheme, LinkageType linktype, SubstituentTemplateContainer stContainer) throws ResourcesDbException {
        if (this.getSeparateDisplayTemplate(scheme, linktype, stContainer) == null) {
            return false;
        }
        return !this.getSeparateDisplayTemplate(scheme, linktype, stContainer).equals(this);
    }

    public String getOLinkedEquivalent(SubstituentTemplateContainer stContainer) throws ResourcesDbException {
        SubstituentTemplate rootTmpl;
        if (this.oLinkedEquivalent != null && this.oLinkedEquivalent.length() > 0) {
            return this.oLinkedEquivalent;
        }
        if (this.getSubparts() != null && (rootTmpl = this.getSubparts().getSubstTmpl(stContainer)) != null && rootTmpl.getName().equals(AMINOTEMPLATENAME) && this.getSubparts().getChildCount() == 1) {
            String subPart = ((SubstituentSubpartTreeNode)this.getSubparts().getFirstChild()).getName();
            return subPart;
        }
        return null;
    }

    public void setOLinkedEquivalent(String linkedEquivalent) {
        this.oLinkedEquivalent = linkedEquivalent;
    }

    public LinkageType getLinkageTypeBySubstituentName(GlycanNamescheme scheme, String name) throws MonosaccharideException {
        List<SubstituentAlias> aliaslist = this.getAliasList();
        for (SubstituentAlias alias : aliaslist) {
            if (!alias.getNamescheme().equals((Object)scheme)) continue;
            if (alias.getResidueIncludedName() != null && alias.getResidueIncludedName().equalsIgnoreCase(name)) {
                return alias.getLinktype1();
            }
            if (alias.getSeparateDisplayName() == null || !alias.getSeparateDisplayName().equalsIgnoreCase(name)) continue;
            return alias.getLinktype1();
        }
        throw new MonosaccharideException("Substituent '" + name + "' is not defined in namescheme " + (Object)((Object)scheme));
    }

    public LinkageType getLinkageType2BySubstituentName(GlycanNamescheme scheme, String name) throws MonosaccharideException {
        List<SubstituentAlias> aliaslist = this.getAliasList();
        for (SubstituentAlias alias : aliaslist) {
            if (!alias.getNamescheme().equals((Object)scheme)) continue;
            if (alias.getResidueIncludedName() != null && alias.getResidueIncludedName().equalsIgnoreCase(name)) {
                return alias.getLinktype2();
            }
            if (alias.getSeparateDisplayName() == null || !alias.getSeparateDisplayName().equalsIgnoreCase(name)) continue;
            return alias.getLinktype2();
        }
        throw new MonosaccharideException("Substituent '" + name + "' is not defined in namescheme " + (Object)((Object)scheme));
    }

    public SubstituentSubpartTreeNode getSubparts() {
        return this.subparts;
    }

    public void setSubparts(SubstituentSubpartTreeNode subparts) {
        this.subparts = subparts;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public boolean isLinkable() {
        return this.isLinkable;
    }

    public void setLinkable(boolean isLinkable) {
        this.isLinkable = isLinkable;
    }

    public boolean isExtendedAmine(int position, SubstituentTemplateContainer stContainer) throws ResourcesDbException {
        return this.getSubparts() != null && this.getSubparts().getName().equals(stContainer.forName(GlycanNamescheme.MONOSACCHARIDEDB, AMINOTEMPLATENAME).getName()) && this.getSubparts().getChildCount() == 1;
    }

    public boolean isExtendedAmine(SubstituentTemplateContainer stContainer) throws ResourcesDbException {
        return this.isExtendedAmine(this.getDefaultLinkingPosition1(), stContainer);
    }

    @Override
    public void init() {
        super.init();
        this.setCanReplaceRingOxygen(false);
        this.setLinkable(false);
        this.setHaworthName("");
        this.setMirroredHaworthName("");
        this.setAliasList(null);
        this.setOLinkedEquivalent(null);
        this.primaryAliasMap = new HashMap();
    }

    public static LinkageType getLinkageTypeByLinkageName(String name) {
        if (name != null) {
            try {
                return LinkageType.forName(name);
            }
            catch (GlycoconjugateException ge) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        String outStr = super.toString();
        outStr = String.valueOf(outStr) + "default linkage type: " + (Object)((Object)this.getDefaultLinkagetype1());
        if (this.getMaxValence() == 2) {
            outStr = String.valueOf(outStr) + " / default linkage type2: " + (Object)((Object)this.getDefaultLinkagetype2());
        }
        outStr = String.valueOf(outStr) + "\n";
        if (this.getAliasList() != null) {
            for (SubstituentAlias alias : this.getAliasList()) {
                outStr = String.valueOf(outStr) + "Alias: " + alias.toString() + "\n";
            }
        }
        return outStr;
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null) {
            return false;
        }
        if (!anotherObject.getClass().equals(SubstituentTemplate.class)) {
            return false;
        }
        SubstituentTemplate anotherTemplate = (SubstituentTemplate)anotherObject;
        return anotherTemplate.toString().equals(this.toString());
    }
}

