/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.GlycoCT;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlycoCT.RepeatingUnitExtractor;

public class GlyContainerToSugar {
    private Sugar sugar;
    private Map<Node, GlycoNode> m_mapNodeToGlycoNode;
    private Map<SugarUnitRepeat, Edge> m_mapSugarUnitRepeatToEdge;

    private void init() {
        this.sugar = new Sugar();
        this.m_mapNodeToGlycoNode = new HashMap<Node, GlycoNode>();
        this.m_mapSugarUnitRepeatToEdge = new HashMap<SugarUnitRepeat, Edge>();
    }

    public Sugar getConvertedSugar() {
        return this.sugar;
    }

    /*
     * WARNING - void declaration
     */
    public void start(GlyContainer _glyCo) throws GlycoconjugateException, GlycanException {
        this.init();
        HashMap t_mapUndToNodes = new HashMap();
        HashMap t_mapUndToEdges = new HashMap();
        int t_nNoParent = 0;
        for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnit()) {
            if (t_und.getConnection() == null) {
                ++t_nNoParent;
            }
            for (Node node : t_und.getRootNodes()) {
                if (node instanceof org.glycoinfo.GlycanFormatconverter.Glycan.Substituent) {
                    Substituent t_sub = this.convertSubstituent((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)node);
                    this.m_mapNodeToGlycoNode.put(node, t_sub);
                }
                ArrayList<Edge> t_edges = new ArrayList<Edge>();
                ArrayList<Node> t_nodes = new ArrayList<Node>();
                t_nodes.add(node);
                LinkedList<Node> t_nodesQueue = new LinkedList<Node>();
                t_nodesQueue.add(node);
                while (!t_nodesQueue.isEmpty()) {
                    Node node2 = (Node)t_nodesQueue.removeFirst();
                    for (Edge t_edge : node2.getChildEdges()) {
                        t_edges.add(t_edge);
                        if (t_edge.getChild() == null) continue;
                        t_nodesQueue.add(t_edge.getChild());
                        t_nodes.add(t_edge.getChild());
                    }
                }
                t_mapUndToNodes.put(t_und, t_nodes);
                t_mapUndToEdges.put(t_und, t_edges);
            }
        }
        ArrayList<Edge> t_lCommonEdges = new ArrayList<Edge>();
        ArrayList<Edge> t_lRepeatEdges = new ArrayList<Edge>();
        ArrayList<Edge> t_lCyclicEdges = new ArrayList<Edge>();
        for (Node _node : _glyCo.getAllNodes()) {
            if (_node instanceof Monosaccharide) {
                Monosaccharide t_ms = (Monosaccharide)_node;
                if (t_ms.getAnomer() == AnomericStateDescriptor.UNKNOWN) {
                    throw new GlycanException("The monosaccharide which contains \"u\" or \"U\" can not be converted to GlycoCT");
                }
                Iterator<Edge> t_msConv = this.convertMonosaccharide(t_ms);
                this.m_mapNodeToGlycoNode.put(_node, (GlycoNode)((Object)t_msConv));
                if (_node.getChildEdges().isEmpty() && _node.getParentEdges().isEmpty()) {
                    this.sugar.addNode((GlycoNode)((Object)t_msConv));
                    continue;
                }
            }
            if (_node.getChildEdges().isEmpty()) continue;
            Iterator t_undHost = null;
            for (GlycanUndefinedUnit glycanUndefinedUnit : _glyCo.getUndefinedUnit()) {
                if (!((List)t_mapUndToNodes.get(glycanUndefinedUnit)).contains(_node)) continue;
                t_undHost = glycanUndefinedUnit;
                break;
            }
            for (Edge edge : _node.getChildEdges()) {
                org.glycoinfo.GlycanFormatconverter.Glycan.Substituent substituent;
                if (edge.getSubstituent() != null && (substituent = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)edge.getSubstituent()).getSubstituent() != null && !this.m_mapNodeToGlycoNode.containsKey(substituent)) {
                    this.m_mapNodeToGlycoNode.put(substituent, this.convertSubstituent(substituent));
                }
                if (t_undHost != null) continue;
                if (edge.isRepeat()) {
                    t_lRepeatEdges.add(edge);
                    continue;
                }
                if (edge.isCyclic()) {
                    t_lCyclicEdges.add(edge);
                    continue;
                }
                t_lCommonEdges.add(edge);
            }
        }
        if (_glyCo.isComposition()) {
            if (_glyCo.getNumberOfUndefinedLinkages() != _glyCo.getAllNodes().size() - 1) {
                throw new GlycoconjugateException("It is not handled that the glycan with undefined linkages which number is not the same as the number of monosaccharide minus one.");
            }
            for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnit()) {
                for (Edge t_edge : (List)t_mapUndToEdges.get(t_und)) {
                    this.addEdgeToGlycoGraph(t_edge, this.sugar);
                }
                if (!((List)t_mapUndToEdges.get(t_und)).isEmpty()) continue;
                for (Node t_node : (List)t_mapUndToNodes.get(t_und)) {
                    this.sugar.addNode(this.m_mapNodeToGlycoNode.get(t_node));
                }
            }
            for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnitsForSubstituent()) {
                org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_subst = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)t_und.getConnection().getSubstituent();
                UnderdeterminedSubTree t_undSub = new UnderdeterminedSubTree();
                t_undSub.addNode(this.convertSubstituent(t_subst));
                t_undSub.setConnection(this.convertSubstituentEdge(t_subst, true));
                this.sugar.addUndeterminedSubTree(t_undSub);
                for (GlycoNode glycoNode : this.sugar.getNodes()) {
                    if (glycoNode instanceof Substituent) continue;
                    this.sugar.addUndeterminedSubTreeParent(t_undSub, glycoNode);
                }
            }
            return;
        }
        RepeatingUnitExtractor repeatingUnitExtractor = new RepeatingUnitExtractor();
        repeatingUnitExtractor.start(t_lRepeatEdges);
        for (Edge t_edgeRep : repeatingUnitExtractor.getSortedRepeatEdges()) {
            SugarUnitRepeat t_unitRep = new SugarUnitRepeat();
            this.m_mapSugarUnitRepeatToEdge.put(t_unitRep, t_edgeRep);
            GlycanRepeatModification glycanRepeatModification = (GlycanRepeatModification)t_edgeRep.getSubstituent();
            t_unitRep.setMaxRepeatCount(glycanRepeatModification.getMaxRepeatCount());
            t_unitRep.setMinRepeatCount(glycanRepeatModification.getMinRepeatCount());
            for (Edge t_edgeNested : repeatingUnitExtractor.getNestedEdges(t_edgeRep)) {
                this.addEdgeToGlycoGraph(t_edgeNested, t_unitRep);
                t_lCommonEdges.remove(t_edgeNested);
            }
            if (repeatingUnitExtractor.getNestedEdges(t_edgeRep).isEmpty()) {
                t_unitRep.addNode(this.m_mapNodeToGlycoNode.get(t_edgeRep.getParent()));
            }
            this.addEdgeToGlycoGraph(t_edgeRep, t_unitRep);
            this.m_mapNodeToGlycoNode.put(t_edgeRep.getParent(), t_unitRep);
            this.m_mapNodeToGlycoNode.put(t_edgeRep.getChild(), t_unitRep);
            if (RepeatingUnitExtractor.getHeadEdge(t_edgeRep) != null || RepeatingUnitExtractor.getTailEdge(t_edgeRep) != null) continue;
            this.sugar.addNode(t_unitRep);
        }
        for (Edge _edge : t_lCommonEdges) {
            this.addEdgeToGlycoGraph(_edge, this.sugar);
        }
        for (Edge _edgeCyclic : t_lCyclicEdges) {
            this.addEdgeToGlycoGraph(_edgeCyclic, this.sugar);
        }
        for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnit()) {
            void var13_40;
            void var12_27;
            BigDecimal bigDecimal;
            UnderdeterminedSubTree t_subTree = new UnderdeterminedSubTree();
            BigDecimal bigDecimal2 = new BigDecimal(t_und.getProbabilityLow());
            if (!bigDecimal2.toPlainString().equals("-1")) {
                BigDecimal bigDecimal3 = bigDecimal2.setScale(2, RoundingMode.HALF_UP);
            }
            if (!(bigDecimal = new BigDecimal(t_und.getProbabilityHigh())).toPlainString().equals("-1")) {
                BigDecimal bigDecimal4 = bigDecimal.setScale(2, RoundingMode.HALF_UP);
            }
            t_subTree.setProbability(var12_27.doubleValue(), var13_40.doubleValue());
            GlycoEdge t_connection = this.convertGlycosidicEdge(t_und.getConnection());
            if (t_und.getRootNodes().get(0) instanceof org.glycoinfo.GlycanFormatconverter.Glycan.Substituent) {
                Iterator<Object> t_sub = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)t_und.getRootNodes().get(0);
                t_connection = this.convertSubstituentEdge((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)((Object)t_sub), true);
            }
            t_subTree.setConnection(t_connection);
            if (t_mapUndToEdges.containsKey(t_und) && !((List)t_mapUndToEdges.get(t_und)).isEmpty()) {
                for (Edge t_edge : (List)t_mapUndToEdges.get(t_und)) {
                    this.addEdgeToGlycoGraph(t_edge, t_subTree);
                }
            } else {
                for (Node t_node : (List)t_mapUndToNodes.get(t_und)) {
                    t_subTree.addNode(this.m_mapNodeToGlycoNode.get(t_node));
                }
            }
            this.sugar.addUndeterminedSubTree(t_subTree);
            for (Node t_nodeParent : t_und.getParents()) {
                GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(t_nodeParent);
                this.sugar.addUndeterminedSubTreeParent(t_subTree, t_parent);
            }
        }
        for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnitsForSubstituent()) {
            org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_subst = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)t_und.getConnection().getSubstituent();
            UnderdeterminedSubTree underdeterminedSubTree = new UnderdeterminedSubTree();
            underdeterminedSubTree.addNode(this.convertSubstituent(t_subst));
            underdeterminedSubTree.setConnection(this.convertSubstituentEdge(t_subst, true));
            this.sugar.addUndeterminedSubTree(underdeterminedSubTree);
            for (Node t_nodeParent : t_und.getParents()) {
                GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(t_nodeParent);
                this.sugar.addUndeterminedSubTreeParent(underdeterminedSubTree, t_parent);
            }
        }
    }

    private org.eurocarbdb.MolecularFramework.sugar.Monosaccharide convertMonosaccharide(Monosaccharide _ms) throws GlycoconjugateException {
        SuperClass enumSClass = _ms.getSuperClass();
        Superclass t_enumSuperclass = Superclass.forCAtomCount(enumSClass.getSize());
        AnomericStateDescriptor enumAnom = _ms.getAnomer();
        if (enumAnom == AnomericStateDescriptor.UNKNOWN) {
            enumAnom = AnomericStateDescriptor.UNKNOWN_STATE;
        }
        if (enumSClass == SuperClass.SUG && enumAnom == AnomericStateDescriptor.OPEN) {
            enumAnom = AnomericStateDescriptor.UNKNOWN_STATE;
        }
        Anomer t_enumAnomer = Anomer.forSymbol(enumAnom.getAnomericState());
        org.eurocarbdb.MolecularFramework.sugar.Monosaccharide sugarMS = new org.eurocarbdb.MolecularFramework.sugar.Monosaccharide(t_enumAnomer, t_enumSuperclass);
        for (String t_strStereo : _ms.getStereos()) {
            if (t_enumSuperclass == Superclass.SUG) break;
            String t_stereo = t_strStereo;
            if (t_stereo.length() == 3) {
                t_stereo = "x" + t_stereo;
            }
            if (t_stereo.contains("d/l-")) {
                t_stereo = t_stereo.replace("d/l-", "x");
            }
            BaseType t_bType = BaseType.forName(t_stereo);
            sugarMS.addBaseType(t_bType);
        }
        if (sugarMS.getBaseType().isEmpty() && sugarMS.getSuperclass() == Superclass.TRI) {
            sugarMS.addBaseType(BaseType.XGRO);
        }
        int t_iStart = _ms.getRingStart();
        int t_iEnd = _ms.getRingEnd();
        if (_ms.getAnomer() == AnomericStateDescriptor.OPEN && t_iStart == -1) {
            t_iStart = 0;
            t_iEnd = 0;
        }
        if (t_iStart != -1 && t_iEnd == -1) {
            t_iStart = -1;
        }
        if (!_ms.getStereos().isEmpty() && _ms.getStereos().get(0).equals("Sugar")) {
            t_iStart = -1;
            t_iEnd = -1;
        }
        sugarMS.setRing(t_iStart, t_iEnd);
        ArrayList<GlyCoModification> t_lMods = new ArrayList<GlyCoModification>();
        boolean t_bHasModification1 = false;
        boolean t_bHasAldi1 = false;
        boolean t_bIsAldose = false;
        boolean t_bIsKetose = false;
        boolean t_bIsKetoAldose = false;
        for (GlyCoModification t_mod : _ms.getModifications()) {
            if (t_mod.getModificationTemplate().getGlycoCTnotation().equals("en")) continue;
            if (t_mod.getPositionOne() == 1) {
                t_bHasModification1 = true;
            }
            if (t_mod.getModificationTemplate() == ModificationTemplate.HYDROXYL) {
                if (enumAnom.getAnomericState() != 'o' || t_mod.getPositionOne() != 1) continue;
                t_bHasAldi1 = true;
                continue;
            }
            if (t_mod.getModificationTemplate() == ModificationTemplate.KETONE_U || t_mod.getModificationTemplate() == ModificationTemplate.KETONE) {
                if (_ms.getAnomericPosition() == 1 && t_mod.getPositionOne() != 1) {
                    t_bIsKetoAldose = true;
                }
                if (t_mod.getPositionOne() == 1) {
                    t_bIsAldose = true;
                    continue;
                }
                t_bIsKetose = true;
            }
            if (t_mod.getModificationTemplate() == ModificationTemplate.ALDEHYDE) {
                if (t_mod.getPositionOne() != 1) continue;
                t_bIsAldose = true;
                continue;
            }
            t_lMods.add(t_mod);
        }
        if (!(t_bHasModification1 || _ms.getAnomericPosition() != 1 && _ms.getAnomericPosition() != -1)) {
            t_bIsAldose = true;
        }
        if (t_bIsAldose && t_bIsKetose) {
            t_bIsKetoAldose = true;
        }
        if (t_bIsKetoAldose) {
            sugarMS.addModification(new Modification("keto", 1));
        }
        if (t_bIsAldose || t_bIsKetose) {
            t_bHasAldi1 = false;
        }
        if (t_bHasAldi1) {
            sugarMS.addModification(new Modification("aldi", 1));
        }
        for (GlyCoModification t_mod : t_lMods) {
            Modification t_modSugar = new Modification(t_mod.getModificationTemplate().getGlycoCTnotation(), (int)t_mod.getPositionOne(), t_mod.getPositionTwo());
            sugarMS.addModification(t_modSugar);
        }
        int t_iPrev = 0;
        for (int i = 1; i < sugarMS.getSuperclass().getCAtomCount(); ++i) {
            Modification t_mod;
            if (i <= t_iPrev) continue;
            Enum t_modTempFirst = null;
            Enum t_modTempSecond = null;
            for (GlyCoModification t_mod2 : _ms.getModifications()) {
                if (!t_mod2.getModificationTemplate().getGlycoCTnotation().equals("en")) continue;
                if (t_mod2.getPositionOne() == i) {
                    t_modTempFirst = t_mod2.getModificationTemplate();
                }
                if (t_mod2.getPositionOne() != i + 1) continue;
                t_modTempSecond = t_mod2.getModificationTemplate();
            }
            if (t_modTempFirst == null || t_modTempSecond == null) continue;
            t_iPrev = i + 1;
            boolean t_bHasStereo = false;
            boolean t_bIsEN = false;
            switch (1.$SwitchMap$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate[t_modTempFirst.ordinal()]) {
                case 1: 
                case 2: {
                    t_bHasStereo = true;
                }
                case 3: {
                    t_bIsEN = true;
                    t_mod = new Modification("d", i);
                    if (i == 1) {
                        t_mod = new Modification("aldi", i);
                    }
                    sugarMS.addModification(t_mod);
                    break;
                }
                case 4: 
                case 5: {
                    t_bHasStereo = true;
                    break;
                }
            }
            switch (1.$SwitchMap$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate[t_modTempSecond.ordinal()]) {
                case 1: 
                case 2: {
                    t_bHasStereo = true;
                }
                case 3: {
                    t_bIsEN = true;
                    if (i == sugarMS.getSuperclass().getCAtomCount() - 1) break;
                    sugarMS.addModification(new Modification("d", i + 1));
                    break;
                }
                case 4: 
                case 5: {
                    t_bHasStereo = true;
                    break;
                }
            }
            if (t_bHasStereo && (t_iStart == 0 || t_iStart == -1)) {
                throw new GlycoconjugateException("Double bond stereo will be missed.");
            }
            t_mod = new Modification("enx", i, (Integer)(i + 1));
            if (t_bIsEN) {
                t_mod = new Modification("en", i, (Integer)(i + 1));
            }
            sugarMS.addModification(t_mod);
        }
        return sugarMS;
    }

    private Substituent convertSubstituent(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst) throws GlycoconjugateException {
        return new Substituent(SubstituentType.forName(_subst.getSubstituent().getglycoCTnotation()));
    }

    private void addEdgeToGlycoGraph(Edge _edge, GlycoGraph _graph) throws GlycoconjugateException, GlycanException {
        Edge t_edgeRepeat;
        org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_substRepeat;
        for (Linkage t_link : _edge.getGlycosidicLinkages()) {
            if (this.m_mapNodeToGlycoNode.get(_edge.getChild()) instanceof SugarUnitRepeat) {
                t_link.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
            }
            if (!(this.m_mapNodeToGlycoNode.get(_edge.getParent()) instanceof SugarUnitRepeat)) continue;
            t_link.setParentLinkageType(LinkageType.NONMONOSACCHARIDE);
        }
        if (_edge.getSubstituent() == null || ((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)_edge.getSubstituent()).getSubstituent() == null) {
            this.addGlycosidicLinkageToGlycoGraph(_edge, _graph);
            return;
        }
        if (_edge.isCyclic()) {
            GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(_edge.getParent());
            GlycoNode t_child = this.m_mapNodeToGlycoNode.get(_edge.getChild());
            GlycoEdge t_glycoEdge = this.convertGlycosidicEdge(_edge);
            ((Sugar)_graph).addCyclic(t_parent, t_glycoEdge, t_child);
            return;
        }
        org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_subst = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)_edge.getSubstituent();
        GlycoEdge t_glycoEdge = this.convertSubstituentEdge(t_subst, true);
        if (t_glycoEdge.getGlycosidicLinkages().isEmpty()) {
            for (Linkage t_link : _edge.getGlycosidicLinkages()) {
                Linkage t_link0 = this.normalizeLinkageTypeForSubstituent(t_subst, t_link, true);
                t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_link0));
            }
        }
        GlycoNode t_child = this.m_mapNodeToGlycoNode.get(t_subst);
        Node t_parentNode = t_subst.getParentNode();
        if (t_parentNode == null) {
            t_parentNode = _edge.getParent();
        }
        GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(t_parentNode);
        boolean t_bSkipSubst = false;
        if (t_parent instanceof SugarUnitRepeat && (t_substRepeat = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)(t_edgeRepeat = this.m_mapSugarUnitRepeatToEdge.get((SugarUnitRepeat)t_parent)).getSubstituent()) != null && t_substRepeat.getSubstituent() != null && t_subst.getSubstituent().getglycoCTnotation().equals(t_substRepeat.getSubstituent().getglycoCTnotation())) {
            t_bSkipSubst = true;
        }
        GlycoGraph t_graph = _graph;
        if (this.hasProbability(_edge)) {
            t_graph = this.getUndeterminedSubTreeWithProbability(_graph, _edge.getGlycosidicLinkages().get(0), t_parent, t_glycoEdge, t_child);
        } else if (this.hasProbability(t_subst)) {
            t_graph = this.getUndeterminedSubTreeWithProbability(_graph, t_subst.getFirstPosition(), t_parent, t_glycoEdge, t_child);
        }
        if (!t_graph.equals(_graph)) {
            t_bSkipSubst = true;
        }
        if (!t_bSkipSubst) {
            t_graph.addNode(t_parent, t_glycoEdge, t_child);
        }
        if (_edge.getChild() == null) {
            return;
        }
        t_glycoEdge = this.convertSubstituentEdge(t_subst, false);
        if (t_glycoEdge.getGlycosidicLinkages().isEmpty()) {
            for (Linkage t_link : _edge.getGlycosidicLinkages()) {
                Linkage t_link0 = this.normalizeLinkageTypeForSubstituent(t_subst, t_link, false);
                t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_link0));
            }
        }
        t_child = this.m_mapNodeToGlycoNode.get(_edge.getChild());
        if (!t_bSkipSubst) {
            t_parent = this.m_mapNodeToGlycoNode.get(t_subst);
        }
        if (_edge.isRepeat()) {
            ((SugarUnitRepeat)t_graph).setRepeatLinkage(t_glycoEdge, t_parent, t_child);
            return;
        }
        t_graph.addNode(t_parent, t_glycoEdge, t_child);
    }

    private void addGlycosidicLinkageToGlycoGraph(Edge _edge, GlycoGraph _graph) throws GlycoconjugateException, GlycanException {
        if (_edge.getGlycosidicLinkages().isEmpty()) {
            throw new GlycoconjugateException("Edge with no linkage can not be handled.");
        }
        GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(_edge.getParent());
        GlycoNode t_child = this.m_mapNodeToGlycoNode.get(_edge.getChild());
        GlycoEdge t_glycoEdge = this.convertGlycosidicEdge(_edge);
        if (this.hasProbability(_edge)) {
            this.getUndeterminedSubTreeWithProbability(_graph, _edge.getGlycosidicLinkages().get(0), t_parent, t_glycoEdge, t_child);
            return;
        }
        if (_edge.isRepeat()) {
            ((SugarUnitRepeat)_graph).setRepeatLinkage(t_glycoEdge, t_parent, t_child);
            return;
        }
        _graph.addNode(t_parent, t_glycoEdge, t_child);
    }

    private UnderdeterminedSubTree getUndeterminedSubTreeWithProbability(GlycoGraph _parentGraph, Linkage _link, GlycoNode _parent, GlycoEdge _connection, GlycoNode _child) throws GlycoconjugateException {
        BigDecimal t_bdProbUpper;
        BigDecimal t_bdProbLower = new BigDecimal(_link.getParentProbabilityLower());
        if (!t_bdProbLower.toPlainString().equals("-1")) {
            t_bdProbLower = t_bdProbLower.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
        }
        if (!(t_bdProbUpper = new BigDecimal(_link.getParentProbabilityUpper())).toPlainString().equals("-1")) {
            t_bdProbUpper = t_bdProbUpper.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
        }
        UnderdeterminedSubTree t_subTree = new UnderdeterminedSubTree();
        t_subTree.setProbability(t_bdProbLower.doubleValue(), t_bdProbUpper.doubleValue());
        t_subTree.setConnection(_connection);
        if (!_parentGraph.containsNode(_parent)) {
            _parentGraph.addNode(_parent);
        }
        if (_parentGraph instanceof Sugar) {
            ((Sugar)_parentGraph).addUndeterminedSubTree(t_subTree);
            ((Sugar)_parentGraph).addUndeterminedSubTreeParent(t_subTree, _parent);
        }
        if (_parentGraph instanceof SugarUnitRepeat) {
            ((SugarUnitRepeat)_parentGraph).addUndeterminedSubTree(t_subTree);
            ((SugarUnitRepeat)_parentGraph).addUndeterminedSubTreeParent(t_subTree, _parent);
        }
        t_subTree.addNode(_child);
        return t_subTree;
    }

    private boolean hasProbability(Edge _edge) {
        for (Linkage t_link : _edge.getGlycosidicLinkages()) {
            if (t_link.getChildProbabilityLower() != 1.0) {
                return true;
            }
            if (t_link.getParentProbabilityLower() == 1.0) continue;
            return true;
        }
        return false;
    }

    private boolean hasProbability(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst) {
        if (_subst.getFirstPosition() == null) {
            return false;
        }
        if (_subst.getFirstPosition().getChildProbabilityLower() != 1.0) {
            return true;
        }
        if (_subst.getFirstPosition().getParentProbabilityLower() != 1.0) {
            return true;
        }
        if (_subst.getSecondPosition() == null) {
            return false;
        }
        if (_subst.getSecondPosition().getChildProbabilityLower() != 1.0) {
            return true;
        }
        return _subst.getSecondPosition().getParentProbabilityLower() != 1.0;
    }

    private GlycoEdge convertGlycosidicEdge(Edge _edge) throws GlycoconjugateException, GlycanException {
        GlycoEdge t_glycoEdge = new GlycoEdge();
        for (Linkage t_link : _edge.getGlycosidicLinkages()) {
            Linkage t_link0 = this.normalizeLinkageTypeForGlycosidicLinkage(t_link);
            t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_link0));
        }
        return t_glycoEdge;
    }

    private GlycoEdge convertSubstituentEdge(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst, boolean _isChild) throws GlycanException, GlycoconjugateException {
        GlycoEdge t_glycoEdge = new GlycoEdge();
        if (_subst.getFirstPosition() == null) {
            return t_glycoEdge;
        }
        Linkage t_link = _subst.getFirstPosition();
        if (t_link.getParentLinkages().isEmpty() || t_link.getChildLinkages().isEmpty()) {
            return t_glycoEdge;
        }
        Linkage t_linkNew = this.normalizeLinkageTypeForSubstituent(_subst, t_link, _isChild);
        t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_linkNew));
        if (_subst.getSecondPosition() == null) {
            return t_glycoEdge;
        }
        t_link = _subst.getSecondPosition();
        if (t_link.getParentLinkages().isEmpty() || t_link.getChildLinkages().isEmpty()) {
            return t_glycoEdge;
        }
        t_linkNew = this.normalizeLinkageTypeForSubstituent(_subst, t_link, _isChild);
        t_linkNew.setParentLinkageType(this.getLinkageTypeForSubstituent(_subst, false));
        t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_linkNew));
        if (_subst.getSubstituent().getglycoCTnotation().equals("anhydro")) {
            t_glycoEdge.getGlycosidicLinkages().get(0).setParentLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.DEOXY);
            t_glycoEdge.getGlycosidicLinkages().get(1).setParentLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.H_AT_OH);
        }
        return t_glycoEdge;
    }

    private Linkage normalizeLinkageTypeForSubstituent(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst, Linkage _link, boolean _isChild) throws GlycanException {
        Linkage t_link = new Linkage();
        LinkageType t_ltParent = _link.getParentLinkageType();
        LinkageType t_ltChild = _link.getChildLinkageType();
        ArrayList<Integer> t_lParentPos = new ArrayList<Integer>();
        for (Integer t_pos : _link.getParentLinkages()) {
            t_lParentPos.add(t_pos);
        }
        ArrayList<Integer> t_lChildPos = new ArrayList<Integer>();
        for (Integer t_pos : _link.getChildLinkages()) {
            t_lChildPos.add(t_pos);
        }
        if (_isChild) {
            if (t_ltParent == LinkageType.UNVALIDATED) {
                t_ltParent = this.getLinkageTypeForSubstituent(_subst, _isChild);
            }
            if (t_ltChild != LinkageType.NONMONOSACCHARIDE) {
                t_ltChild = LinkageType.NONMONOSACCHARIDE;
            }
            if (t_lChildPos.size() == 1) {
                t_lChildPos.set(0, 1);
            }
        } else {
            if (t_ltChild == LinkageType.UNVALIDATED) {
                t_ltChild = this.getLinkageTypeForSubstituent(_subst, _isChild);
            }
            if (t_ltParent != LinkageType.NONMONOSACCHARIDE) {
                t_ltParent = LinkageType.NONMONOSACCHARIDE;
            }
            if (t_lParentPos.size() == 1) {
                t_lParentPos.set(0, 1);
            }
        }
        t_link.setParentLinkageType(t_ltParent);
        t_link.setChildLinkageType(t_ltChild);
        t_link.setParentLinkages(t_lParentPos);
        t_link.setChildLinkages(t_lChildPos);
        return t_link;
    }

    private LinkageType getLinkageTypeForSubstituent(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst, boolean _isChild) {
        if (_subst.getSubstituent() == CrossLinkedTemplate.ANHYDROXYL) {
            return _isChild ? LinkageType.H_AT_OH : LinkageType.DEOXY;
        }
        if (_subst.getSubstituent() == CrossLinkedTemplate.PHOSPHOETHANOLAMINE) {
            return _isChild ? LinkageType.H_AT_OH : LinkageType.H_AT_OH;
        }
        String t_strMAP = _subst.getSubstituent().getMAP().replaceAll("\\d", "");
        char t_cLinkage = _isChild ? t_strMAP.charAt(1) : t_strMAP.charAt(t_strMAP.indexOf("*", 1) - 1);
        return t_cLinkage == 'O' ? LinkageType.H_AT_OH : LinkageType.DEOXY;
    }

    private Linkage normalizeLinkageTypeForGlycosidicLinkage(Linkage _link) throws GlycanException {
        Linkage t_link = new Linkage();
        LinkageType t_ltParent = _link.getParentLinkageType();
        LinkageType t_ltChild = _link.getChildLinkageType();
        if (t_ltParent == LinkageType.UNVALIDATED) {
            t_ltParent = LinkageType.H_AT_OH;
        }
        if (t_ltChild == LinkageType.UNVALIDATED) {
            t_ltChild = LinkageType.DEOXY;
        }
        t_link.setParentLinkageType(t_ltParent);
        t_link.setChildLinkageType(t_ltChild);
        t_link.setParentLinkages(_link.getParentLinkages());
        t_link.setChildLinkages(_link.getChildLinkages());
        return t_link;
    }

    private org.eurocarbdb.MolecularFramework.sugar.Linkage convertLinkage(Linkage _link) throws GlycoconjugateException {
        org.eurocarbdb.MolecularFramework.sugar.Linkage t_sugarLink = new org.eurocarbdb.MolecularFramework.sugar.Linkage();
        LinkageType t_ltParent = _link.getParentLinkageType();
        LinkageType t_ltChild = _link.getChildLinkageType();
        t_sugarLink.setParentLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.forName(t_ltParent.getSymbol()));
        t_sugarLink.setParentLinkages(_link.getParentLinkages());
        t_sugarLink.setChildLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.forName(t_ltChild.getSymbol()));
        t_sugarLink.setChildLinkages(_link.getChildLinkages());
        return t_sugarLink;
    }
}

