/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.GlycoCT;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentTemplate;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectConnectingBackboneGroups;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSConversionValidatorForGlycoCT {
    private List<String> m_lErrors = new ArrayList<String>();
    private List<String> m_lWarnings = new ArrayList<String>();
    private List<String> m_lErrorsForGlycoCT = new ArrayList<String>();
    private List<String> m_lWarningsForGlycoCT = new ArrayList<String>();

    public List<String> getErrors() {
        return this.m_lErrors;
    }

    public List<String> getWarnings() {
        return this.m_lWarnings;
    }

    public List<String> getErrorsForGlycoCT() {
        return this.m_lErrorsForGlycoCT;
    }

    public List<String> getWarningsForGlycoCT() {
        return this.m_lWarningsForGlycoCT;
    }

    public void start(String a_strWURCS) {
        try {
            WURCSFactory factory = new WURCSFactory(a_strWURCS);
            WURCSGraph graph = factory.getGraph();
            WURCSVisitorCollectConnectingBackboneGroups t_oGroup = new WURCSVisitorCollectConnectingBackboneGroups();
            t_oGroup.start(graph);
            if (t_oGroup.getBackboneGroups().size() > 1) {
                this.m_lErrors.add("All residues must be connected.");
            }
            for (Backbone t_bb : graph.getBackbones()) {
                if (t_bb.getLength() > 10) {
                    this.m_lErrors.add("Carbon length must be 10 or less.");
                }
                this.validateAnomer(t_bb);
                this.validateStereo(t_bb);
                this.validateAvailableCarbonDescriptor(t_bb);
            }
            for (Modification t_mod : graph.getModifications()) {
                this.validateSubstituents(t_mod);
            }
            String string = factory.getWURCS();
        }
        catch (WURCSException e) {
            this.m_lErrors.add("WURCSException");
            e.printStackTrace();
        }
    }

    private void validateAnomer(Backbone a_bb) {
        boolean t_bUncertainAnomer = false;
        boolean t_bCarbonyl = false;
        boolean t_bRingForm = false;
        int t_iAnomPos = 0;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            if (t_bc.getDescriptor().getChar() == 'u' || t_bc.getDescriptor().getChar() == 'U') {
                t_bUncertainAnomer = true;
            }
            if (t_bc.getDescriptor().getChar() == 'o' || t_bc.getDescriptor().getChar() == 'O') {
                t_bCarbonyl = true;
            }
            if (t_bc.getDescriptor().getChar() != 'a') continue;
            if (t_bRingForm) {
                this.m_lErrors.add("Anomer carbon must be only one in a monosaccharide.");
                continue;
            }
            t_iAnomPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            t_bRingForm = true;
        }
        if (t_bUncertainAnomer) {
            this.m_lErrorsForGlycoCT.add("CarbonDescriptor \"u\" and \"U\" can not be handled in GlycoCT.");
            if (t_bCarbonyl) {
                this.m_lErrorsForGlycoCT.add("Carbonyl state will be lost in GlycoCT.");
            }
            if (t_bRingForm) {
                this.m_lErrorsForGlycoCT.add("Ring state will be lost in GlycoCT.");
            }
            t_iAnomPos = -1;
        }
        if (t_bRingForm) {
            if (a_bb.getAnomericPosition() != t_iAnomPos) {
                this.m_lErrors.add("Anomeric positions between the anomer descritpor 'a' and anomer information are mismathed.");
            }
            if (!this.hasRing(a_bb)) {
                this.m_lErrors.add("Backbone with anomer descriptor 'a' must have a ring modification.");
            }
        }
    }

    private void validateStereo(Backbone a_bb) {
        ArrayList<Integer> t_lH_LOSEPositions = new ArrayList<Integer>();
        boolean t_bHasAbsolute = false;
        boolean t_bHasRelative = false;
        boolean t_bHasUnknown = false;
        int t_iLastStereo = -1;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            if (t_iPos == 1 || t_iPos == a_bb.getBackboneCarbons().size()) continue;
            char t_cd = t_bc.getDescriptor().getChar();
            if (t_cd == '1' || t_cd == '2') {
                t_bHasAbsolute = true;
            } else if (t_cd == '5' || t_cd == '6') {
                t_bHasAbsolute = true;
                t_lH_LOSEPositions.add(t_iPos);
            } else if (t_cd == '3' || t_cd == '4') {
                t_bHasRelative = true;
            } else if (t_cd == '7' || t_cd == '8') {
                t_bHasRelative = true;
                t_lH_LOSEPositions.add(t_iPos);
            } else if (t_cd == 'x') {
                t_bHasUnknown = true;
            } else {
                if (t_cd != 'X') continue;
                t_bHasUnknown = true;
                t_lH_LOSEPositions.add(t_iPos);
            }
            t_iLastStereo = t_iPos;
        }
        if (!t_lH_LOSEPositions.isEmpty()) {
            this.m_lErrorsForGlycoCT.add("Currently chiral carbons without hydrogen can not be handled.");
            Iterator iterator = t_lH_LOSEPositions.iterator();
            while (iterator.hasNext()) {
                int t_pos = (Integer)iterator.next();
                boolean t_bHasSubstituent = false;
                for (WURCSEdge t_edge : a_bb.getEdges()) {
                    LinkagePosition t_link;
                    if (t_edge.getLinkages().size() != 1 || t_pos != (t_link = t_edge.getLinkages().getFirst()).getBackbonePosition()) continue;
                    t_bHasSubstituent = true;
                }
                if (t_bHasSubstituent) continue;
                this.m_lErrors.add("The chiral carbon without hydrogen must connect to at least one substituent.");
            }
        }
        if (t_bHasUnknown && (t_bHasRelative || t_bHasAbsolute)) {
            this.m_lErrorsForGlycoCT.add("Chiral information will be lost in GlycoCT.");
        }
        t_bHasAbsolute = false;
        t_bHasUnknown = false;
        boolean t_bHasNoStereo = false;
        int t_cdPrev = 32;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            int t_cd = t_bc.getDescriptor().getChar();
            if (t_cd == 101 || t_cd == 69 || t_cd == 122 || t_cd == 90) {
                t_bHasAbsolute = true;
            } else if (t_cd == 102 || t_cd == 70) {
                t_bHasUnknown = true;
            } else if (t_cd == 110 || t_cd == 78) {
                t_bHasNoStereo = true;
            } else {
                t_cd = 32;
            }
            if (t_cdPrev != 32 && t_cd != 32) {
                if ((t_cd = Character.toLowerCase((char)t_cd)) != t_cdPrev) {
                    this.m_lErrors.add("Two carbons on a double bond must have the same stereo chemistry.");
                }
                t_cd = 32;
            }
            t_cdPrev = Character.toLowerCase((char)t_cd);
        }
        if (t_bHasNoStereo) {
            this.m_lErrors.add("CarbonDescriptor 'n' and 'N' can not be handled for now.");
        }
        if (t_bHasAbsolute && !this.hasRing(a_bb)) {
            this.m_lErrorsForGlycoCT.add("Double bond stereo will be lost in GlycoCT.");
        }
    }

    private void validateAvailableCarbonDescriptor(Backbone a_bb) {
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            char t_cd;
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            boolean t_bIsTerminal = false;
            if (t_iPos == 1 || t_iPos == a_bb.getBackboneCarbons().size()) {
                t_bIsTerminal = true;
            }
            if ((t_cd = t_bc.getDescriptor().getChar()) == 'c' || t_cd == 'C' || t_cd == 'M' || t_cd == 't' || t_cd == 'T' || t_cd == 'K') {
                this.m_lErrors.add("CarbonDescriptor " + t_cd + " can not be handled for now.");
            }
            if (!t_bIsTerminal || t_cd != '1' && t_cd != '2' && t_cd != '3' && t_cd != '4' && t_cd != 'x' && t_cd != '5' && t_cd != '6' && t_cd != '7' && t_cd != '8' && t_cd != 'X') continue;
            this.m_lErrors.add("Tarminal carbon with stereo can not be handled for now.");
        }
    }

    private boolean hasRing(Backbone a_bb) {
        Modification t_mod = this.getRing(a_bb);
        return t_mod != null;
    }

    private Modification getRing(Backbone a_bb) {
        List<Modification> t_lRings = this.getRings(a_bb);
        if (t_lRings.isEmpty()) {
            return null;
        }
        Collections.sort(t_lRings, new Comparator<Modification>(){

            @Override
            public int compare(Modification mod1, Modification mod2) {
                int t_iSize2;
                int t_iSize1 = WURCSConversionValidatorForGlycoCT.this.getRingSize(mod1);
                if (t_iSize1 == (t_iSize2 = WURCSConversionValidatorForGlycoCT.this.getRingSize(mod2))) {
                    return 0;
                }
                if (t_iSize1 != 0 || t_iSize2 == 0) {
                    return -1;
                }
                if (t_iSize1 == 0 || t_iSize2 != 0) {
                    return 1;
                }
                if (t_iSize1 != -1 || t_iSize2 == -1) {
                    return -1;
                }
                if (t_iSize1 == -1 || t_iSize2 != -1) {
                    return 1;
                }
                int t_iComp = Math.abs(6 - t_iSize1) - Math.abs(6 - t_iSize2);
                if (t_iComp != 0) {
                    return t_iComp;
                }
                return t_iSize1 - t_iSize2;
            }
        });
        return t_lRings.get(0);
    }

    private List<Modification> getRings(Backbone a_bb) {
        ArrayList<Modification> t_lRings = new ArrayList<Modification>();
        for (WURCSEdge t_edge : a_bb.getChildEdges()) {
            if (!t_edge.getModification().isRing()) continue;
            t_lRings.add(t_edge.getModification());
        }
        return t_lRings;
    }

    private int getRingSize(Modification a_mod) {
        if (!a_mod.isRing()) {
            return 0;
        }
        WURCSEdge t_edgeStart = a_mod.getEdges().getFirst();
        WURCSEdge t_edgeEnd = a_mod.getEdges().getLast();
        if (t_edgeStart.getLinkages().size() != 1 || t_edgeEnd.getLinkages().size() != 1) {
            return -1;
        }
        if (t_edgeStart.getLinkages().getFirst().getBackbonePosition() == -1 || t_edgeEnd.getLinkages().getFirst().getBackbonePosition() == -1) {
            return -1;
        }
        int t_iStart = t_edgeStart.getLinkages().getFirst().getBackbonePosition();
        int t_iEnd = t_edgeEnd.getLinkages().getFirst().getBackbonePosition();
        return Math.abs(t_iEnd - t_iStart) + 1;
    }

    private void validateSubstituents(Modification a_mod) {
        if (a_mod.canOmitMAP()) {
            return;
        }
        String t_strMAP = a_mod.getMAPCode();
        int t_nStar = t_strMAP.length() - t_strMAP.replace("*", "").length();
        if (t_nStar > 2) {
            this.m_lErrors.add("Substituent with three or more backbone carbons can not be handled.");
        }
        if (t_nStar == 0) {
            this.m_lErrors.add("At least one backbone carbon must be in a substituent.");
        }
        if (t_nStar == 1 && SubstituentTemplate.forMAP(t_strMAP) == null) {
            this.m_lErrors.add("The substituent cannot be handled.");
        }
        if (t_nStar == 2) {
            if (CrossLinkedTemplate.forMAP(t_strMAP) == null) {
                this.m_lErrors.add("The closslinking substituent cannot be handled.");
            }
            if (a_mod.getEdges().size() != 2) {
                this.m_lErrors.add("The closslinking substituent must have two linkages.");
            }
            if (t_strMAP.startsWith("*1")) {
                for (WURCSEdge t_edge : a_mod.getEdges()) {
                    if (t_edge.getLinkages().getFirst().getModificationPosition() != 0) continue;
                    this.m_lErrors.add("The asymmetric closslinking substituent must have linkages with substituent linkage position.");
                }
            }
        }
    }
}

