/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.ExporterInterface;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACExporterUtility;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.similarity.NodeSimilarity;

public class IUPACShortExporter
extends IUPACExporterUtility
implements ExporterInterface {
    private final StringBuilder shortIUPAC = new StringBuilder();
    private final HashMap<Node, String> notationIndex = new HashMap();
    private final NodeSimilarity gu = new NodeSimilarity();

    public String getIUPACShort() {
        return this.shortIUPAC.toString();
    }

    @Override
    public void start(GlyContainer _glyCo) throws GlycanException {
        for (Node node : _glyCo.getAllNodes()) {
            this.makeMonosaccharideNotation(node);
            this.makeLinkageNotation(node);
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            for (Node node : und.getRootNodes()) {
                if (!(node instanceof Substituent)) continue;
                this.makeSubstituentNotation(und);
            }
        }
        this.makeFragmentsAnchor(_glyCo);
        if (_glyCo.isComposition()) {
            this.shortIUPAC.insert(0, this.makeComposition(_glyCo));
            return;
        }
        ArrayList<Node> sortedList = this.gu.sortAllNode(_glyCo.getRootNodes().get(0));
        this.shortIUPAC.insert(0, this.makeSequence(sortedList));
        this.shortIUPAC.insert(0, this.makeFragmentsSequence(_glyCo.getUndefinedUnit()));
    }

    @Override
    public String makeComposition(GlyContainer _glyCo) {
        return "";
    }

    @Override
    public String makeFragmentsSequence(ArrayList<GlycanUndefinedUnit> _fragments) throws GlycanException {
        StringBuilder ret = new StringBuilder();
        for (GlycanUndefinedUnit und : _fragments) {
            for (Node antennae : und.getRootNodes()) {
                ArrayList<Node> sortedFragments = this.gu.sortAllNode(antennae);
                this.shortIUPAC.insert(0, this.makeSequence(sortedFragments) + ",");
            }
        }
        return ret.toString();
    }

    @Override
    public boolean isFragmentsRoot(GlyContainer _glyco, Node _node) throws Exception {
        return false;
    }

    @Override
    public void makeFragmentsAnchor(GlyContainer _glyCo) throws GlycanException {
        if (_glyCo.isComposition()) {
            return;
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            String notation;
            int index = _glyCo.getUndefinedUnit().indexOf(und) + 1;
            for (Node antennae : und.getRootNodes()) {
                notation = this.notationIndex.get(antennae);
                notation = notation + "=" + index + "$";
                this.notationIndex.put(antennae, notation);
            }
            for (Node parent : und.getParents()) {
                notation = this.notationIndex.get(parent);
                this.notationIndex.put(parent, index + "$" + (index > 1 ? "|" : "") + notation);
            }
        }
    }

    @Override
    public void makeLinkageNotationFragmentSide(Node _node) {
    }

    @Override
    public String makeSimpleLinkageNotation(ArrayList<Edge> _edges) {
        StringBuilder linkagePos = new StringBuilder();
        Iterator<Edge> iterParent = this.gu.sortParentSideEdges(_edges).iterator();
        while (iterParent.hasNext()) {
            Edge parentEdge = iterParent.next();
            Substituent sub = (Substituent)parentEdge.getSubstituent();
            linkagePos.append(this.makeDonorPosition(parentEdge));
            if (sub != null && sub instanceof GlycanRepeatModification && !parentEdge.isCyclic()) {
                linkagePos.append("]");
                linkagePos.append(this.makeRepeatingCount((GlycanRepeatModification)parentEdge.getSubstituent()));
            }
            linkagePos.append(this.makeProbabilityAnnotation(parentEdge));
            if (!parentEdge.isRepeat() && !parentEdge.isCyclic()) {
                linkagePos.append(this.makeAcceptorPosition(parentEdge));
            }
            if (!iterParent.hasNext()) continue;
            linkagePos.append(":");
        }
        return linkagePos.toString();
    }

    @Override
    public String makeSequence(ArrayList<Node> _nodes) {
        int branch = 0;
        StringBuilder encode = new StringBuilder();
        for (Node skey : _nodes) {
            StringBuilder notation = new StringBuilder(this.notationIndex.get(skey));
            if (this.gu.isMainChaineBranch(skey)) {
                notation.append(")");
                ++branch;
            }
            if (this.gu.countChildren(skey) == 0 && branch > 0) {
                notation.insert(0, "(");
                --branch;
            }
            encode.insert(0, notation);
        }
        return encode.toString();
    }

    @Override
    public void makeSubstituentNotation(GlycanUndefinedUnit _und) {
        Node sub = _und.getNodes().get(0);
        if (!(sub instanceof Substituent)) {
            return;
        }
        if (!this.notationIndex.containsKey(sub)) {
            String subNotation = ((Substituent)sub).getSubstituent().getIUPACnotation();
            subNotation = this.extractPosition(_und.getConnection().getGlycosidicLinkages().get(0).getParentLinkages()) + subNotation;
            this.notationIndex.put(sub, subNotation);
        }
    }

    @Override
    public void makeMonosaccharideNotation(Node _node) throws GlycanException {
        IUPACNotationConverter monoIUPAC = new IUPACNotationConverter();
        Node copy = _node.copy();
        monoIUPAC.makeTrivialName(copy);
        if (!this.notationIndex.containsKey(_node)) {
            this.notationIndex.put(_node, monoIUPAC.getCoreCode());
        }
    }

    @Override
    public void makeLinkageNotation(Node _node) {
        StringBuilder notation = new StringBuilder(this.notationIndex.get(_node));
        Monosaccharide mono = (Monosaccharide)_node;
        if (!mono.getParentEdges().isEmpty()) {
            notation.append(this.makeSimpleLinkageNotation(_node.getParentEdges()));
        }
        if (mono.getParentEdges().isEmpty() && !mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN) && !this.isFacingAnoms(mono.getChildEdges())) {
            char anomericState = mono.getAnomer().getAnomericState();
            notation.append((char)(anomericState == 'x' ? 63 : (anomericState == 'o' ? 63 : (int)anomericState)));
            notation.append("-");
        }
        for (Edge edge : this.gu.sortParentSideEdges(mono.getChildEdges())) {
            Substituent sub = (Substituent)edge.getSubstituent();
            if (sub == null || !(sub instanceof GlycanRepeatModification)) continue;
            StringBuilder endReppos = new StringBuilder();
            if (!edge.isCyclic()) {
                endReppos.append("[");
            }
            if (sub.getSubstituent() != null) {
                endReppos.append(sub.getNameWithIUPAC());
            }
            endReppos.append(this.makeAcceptorPosition(edge));
            notation.insert(0, endReppos);
        }
        this.notationIndex.put(mono, notation.toString());
    }

    @Override
    public String makeAcceptorPosition(Edge _edge) {
        if (_edge.getGlycosidicLinkages().size() > 1) {
            return "";
        }
        StringBuilder ret = new StringBuilder(this.extractPosition(_edge.getGlycosidicLinkages().get(0).getParentLinkages()));
        if (this.isFacingAnom(_edge)) {
            Monosaccharide parent = (Monosaccharide)_edge.getParent();
            char parentAnom = parent.getAnomer().getAnomericState();
            ret.append(parentAnom == 'x' ? (char)'?' : (char)parentAnom);
        }
        return ret.toString();
    }

    @Override
    public String makeDonorPosition(Edge _edge) {
        StringBuilder ret = new StringBuilder();
        Node child = _edge.getChild();
        if (child != null) {
            char childAnom = ((Monosaccharide)child).getAnomer().getAnomericState();
            int childAnomPos = ((Monosaccharide)child).getAnomericPosition();
            int childPos = _edge.getGlycosidicLinkages().get(0).getChildLinkages().get(0);
            if (childPos == childAnomPos) {
                ret.append((char)(childAnom == 'x' ? 63 : (childAnom == 'o' ? 63 : (int)childAnom)));
            } else {
                ret.append(childPos == -1 ? "?" : Integer.valueOf(childPos));
            }
        }
        if (_edge.getSubstituent() != null && !(_edge.getSubstituent() instanceof GlycanRepeatModification)) {
            ret.append(((Substituent)_edge.getSubstituent()).getNameWithIUPAC());
        }
        return ret.toString();
    }
}

