/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.HashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;

public class IUPACStacker {
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<String> notations = new ArrayList();
    private HashMap<Node, Node> family = new HashMap();
    private int numOfNode = -1;
    private boolean isFragment = false;
    private boolean isComposition = false;

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public ArrayList<String> getNotations() {
        return this.notations;
    }

    public int getNumOfNode() {
        return this.numOfNode;
    }

    public void setNodes(ArrayList<Node> _nodes) {
        this.nodes.addAll(_nodes);
    }

    public void setNotations(ArrayList<String> _notations) {
        this.notations.addAll(_notations);
    }

    public void setNumOfNode(int _numOfNode) {
        this.numOfNode = _numOfNode;
    }

    public boolean isComposition() {
        return this.isComposition;
    }

    public boolean haveChild(Node _child) {
        return this.family.containsKey(_child);
    }

    public void addFamily(Node _child, Node _parent) {
        this.family.put(_child, _parent);
    }

    public Node getParent(Node _child) {
        return this.family.get(_child);
    }

    public ArrayList<Node> getChildren(Node _parent) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : this.family.keySet()) {
            if (!this.family.get(node).equals(_parent)) continue;
            ret.add(node);
        }
        return ret;
    }

    public int getIndexByNode(Node _node) {
        return this.nodes.indexOf(_node);
    }

    public String getNotationByIndex(int _ind) {
        return this.notations.get(_ind);
    }

    public Node getNodeByIndex(int _ind) {
        return this.nodes.get(_ind);
    }

    public boolean addNode(Node _node) throws GlyCoImporterException {
        if (_node == null) {
            throw new GlyCoImporterException("Invalid node.");
        }
        return this.nodes.add(_node);
    }

    public boolean addNotation(String _notation) throws GlyCoImporterException {
        if (_notation.equals("")) {
            throw new GlyCoImporterException("Invalid notation.");
        }
        return this.notations.add(_notation);
    }

    public void setFragment() {
        this.isFragment = true;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setComposition() {
        this.isComposition = true;
    }

    public Node getRoot() {
        Node ret = null;
        for (Node node : this.nodes) {
            if (this.family.get(node) != null) continue;
            ret = node;
        }
        return ret;
    }
}

