/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationStyleChecker;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed.IUPACCondensedLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed.IUPACCondensedNotationParser;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;

public class IUPACCondensedImporter {
    /*
     * WARNING - void declaration
     */
    public GlyContainer start(String _iupac) throws GlyCoImporterException, GlycanException {
        GlyContainer glyCo = new GlyContainer();
        LinkedHashMap<Node, String> nodeIndex = new LinkedHashMap<Node, String>();
        ArrayList<void> notations = new ArrayList<void>();
        _iupac = _iupac.replaceAll("[\\xc2\\xa0]", "");
        _iupac = _iupac.replaceAll(" ", "");
        _iupac = _iupac.trim();
        for (String string : _iupac.split("\\$,")) {
            void var8_10;
            if (string.matches(".+=[\\d?]")) {
                String string2 = string + "$,";
            }
            notations.add(var8_10);
        }
        Collections.reverse(notations);
        for (String subst : notations) {
            IUPACStacker stacker = new IUPACStacker();
            stacker.setNotations(this.parseNotation(subst));
            if (subst.endsWith("$,")) {
                stacker.setFragment();
            }
            for (String unit : stacker.getNotations()) {
                if (stacker.isComposition()) {
                    for (int i = stacker.getNumOfNode(); i != 0; --i) {
                        Node node = this.makeNode(unit);
                        nodeIndex.put(node, unit);
                        stacker.addNode(node);
                    }
                    continue;
                }
                Node node = this.makeNode(unit);
                nodeIndex.put(node, unit);
                stacker.addNode(node);
            }
            this.parseChildren(stacker, nodeIndex);
            IUPACCondensedLinkageParser iUPACCondensedLinkageParser = new IUPACCondensedLinkageParser(glyCo, nodeIndex, stacker);
            glyCo = iUPACCondensedLinkageParser.start();
        }
        GlyContainerOptimizer gcOpt = new GlyContainerOptimizer();
        return gcOpt.start(glyCo);
    }

    private Node makeNode(String _notation) throws GlyCoImporterException, GlycanException {
        IUPACCondensedNotationParser iupacNP = new IUPACCondensedNotationParser();
        return iupacNP.parseMonosaccharide(_notation);
    }

    private ArrayList<String> parseNotation(String _iupac) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean isLinkage = false;
        boolean isSub = false;
        StringBuilder node = new StringBuilder();
        boolean isDonorSide = false;
        boolean isAcceptorSide = false;
        boolean isBridge = false;
        boolean isFragment = false;
        boolean isBisecting = false;
        for (int i = 0; i < _iupac.length(); ++i) {
            char item = _iupac.charAt(i);
            if (isBisecting && IUPACNotationStyleChecker.isLeftBlockBracket(item)) {
                ret.add(node.toString());
                isLinkage = false;
                isAcceptorSide = false;
                isBisecting = false;
                node = new StringBuilder();
            }
            node.append(item);
            if (i == _iupac.length() - 1) {
                ret.add(node.toString());
                break;
            }
            if (IUPACNotationStyleChecker.isLeftSideBracket(item)) {
                isLinkage = true;
                continue;
            }
            if (isLinkage) {
                if (!(isDonorSide || isAcceptorSide || isBridge)) {
                    if (IUPACNotationStyleChecker.isInteger(item) || IUPACNotationStyleChecker.isAnomericState(item)) {
                        isDonorSide = true;
                        continue;
                    }
                    if (IUPACNotationStyleChecker.isAlphabet(item)) {
                        isLinkage = false;
                        continue;
                    }
                }
                if (isDonorSide && IUPACNotationStyleChecker.isHyphen(item)) {
                    isAcceptorSide = true;
                    isDonorSide = false;
                    continue;
                }
                if (isBridge && IUPACNotationStyleChecker.isHyphen(item)) {
                    isBridge = false;
                    isAcceptorSide = true;
                    continue;
                }
                if (isAcceptorSide) {
                    if (IUPACNotationStyleChecker.isAlphabet(item)) {
                        if (IUPACNotationStyleChecker.isAnomericState(item)) continue;
                        isAcceptorSide = false;
                        isDonorSide = false;
                        isBridge = true;
                        continue;
                    }
                    if (!IUPACNotationStyleChecker.isRightSideBracket(item)) continue;
                    if (IUPACNotationStyleChecker.isRightBlockBracket(_iupac.charAt(i + 1)) && IUPACNotationStyleChecker.isLeftBlockBracket(_iupac.charAt(i + 2))) {
                        isBisecting = true;
                        continue;
                    }
                    ret.add(node.toString());
                    isLinkage = false;
                    isAcceptorSide = false;
                    node = new StringBuilder();
                    continue;
                }
            }
            if (!isLinkage && node.length() == 0 && String.valueOf(item).matches("[\\d?]")) {
                isSub = true;
            }
            if (!isSub || item != ')') continue;
            ret.add(node.toString());
            node = new StringBuilder();
            isSub = false;
            isLinkage = false;
        }
        return ret;
    }

    private String replaceBlockBrakcets(String _iupac) {
        StringBuilder ret = new StringBuilder(_iupac);
        for (int i = 0; i < _iupac.length(); ++i) {
            char item = _iupac.charAt(i);
            if (item == '[' && _iupac.charAt(i + 2) != ')') {
                ret.replace(i, i + 1, "(");
            }
            if (item != ']' || _iupac.charAt(i - 1) == '-') continue;
            ret.replace(i, i + 1, ")");
        }
        return ret.toString();
    }

    private void parseChildren(IUPACStacker _stacker, LinkedHashMap<Node, String> _index) {
        ArrayList<Node> nodes = new ArrayList<Node>(_stacker.getNodes());
        Collections.reverse(nodes);
        for (Node node : nodes) {
            Node child;
            int childIndex;
            if (this.haveChild(node, _index)) {
                childIndex = nodes.indexOf(node) + 1;
                child = nodes.get(childIndex);
                _stacker.addFamily(child, node);
            }
            if (!this.isStartOfBranch(node, _index)) continue;
            childIndex = nodes.indexOf(node) + 1;
            child = nodes.get(childIndex);
            _stacker.addFamily(child, node);
            for (Node cNode : this.pickChildren(nodes, node, _index)) {
                _stacker.addFamily(cNode, node);
            }
        }
    }

    private ArrayList<Node> pickChildren(ArrayList<Node> _nodes, Node _branch, LinkedHashMap<Node, String> _index) {
        ArrayList<Node> children = new ArrayList<Node>();
        int count = 0;
        boolean isChild = false;
        if (this.isStartOfBranch(_branch, _index)) {
            count = -1;
        }
        for (Node node : _nodes.subList(_nodes.indexOf(_branch) + 1, _nodes.size())) {
            if (isChild) {
                children.add(node);
            }
            if (count == 0 && !this.isBisecting(node, _index) && (this.isStartOfBranch(node, _index) || this.isEndOfBranch(node, _index) || this.haveChild(node, _index))) break;
            if (this.isStartOfBranch(node, _index)) {
                --count;
            }
            if (this.isEndOfBranch(node, _index)) {
                ++count;
            }
            if (this.isBisecting(node, _index)) {
                --count;
            }
            if (count == 0) {
                if (this.isBisecting(node, _index)) {
                    isChild = true;
                }
                if (!this.isEndOfBranch(node, _index)) continue;
                isChild = true;
                continue;
            }
            isChild = false;
        }
        return children;
    }

    private boolean isBisecting(Node _node, LinkedHashMap<Node, String> _index) {
        int currentIndex = new ArrayList<Node>(_index.keySet()).indexOf(_node);
        if (currentIndex == 0) {
            return false;
        }
        if (!_index.get(_node).endsWith("]")) {
            return false;
        }
        Node next = new ArrayList<Node>(_index.keySet()).get(currentIndex + 1);
        return _index.get(next).startsWith("[");
    }

    private boolean haveChild(Node _node, LinkedHashMap<Node, String> _index) {
        int currentIndex = new ArrayList<Node>(_index.keySet()).indexOf(_node);
        if (currentIndex == 0) {
            return false;
        }
        if (_index.get(_node).matches(".+(=[\\d?]\\$,)$")) {
            return false;
        }
        return !_index.get(_node).startsWith("[");
    }

    private boolean isStartOfBranch(Node _node, LinkedHashMap<Node, String> _index) {
        int currentIndex = new ArrayList<Node>(_index.keySet()).indexOf(_node);
        if (currentIndex == 0) {
            return false;
        }
        if (_index.get(_node).startsWith("[")) {
            return false;
        }
        return _index.get(_node).startsWith("]");
    }

    private boolean isEndOfBranch(Node _node, LinkedHashMap<Node, String> _index) {
        return _index.get(_node).startsWith("[");
    }
}

