/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.ExporterInterface;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACExporterUtility;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended.ExtendedConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.similarity.NodeSimilarity;

public class IUPACExtendedExporter
extends IUPACExporterUtility
implements ExporterInterface {
    private final StringBuilder extended = new StringBuilder();
    private final HashMap<Node, String> notationIndex = new HashMap();
    private final NodeSimilarity gu = new NodeSimilarity();

    public String getIUPACExtended() {
        return this.extended.toString();
    }

    public String toGreek() {
        String ret = this.extended.toString();
        ret = ret.replaceAll(AnomericStateDescriptor.ALPHA.getIUPACAnomericState(), "\u03b1");
        ret = ret.replaceAll(AnomericStateDescriptor.BETA.getIUPACAnomericState(), "\u03b2");
        ret = ret.replaceAll("<->", "\u2194");
        ret = ret.replaceAll("->", "\u2192");
        ret = ret.replaceAll("<-", "\u2190");
        return ret;
    }

    @Override
    public void start(GlyContainer _glyCo) throws GlycanException, TrivialNameException {
        for (Node node : _glyCo.getAllNodes()) {
            this.makeMonosaccharideNotation(node);
            if (this.isFragmentsRoot(_glyCo, node)) {
                this.makeLinkageNotationFragmentSide(node);
                continue;
            }
            this.makeLinkageNotation(node);
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            for (Node node : und.getRootNodes()) {
                if (!(node instanceof Substituent)) continue;
                this.makeSubstituentNotation(und);
            }
        }
        this.makeFragmentsAnchor(_glyCo);
        if (_glyCo.isComposition()) {
            this.extended.insert(0, this.makeComposition(_glyCo));
            return;
        }
        ArrayList<Node> sortedList = this.gu.sortAllNode(_glyCo.getRootNodes().get(0));
        this.extended.insert(0, this.makeSequence(sortedList));
        this.extended.insert(0, this.makeFragmentsSequence(_glyCo.getUndefinedUnit()));
    }

    @Override
    public String makeComposition(GlyContainer _glyCo) {
        StringBuilder ret = new StringBuilder();
        ArrayList<String> nodeList = new ArrayList<String>();
        for (GlycanUndefinedUnit glycanUndefinedUnit : _glyCo.getUndefinedUnit()) {
            nodeList.add(this.notationIndex.get(glycanUndefinedUnit.getNodes().get(0)));
        }
        LinkedHashMap<String, Integer> block = new LinkedHashMap<String, Integer>();
        for (String notation : nodeList) {
            if (block.containsKey(notation)) {
                block.put(notation, (Integer)block.get(notation) + 1);
                continue;
            }
            block.put(notation, 1);
        }
        Iterator iterator = block.keySet().iterator();
        while (iterator.hasNext()) {
            String notation;
            notation = (String)iterator.next();
            ret.append("{").append(notation).append("}").append(block.get(notation));
            if (!iterator.hasNext()) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    @Override
    public String makeFragmentsSequence(ArrayList<GlycanUndefinedUnit> _fragments) throws GlycanException {
        StringBuilder ret = new StringBuilder();
        for (GlycanUndefinedUnit und : _fragments) {
            for (Node antennae : und.getRootNodes()) {
                ArrayList<Node> sortedFragments = this.gu.sortAllNode(antennae);
                ret.insert(0, this.makeSequence(sortedFragments) + ",");
            }
        }
        return ret.toString();
    }

    @Override
    public String makeSequence(ArrayList<Node> _nodes) {
        int branch = 0;
        StringBuilder encode = new StringBuilder();
        for (Node node : _nodes) {
            int numOfChildren;
            StringBuilder notation = new StringBuilder(this.notationIndex.get(node));
            if (this.gu.isMainChaineBranch(node)) {
                notation.append("]");
                ++branch;
            }
            if ((numOfChildren = this.gu.countChildren(node)) > 0) {
                notation.insert(0, "-");
            }
            if (numOfChildren == 0 && branch > 0) {
                notation.insert(0, "[");
                --branch;
            }
            encode.insert(0, notation);
        }
        return encode.toString();
    }

    @Override
    public void makeFragmentsAnchor(GlyContainer _glyCo) throws GlycanException {
        if (_glyCo.isComposition()) {
            return;
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            String notation;
            int index = _glyCo.getUndefinedUnit().indexOf(und) + 1;
            for (Node antennae : und.getRootNodes()) {
                notation = this.notationIndex.get(antennae);
                notation = notation + "=" + index + "$";
                this.notationIndex.put(antennae, notation);
            }
            for (Node parent : und.getParents()) {
                notation = this.notationIndex.get(parent);
                this.notationIndex.put(parent, index + "$" + (index > 1 ? "|" : "") + notation);
            }
        }
    }

    @Override
    public void makeSubstituentNotation(GlycanUndefinedUnit _und) {
        Node sub = _und.getNodes().get(0);
        if (!(sub instanceof Substituent)) {
            return;
        }
        if (!this.notationIndex.containsKey(sub)) {
            String subNotation = ((Substituent)sub).getSubstituent().getIUPACnotation();
            subNotation = this.extractPosition(_und.getConnection().getGlycosidicLinkages().get(0).getParentLinkages()) + subNotation;
            this.notationIndex.put(sub, subNotation);
        }
    }

    @Override
    public void makeMonosaccharideNotation(Node _node) throws GlycanException, TrivialNameException {
        if (!(_node instanceof Monosaccharide)) {
            return;
        }
        ExtendedConverter extConv = new ExtendedConverter();
        if (!this.notationIndex.containsKey(_node)) {
            this.notationIndex.put(_node, extConv.start(_node));
        }
    }

    @Override
    public void makeLinkageNotation(Node _node) {
        StringBuilder notation = new StringBuilder(this.notationIndex.get(_node));
        Monosaccharide mono = (Monosaccharide)_node;
        if (!mono.getParentEdges().isEmpty()) {
            notation.append(this.makeSimpleLinkageNotation(_node.getParentEdges()));
        }
        if (mono.getParentEdges().isEmpty() && mono.getAnomericPosition() != 0 && !this.isFacingAnoms(mono.getChildEdges())) {
            notation.append("-(");
            notation.append(mono.getAnomericPosition() == -1 ? "?" : Integer.valueOf(mono.getAnomericPosition()));
            notation.append("->");
        }
        for (Edge edge : this.gu.sortParentSideEdges(mono.getChildEdges())) {
            Substituent sub = (Substituent)edge.getSubstituent();
            if (sub == null || !(sub instanceof GlycanRepeatModification)) continue;
            StringBuilder endReppos = new StringBuilder();
            if (!edge.isCyclic()) {
                endReppos.append("[");
            }
            if (sub.getSubstituent() != null) {
                endReppos.append("-");
                endReppos.append(sub.getFirstPosition() == null ? "" : this.extractPosition(sub.getFirstPosition().getChildLinkages()));
                endReppos.append(sub.getNameWithIUPAC());
                endReppos.append(sub.getSecondPosition() == null ? "" : this.extractPosition(sub.getSecondPosition().getChildLinkages()));
                endReppos.append("-");
            }
            endReppos.append(this.makeAcceptorPosition(edge));
            endReppos.append(")-");
            notation.insert(0, endReppos);
        }
        this.notationIndex.put(mono, notation.toString());
    }

    @Override
    public String makeSimpleLinkageNotation(ArrayList<Edge> _edges) {
        StringBuilder linkagePos = new StringBuilder("-(");
        Iterator<Edge> iterParent = this.gu.sortParentSideEdges(_edges).iterator();
        while (iterParent.hasNext()) {
            Edge parentEdge = iterParent.next();
            if (parentEdge.isCyclic() && linkagePos.charAt(linkagePos.length() - 1) == ':') {
                linkagePos.append("(");
            }
            linkagePos.append(this.makeDonorPosition(parentEdge));
            if (parentEdge.isRepeat()) {
                linkagePos.append("]");
                linkagePos.append(this.makeRepeatingCount((GlycanRepeatModification)parentEdge.getSubstituent()));
            }
            linkagePos.append(this.makeProbabilityAnnotation(parentEdge));
            if (!(parentEdge.getSubstituent() instanceof GlycanRepeatModification)) {
                linkagePos.append(this.makeAcceptorPosition(parentEdge));
                if (!iterParent.hasNext()) {
                    linkagePos.append(")");
                }
            }
            if (!iterParent.hasNext()) continue;
            linkagePos.append(":");
        }
        return linkagePos.toString();
    }

    @Override
    public void makeLinkageNotationFragmentSide(Node _node) {
        if (_node.getParentEdges().isEmpty()) {
            return;
        }
        StringBuilder notation = new StringBuilder(this.notationIndex.get(_node));
        Monosaccharide mono = (Monosaccharide)_node;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(mono.getParentEdge());
        notation.append(this.makeSimpleLinkageNotation(edges));
        this.notationIndex.put(mono, notation.toString());
    }

    @Override
    public String makeAcceptorPosition(Edge _edge) {
        if (_edge.getGlycosidicLinkages().size() > 1) {
            return "";
        }
        return this.extractPosition(_edge.getGlycosidicLinkages().get(0).getParentLinkages());
    }

    @Override
    public String makeDonorPosition(Edge _edge) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.extractPosition(_edge.getGlycosidicLinkages().get(0).getChildLinkages()));
        if (this.isFacingAnom(_edge)) {
            ret.append("<");
        }
        if (_edge.getSubstituent() != null && !(_edge.getSubstituent() instanceof GlycanRepeatModification)) {
            Substituent sub = (Substituent)_edge.getSubstituent();
            ret.append("-");
            ret.append(sub.getFirstPosition() == null ? "" : this.extractPosition(sub.getFirstPosition().getChildLinkages()));
            ret.append(sub.getNameWithIUPAC());
            ret.append(sub.getSecondPosition() == null ? "" : this.extractPosition(sub.getSecondPosition().getChildLinkages()));
            ret.append("-");
            ret.append(">");
        } else {
            ret.append("-");
            ret.append(">");
        }
        return ret.toString();
    }

    @Override
    public boolean isFragmentsRoot(GlyContainer _glyco, Node _node) throws GlycanException {
        boolean ret = false;
        for (GlycanUndefinedUnit und : _glyco.getUndefinedUnit()) {
            if (!und.getRootNodes().get(0).equals(_node)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean isLinkageByAnomericPosition(Edge _parentEdge) {
        if (_parentEdge.getChild() == null) {
            return false;
        }
        Monosaccharide child = (Monosaccharide)_parentEdge.getChild();
        ArrayList<Integer> childPos = _parentEdge.getGlycosidicLinkages().get(0).getChildLinkages();
        if (child.getAnomericPosition() == -1) {
            return false;
        }
        if (child.getAnomer().equals((Object)AnomericStateDescriptor.UNKNOWN)) {
            return true;
        }
        if (child.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
            return true;
        }
        return childPos.contains(child.getAnomericPosition());
    }
}

