/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;

public class IUPACLinkageParser
extends SubstituentUtility {
    private final HashMap<Node, String> nodeIndex;
    private final GlyContainer glyCo;
    private final IUPACStacker stacker;

    public GlyContainer getGlyCo() {
        return this.glyCo;
    }

    public IUPACLinkageParser(GlyContainer _glyCo, LinkedHashMap<Node, String> _nodeIndex, IUPACStacker _stacker) {
        this.glyCo = _glyCo;
        this.nodeIndex = _nodeIndex;
        this.stacker = _stacker;
    }

    public void start() throws GlycanException {
        for (Node node : this.stacker.getNodes()) {
            String notation = this.nodeIndex.get(node);
            if (!this.isRootOfFramgnets(notation) && !this.stacker.isComposition()) continue;
            this.glyCo.addGlycanUndefinedUnit(this.makeUndefinedUnit(node, notation));
        }
        for (Node node : this.stacker.getNodes()) {
            this.parseLinkage(node);
        }
    }

    public GlycanUndefinedUnit makeUndefinedUnit(Node _node, String _notation) throws GlycanException {
        GlycanUndefinedUnit ret = new GlycanUndefinedUnit();
        ret.addNode(_node);
        for (Node parent : this.parseFragmentParents(_notation)) {
            ret.addParentNode(parent);
        }
        return ret;
    }

    public ArrayList<Node> parseFragmentParents(String _fragment) {
        ArrayList<Node> ret = new ArrayList<Node>();
        String anchor = _fragment.substring(_fragment.indexOf("=") + 1, _fragment.length() - 1);
        for (Node node : this.nodeIndex.keySet()) {
            String target;
            String notation = this.nodeIndex.get(node);
            if (notation.equals(_fragment)) continue;
            if (notation.contains("=") && notation.startsWith("?$") && anchor.equals(target = notation.endsWith(",") ? notation.substring(notation.indexOf("=") + 1, notation.length() - 1) : notation.substring(notation.indexOf("=") + 1))) {
                ret.add(node);
            }
            if (!notation.contains("|") && !notation.contains("$") || notation.contains("=")) continue;
            String temp = "";
            for (int i = 0; i < notation.length(); ++i) {
                char unit = notation.charAt(i);
                if (String.valueOf(unit).matches("\\d")) {
                    temp = temp + unit;
                }
                if (unit != '$') continue;
                if (anchor.endsWith(temp = temp + unit)) {
                    ret.add(node);
                }
                temp = "";
            }
        }
        return ret;
    }

    public void parseLinkage(Node _node) throws GlycanException {
        String notation = this.nodeIndex.get(_node);
        Node parent = this.stacker.getParent(_node);
        Matcher matStartRep = Pattern.compile("\\(([\\d?/]+)[\u2192\\-]](([n\\d]+)-?([n\\d]+)?)(-.+|:.+)?").matcher(notation);
        Matcher matSubFrag = Pattern.compile("([\\d?]).+=\\d+\\$,").matcher(notation);
        if (matStartRep.find()) {
            this.parseRepeating(_node, parent, matStartRep.group(5));
        } else if (matSubFrag.find()) {
            if (_node instanceof Substituent) {
                this.parseFragmentsLinkage(_node, matSubFrag.group(1));
            }
            if (_node instanceof Monosaccharide) {
                this.parseSimpleLinkage(_node, parent, notation);
            }
        } else {
            this.parseSimpleLinkage(_node, parent, notation);
        }
        if (this.isEndCyclic(notation)) {
            this.parseCyclic(_node, this.getIndex(this.nodeIndex.size() - 1));
        }
        if (parent == null && !this.glyCo.containsNode(_node) && !this.glyCo.containsAntennae(_node)) {
            this.glyCo.addNode(_node);
        }
    }

    private void parseSimpleLinkage(Node _node, Node _parent, String _notation) throws GlycanException {
        String linkage = this.extractLinkageNotation(_notation);
        int count = 0;
        for (String unit : linkage.split(":")) {
            Matcher matLin = Pattern.compile("([\\d?])+([-\u2190](\\d)?([(a-zA-Z)]+)+(\\d)?)?[-\u2192\u2194]?(([\\d?]+),?([\\d?]+)?%)?([\\d?/]+)?").matcher(unit);
            if (matLin.find()) {
                GlycanUndefinedUnit und;
                Edge parentEdge = new Edge();
                Linkage lin = new Linkage();
                lin.setChildLinkages(this.makeLinkageList(matLin.group(1)));
                if (matLin.group(4) != null) {
                    BaseCrossLinkedTemplate subface = BaseCrossLinkedTemplate.forIUPACNotation(matLin.group(4));
                    Substituent bridge = new Substituent(subface, new Linkage(), new Linkage());
                    bridge.getFirstPosition().setParentLinkages(this.makeLinkageList(matLin.group(1)));
                    bridge.getSecondPosition().setParentLinkages(this.makeLinkageList(matLin.group(9)));
                    if (matLin.group(5) != null) {
                        bridge.getSecondPosition().addChildLinkage(Integer.parseInt(matLin.group(5)));
                    }
                    if (matLin.group(3) != null) {
                        bridge.getFirstPosition().addChildLinkage(Integer.parseInt(matLin.group(3)));
                    }
                    parentEdge.setSubstituent(bridge);
                    bridge.addParentEdge(parentEdge);
                }
                if (matLin.group(7) != null) {
                    if (matLin.group(7).equals("?")) {
                        lin.setProbabilityLower(-1.0);
                    } else {
                        lin.setProbabilityLower(Double.parseDouble(matLin.group(7)) * 0.01);
                    }
                }
                if (matLin.group(8) != null) {
                    if (matLin.group(8).equals("?")) {
                        lin.setProbabilityUpper(-1.0);
                    } else {
                        lin.setProbabilityUpper(Double.parseDouble(matLin.group(8)) * 0.01);
                    }
                } else if (matLin.group(8) == null && matLin.group(7) != null) {
                    if (matLin.group(7).equals("?")) {
                        lin.setProbabilityUpper(-1.0);
                    } else {
                        lin.setProbabilityUpper(Double.parseDouble(matLin.group(7)) * 0.01);
                    }
                }
                if (matLin.group(9) != null) {
                    lin.setParentLinkages(this.makeLinkageList(matLin.group(9)));
                }
                parentEdge.addGlycosidicLinkage(lin);
                if (_parent != null) {
                    _parent = this.modifyMonosaccharideState(_parent, matLin.group(0), matLin.group(9));
                    if (!this.stacker.isFragment()) {
                        this.glyCo.addNode(_parent, parentEdge, _node);
                    } else {
                        und = this.glyCo.getUndefinedUnitWithIndex(this.stacker.getRoot());
                        und.addNode(_parent, parentEdge, _node);
                    }
                }
                if (matLin.group(9) != null && _parent == null) {
                    _node.addParentEdge(parentEdge);
                    parentEdge.setChild(_node);
                    und = this.glyCo.getUndefinedUnitWithIndex(_node);
                    parentEdge.setParent(und.getParents().get(count));
                    und.setConnection(parentEdge);
                    und.addConnection(parentEdge);
                }
            }
            ++count;
        }
    }

    private void parseRepeating(Node _node, Node _parent, String _repOutParent) throws GlycanException {
        String childPos = "";
        String parentPos = "";
        String count = "";
        TreeMap<Integer, String> repPos = this.extractMultipleRepStart(_node);
        ArrayList<Node> endNodes = this.getEndRepeatingNode(_node);
        for (Node endRep : endNodes) {
            String startPos = repPos.get(endNodes.indexOf(endRep) + 1);
            Matcher matStartRep = Pattern.compile("([\\d?/]+)[\u2192\\-]](([n\\d]+)-?([n\\d]+)?)").matcher(startPos);
            if (matStartRep.find()) {
                childPos = matStartRep.group(1);
                count = matStartRep.group(2);
            }
            Matcher matEndRep = Pattern.compile("\\[(-(\\w)-)?([\\d?/]+)\\)").matcher(this.nodeIndex.get(endRep));
            childPos = childPos != null ? childPos : "?";
            parentPos = "?";
            Edge repeatEdge = new Edge();
            Linkage repeatLin = new Linkage();
            if (!matEndRep.find()) continue;
            if (matEndRep.group(3) != null) {
                parentPos = matEndRep.group(3);
            }
            repeatLin.setChildLinkages(this.makeLinkageList(childPos));
            repeatLin.setParentLinkages(this.makeLinkageList(parentPos));
            repeatEdge.addGlycosidicLinkage(repeatLin);
            BaseCrossLinkedTemplate subface = null;
            if (matEndRep.group(2) != null) {
                subface = BaseCrossLinkedTemplate.forIUPACNotation(matEndRep.group(2));
            }
            GlycanRepeatModification repMod = new GlycanRepeatModification(subface);
            repMod.setFirstPosition(new Linkage());
            repMod.setSecondPosition(new Linkage());
            String[] repCount = count.split("-");
            String max = "n";
            String min = repCount[0];
            if (repCount.length == 2) {
                max = repCount[1];
            }
            repMod.setMaxRepeatCount(max.equals("n") ? -1 : Integer.parseInt(max));
            repMod.setMinRepeatCount(min.equals("n") ? -1 : Integer.parseInt(min));
            repeatEdge.setSubstituent(repMod);
            repMod.addParentEdge(repeatEdge);
            this.glyCo.addNode(endRep, repeatEdge, _node);
        }
        if (_parent != null) {
            Matcher matParent;
            Edge parentEdge = new Edge();
            Linkage lin = new Linkage();
            if (_repOutParent != null && (matParent = Pattern.compile("([\\d?])(-([(\\w)]+))?[-\u2192\u2194]([\\d?/]+)\\)").matcher(_repOutParent)).find()) {
                childPos = matParent.group(1);
                parentPos = matParent.group(4);
                if (matParent.group(3) != null) {
                    BaseCrossLinkedTemplate subface = BaseCrossLinkedTemplate.forIUPACNotation(matParent.group(3));
                    Substituent bridge = new Substituent(subface, new Linkage(), new Linkage());
                    parentEdge.setSubstituent(bridge);
                    bridge.addParentEdge(parentEdge);
                }
            }
            lin.setChildLinkages(this.makeLinkageList(childPos));
            lin.setParentLinkages(this.makeLinkageList(parentPos));
            parentEdge.addGlycosidicLinkage(lin);
            this.glyCo.addNode(_parent, parentEdge, _node);
        }
    }

    private void parseCyclic(Node _node, Node _startCyclic) throws GlycanException {
        String start = this.nodeIndex.get(_startCyclic);
        String end = this.nodeIndex.get(_node).replaceFirst("([]\\-]+)", "");
        String startPos = start.substring(start.length() - 2, start.length() - 1);
        Linkage lin = new Linkage();
        lin.addChildLinkage(startPos.equals("?") ? -1 : Integer.parseInt(startPos));
        String endPos = String.valueOf(end.charAt(0));
        lin.setParentLinkages(this.makeLinkageList(endPos));
        Edge cyclicEdge = new Edge();
        cyclicEdge.addGlycosidicLinkage(lin);
        GlycanRepeatModification repMod = new GlycanRepeatModification(null);
        repMod.setMaxRepeatCount(1);
        repMod.setMinRepeatCount(1);
        cyclicEdge.setSubstituent(repMod);
        this.glyCo.addNode(_node, cyclicEdge, _startCyclic);
    }

    private void parseFragmentsLinkage(Node _node, String _linkagePosition) throws GlycanException {
        if (_node instanceof Monosaccharide) {
            return;
        }
        GlycanUndefinedUnit und = this.glyCo.getUndefinedUnitWithIndex(_node);
        for (Node coreNode : und.getParents()) {
            Edge acceptor = new Edge();
            Linkage lin = new Linkage();
            lin.setParentLinkages(this.makeLinkageList(_linkagePosition));
            lin.setChildLinkages(this.makeLinkageList("1"));
            acceptor.setSubstituent(_node);
            acceptor.addGlycosidicLinkage(lin);
            acceptor.setParent(coreNode);
            und.addConnection(acceptor);
            _node.addParentEdge(acceptor);
        }
        und.setConnection(und.getConnections().get(0));
    }

    private String extractLinkageNotation(String _linkage) {
        if (!_linkage.contains("-(")) {
            return "";
        }
        if ((_linkage = _linkage.substring(_linkage.indexOf("-(") + 1)).matches("^\\(.+")) {
            _linkage = _linkage.substring(1);
        }
        if (_linkage.lastIndexOf(")") != -1) {
            _linkage = _linkage.substring(0, _linkage.lastIndexOf(")"));
        }
        return _linkage;
    }

    private ArrayList<Node> getEndRepeatingNode(Node _node) {
        int size = new ArrayList<Node>(this.nodeIndex.keySet()).indexOf(_node) + 1;
        ArrayList<Node> nodes = this.stacker.getNodes();
        List<Node> subNodes = nodes.subList(0, size);
        Collections.reverse(subNodes);
        ArrayList<Node> ret = this.countRepeats(subNodes);
        if (ret.isEmpty()) {
            ret = this.countRepeats(this.stacker.getNodes().subList(this.stacker.getNodes().indexOf(_node), this.stacker.getNodes().size()));
        }
        return ret;
    }

    private ArrayList<Node> countRepeats(Collection<Node> _nodes) {
        int numOfstart = 0;
        String regex = "\\[(-[\\w()]+-)?[\\d?/]+\\)";
        ArrayList<Node> retNodes = new ArrayList<Node>();
        Node start = new ArrayList<Node>(_nodes).get(0);
        TreeMap<Integer, String> repPos = this.extractMultipleRepStart(start);
        block0: for (Integer key : repPos.keySet()) {
            numOfstart = key;
            for (Node node : _nodes) {
                String notation = this.nodeIndex.get(node);
                if (!this.isStartRep(notation) && !this.isEndRep(notation)) continue;
                if (this.isStartRep(notation) && !node.equals(start)) {
                    numOfstart += this.extractMultipleRepStart(node).size();
                }
                Matcher matEndRep = Pattern.compile(regex).matcher(notation);
                while (matEndRep.find()) {
                    String repStatus = matEndRep.group(0);
                    if (this.isEndRep(repStatus + "-")) {
                        if (numOfstart != 0) {
                            --numOfstart;
                        }
                        if (numOfstart == 0) {
                            retNodes.add(node);
                            break;
                        }
                    }
                    notation = notation.replaceFirst(regex, "");
                    matEndRep = Pattern.compile(regex).matcher(notation);
                }
                if (numOfstart != 0) continue;
                continue block0;
            }
        }
        return retNodes;
    }

    private TreeMap<Integer, String> extractMultipleRepStart(Node _node) {
        String repStart = this.nodeIndex.get(_node);
        TreeMap<Integer, String> repPosMap = new TreeMap<Integer, String>();
        int key = 1;
        for (String pos : repStart.substring(repStart.indexOf("-(") + 2).split(":")) {
            if (!this.isStartRep(pos)) continue;
            repPosMap.put(key, pos);
            ++key;
        }
        return repPosMap;
    }

    private Node getStartRepeatingNode(Node _node) {
        int start;
        Node ret = null;
        for (int i = start = new ArrayList<Node>(this.nodeIndex.keySet()).indexOf(_node); i < this.nodeIndex.size(); ++i) {
            if (!this.isStartRep(this.stacker.getNotationByIndex(i))) continue;
            ret = this.getIndex(i);
            break;
        }
        return ret;
    }

    private Node getIndex(int _ind) {
        return this.stacker.getNodeByIndex(_ind);
    }

    private boolean isEndCyclic(String _notation) {
        _notation = _notation.replaceFirst("([]\\-]+)", "");
        return _notation.matches("^[\\d?]\\).+");
    }

    private boolean isStartRep(String _notation) {
        return _notation.matches(".*\\(*[\\d?]+[\u2192-]][\\w\\d].*$");
    }

    private boolean isEndRep(String _notation) {
        return _notation.matches("^.*\\[(-\\w-)?[\\d?/]+\\).+");
    }

    private boolean isRootOfFramgnets(String _notation) {
        if (_notation.lastIndexOf("$,") != -1) {
            return true;
        }
        return _notation.lastIndexOf("$") == _notation.length() - 1;
    }

    private LinkedList<Integer> makeLinkageList(String _pos) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (String pos : _pos.split("/")) {
            if (pos.equals("?")) {
                ret.addLast(-1);
                continue;
            }
            ret.addLast(Integer.parseInt(pos));
        }
        return ret;
    }

    private Node modifyMonosaccharideState(Node _acceptor, String _linkage, String _acceptorPos) throws GlycanException {
        if (_acceptor instanceof Substituent) {
            return _acceptor;
        }
        if (!_linkage.matches(".+\u2194.+")) {
            return _acceptor;
        }
        Monosaccharide acceptor = (Monosaccharide)_acceptor;
        String acceptorNotation = this.nodeIndex.get(_acceptor);
        if (acceptorNotation.contains("-(")) {
            acceptorNotation = acceptorNotation.substring(0, acceptorNotation.indexOf("-("));
        }
        Matcher matMono = Pattern.compile(".+([pf?]).*").matcher(acceptorNotation);
        String ringSize = "";
        if (matMono.find()) {
            ringSize = matMono.group(1);
        }
        if (_acceptorPos.equals("1") || _acceptorPos.equals("2")) {
            acceptor.setAnomericPosition(Integer.parseInt(_acceptorPos));
        } else {
            acceptor.setAnomericPosition(-1);
        }
        if (ringSize.equals("")) {
            String stereo = acceptor.getStereos().getFirst();
            stereo = stereo.length() == 4 ? stereo.substring(1) : stereo;
            MonosaccharideIndex mi = MonosaccharideIndex.forTrivialNameWithIgnore(stereo);
            ringSize = mi.getRingSize();
        }
        if (ringSize.equals("p")) {
            if (acceptor.getAnomericPosition() == 1) {
                acceptor.setRing(1, 5);
            }
            if (acceptor.getAnomericPosition() == 2) {
                acceptor.setRing(2, 6);
            }
        } else if (ringSize.equals("f")) {
            if (acceptor.getAnomericPosition() == 1) {
                acceptor.setRing(1, 4);
            }
            if (acceptor.getAnomericPosition() == 2) {
                acceptor.setRing(2, 5);
            }
        } else {
            acceptor.setRing(acceptor.getAnomericPosition(), -1);
        }
        return _acceptor;
    }
}

