/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.glycam;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;

public class GLYCAMNotationConverter
extends IUPACNotationConverter {
    public String start(Node _node) throws GlycanException, TrivialNameException {
        Node copy = _node.copy();
        this.makeTrivialName(copy);
        return this.makeGLYCAMNotation(copy);
    }

    private String makeGLYCAMNotation(Node _node) {
        SuperClass superclass;
        Monosaccharide mono = (Monosaccharide)_node;
        String threeLetter = this.getThreeLetterCode();
        String configuration = "?";
        if (!mono.getStereos().isEmpty()) {
            configuration = this.makeConfiguration(mono.getStereos().getFirst()).toUpperCase();
        }
        StringBuilder ret = new StringBuilder(threeLetter);
        MonosaccharideIndex monoInd = MonosaccharideIndex.forTrivialNameWithIgnore(threeLetter);
        if (monoInd != null && mono.getStereos().size() == 1) {
            ret.insert(0, configuration);
        }
        if ((superclass = SuperClass.forSuperClassWithIgnore(threeLetter)) != null) {
            ret.insert(0, configuration);
        }
        String ringSize = this.defineRingSize(_node);
        ret.append(ringSize);
        HashMap<String, String> mapSubs = this.getSubConv().getMapSubs();
        String coreSubstituent = this.getSubConv().getCoreSubstituentNotaiton();
        if (coreSubstituent.equals("N")) {
            mapSubs.put("N", "2");
        } else {
            ret.append(this.getSubConv().getCoreSubstituentNotaiton());
        }
        String acidicStatus = this.makeAcidicStatus(_node);
        if (acidicStatus.equals("A")) {
            mapSubs.put(acidicStatus, "6");
        }
        if (!mapSubs.isEmpty()) {
            ret.append("[");
            ret.append(this.makeSubstituentNotation(mapSubs));
            ret.append("]");
        }
        return ret.toString();
    }

    private String makeSubstituentNotation(HashMap<String, String> _mapSubs) {
        StringBuilder ret = new StringBuilder();
        TreeMap<Integer, String> mapSubs = this.modifySubstituentMap(_mapSubs);
        Iterator<Integer> iterPos = mapSubs.keySet().iterator();
        while (iterPos.hasNext()) {
            Integer pos = iterPos.next();
            ret.append(pos);
            ret.append(mapSubs.get(pos));
            if (!iterPos.hasNext()) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    private TreeMap<Integer, String> modifySubstituentMap(HashMap<String, String> _mapSubs) {
        TreeMap<Integer, String> temp = new TreeMap<Integer, String>();
        for (String key : _mapSubs.keySet()) {
            String positions = _mapSubs.get(key);
            String notation = key;
            if (key.matches("C[A-Za-z]+.*")) {
                notation = key.replaceFirst("C", "");
            }
            if (key.matches("O[A-Za-z]+.*")) {
                notation = key.replaceFirst("O", "");
            }
            for (String position : positions.split(",")) {
                temp.put(Integer.parseInt(position), notation);
            }
        }
        return temp;
    }
}

