/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.io.JSON.JSONParamAnalyzer;
import org.json.JSONObject;

public class GCJSONEdgeParser {
    private HashMap<String, Node> nodeIndex;

    public GCJSONEdgeParser(HashMap<String, Node> _nodeIndex) {
        this.nodeIndex = _nodeIndex;
    }

    public GlyContainer start(JSONObject _edges, JSONObject _bridge) throws GlycanException {
        GlyContainer ret = new GlyContainer();
        if (_edges.isEmpty() && this.nodeIndex.size() == 1) {
            ret.addNode(this.nodeIndex.get("m0"));
            return ret;
        }
        for (String key : _edges.keySet()) {
            JSONObject edgeObj = _edges.getJSONObject(key);
            Edge edge = new Edge();
            Node donor = this.nodeIndex.get(edgeObj.getJSONObject("Donor").get("Node"));
            Node acceptor = this.nodeIndex.get(edgeObj.getJSONObject("Acceptor").get("Node"));
            Linkage lin = new Linkage();
            lin.setParentLinkages(JSONParamAnalyzer.parsePosition(edgeObj.getJSONObject("Acceptor").getJSONArray("Position")));
            lin.setParentLinkageType(JSONParamAnalyzer.parseLinkageType(edgeObj.getJSONObject("Acceptor").get("LinkageType")));
            lin.setChildLinkages(JSONParamAnalyzer.parsePosition(edgeObj.getJSONObject("Donor").getJSONArray("Position")));
            lin.setChildLinkageType(JSONParamAnalyzer.parseLinkageType(edgeObj.getJSONObject("Donor").get("LinkageType")));
            lin.setProbabilityUpper(JSONParamAnalyzer.parseProbability(edgeObj.getJSONObject("Probability").get("High")));
            lin.setProbabilityLower(JSONParamAnalyzer.parseProbability(edgeObj.getJSONObject("Probability").get("Low")));
            edge.addGlycosidicLinkage(lin);
            JSONObject jsonBridge = JSONParamAnalyzer.extractBridgeBlock(edgeObj, _bridge);
            if (jsonBridge == null || !jsonBridge.get("Target").equals(key)) {
                ret.addNode(acceptor, edge, donor);
                continue;
            }
            SubstituentInterface subFace = JSONParamAnalyzer.extractBridge(edgeObj, _bridge);
            if (subFace == null) {
                ret.addNode(acceptor, edge, donor);
                continue;
            }
            JSONObject bridgeObj = JSONParamAnalyzer.extractBridgeBlock(edgeObj, _bridge);
            Substituent bridge = new Substituent(subFace);
            bridge.setFirstPosition(new Linkage());
            bridge.setSecondPosition(new Linkage());
            bridge.getFirstPosition().setParentLinkages(JSONParamAnalyzer.parsePosition(edgeObj.getJSONObject("Acceptor").getJSONArray("Position")));
            bridge.getFirstPosition().setParentLinkageType(JSONParamAnalyzer.parseLinkageType(edgeObj.getJSONObject("Acceptor").get("LinkageType")));
            bridge.getFirstPosition().setChildLinkages(new ArrayList<Integer>(1));
            bridge.getFirstPosition().setChildLinkageType(JSONParamAnalyzer.parseLinkageType(bridgeObj.getJSONObject("Donor").get("LinkageType")));
            bridge.getSecondPosition().setParentLinkages(JSONParamAnalyzer.parsePosition(edgeObj.getJSONObject("Donor").getJSONArray("Position")));
            bridge.getSecondPosition().setParentLinkageType(JSONParamAnalyzer.parseLinkageType(bridgeObj.getJSONObject("Acceptor").get("LinkageType")));
            bridge.getSecondPosition().setChildLinkages(new ArrayList<Integer>(1));
            bridge.getSecondPosition().setChildLinkageType(JSONParamAnalyzer.parseLinkageType(edgeObj.getJSONObject("Donor").get("LinkageType")));
            if (bridge.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.H_AT_OH)) {
                bridge.setHeadAtom("O");
            }
            if (bridge.getSecondPosition().getChildLinkageType().equals((Object)LinkageType.H_AT_OH)) {
                bridge.setTailAtom("O");
            }
            edge.setSubstituent(bridge);
            bridge.addParentEdge(edge);
            ret.addNode(acceptor, edge, donor);
        }
        return ret;
    }
}

