/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.HashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.JSON.JSONParamAnalyzer;
import org.json.JSONObject;

public class GCJSONFragmentsParser {
    private HashMap<String, Node> nodeIndex;

    public GCJSONFragmentsParser(HashMap<String, Node> _nodeIndex) {
        this.nodeIndex = _nodeIndex;
    }

    public GlyContainer start(JSONObject _fragment, GlyContainer _glyCo) throws GlycanException {
        for (String id : _fragment.keySet()) {
            GlycanUndefinedUnit und = new GlycanUndefinedUnit();
            JSONObject frgObj = _fragment.getJSONObject(id);
            Node root = null;
            for (Object acceptor : frgObj.getJSONObject("Acceptor").getJSONArray("Node")) {
                Edge edge = new Edge();
                Linkage lin = new Linkage();
                und.addParentNode(this.nodeIndex.get(acceptor));
                lin.setParentLinkages(JSONParamAnalyzer.parsePosition(frgObj.getJSONObject("Acceptor").getJSONArray("Position")));
                lin.setChildLinkages(JSONParamAnalyzer.parsePosition(frgObj.getJSONObject("Donor").getJSONArray("Position")));
                lin.setProbabilityLower(JSONParamAnalyzer.parseProbability(frgObj.getJSONObject("Probability").get("Low")));
                lin.setProbabilityUpper(JSONParamAnalyzer.parseProbability(frgObj.getJSONObject("Probability").get("High")));
                lin.setParentLinkageType(JSONParamAnalyzer.parseLinkageType(frgObj.getJSONObject("Acceptor").get("LinkageType")));
                lin.setChildLinkageType(JSONParamAnalyzer.parseLinkageType(frgObj.getJSONObject("Donor").get("LinkageType")));
                if (this.isSubstituentFragment(frgObj)) {
                    root = new Substituent(JSONParamAnalyzer.parseSubstituentTemplate((String)frgObj.getJSONObject("Donor").get("Notation")), lin);
                    if (lin.getParentLinkageType().equals((Object)LinkageType.H_AT_OH)) {
                        ((Substituent)root).setHeadAtom("O");
                    }
                    if (lin.getParentLinkageType().equals((Object)LinkageType.DEOXY)) {
                        ((Substituent)root).setHeadAtom("C");
                    }
                    edge.setSubstituent(root);
                } else {
                    root = this.nodeIndex.get(frgObj.getJSONObject("Donor").get("Node"));
                    edge.setChild(root);
                }
                edge.addGlycosidicLinkage(lin);
                edge.setParent(this.nodeIndex.get(acceptor));
                und.addConnection(edge);
            }
            root.setParentEdge(und.getConnections());
            und.addNode(root);
            und.setConnection(und.getConnections().get(0));
            _glyCo.addGlycanUndefinedUnit(und);
        }
        return _glyCo;
    }

    private boolean isSubstituentFragment(JSONObject _frgObj) {
        return _frgObj.getJSONObject("Donor").has("Notation");
    }
}

