/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.HashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.JSON.JSONParamAnalyzer;
import org.json.JSONObject;

public class GCJSONRepeatParser {
    private HashMap<String, Node> nodeIndex;

    public GCJSONRepeatParser(HashMap<String, Node> _nodeIndex) {
        this.nodeIndex = _nodeIndex;
    }

    public GlyContainer start(JSONObject _repeat, JSONObject _bridge, GlyContainer _glyCo) throws GlycanException {
        for (String id : _repeat.keySet()) {
            JSONObject repObj = _repeat.getJSONObject(id);
            JSONObject bridgeObj = JSONParamAnalyzer.extractBridgeBlock(repObj, _bridge);
            GlycanRepeatModification repMod = new GlycanRepeatModification(JSONParamAnalyzer.extractBridge(repObj, _bridge));
            repMod.setFirstPosition(new Linkage());
            repMod.setSecondPosition(new Linkage());
            if (bridgeObj != null) {
                repMod.getFirstPosition().setParentLinkageType(JSONParamAnalyzer.parseLinkageType(repObj.getJSONObject("Acceptor").get("LinkageType")));
                repMod.getFirstPosition().setChildLinkageType(JSONParamAnalyzer.parseLinkageType(bridgeObj.getJSONObject("Donor").get("LinkageType")));
                repMod.getSecondPosition().setParentLinkageType(JSONParamAnalyzer.parseLinkageType(bridgeObj.getJSONObject("Acceptor").get("LinkageType")));
                repMod.getSecondPosition().setChildLinkageType(JSONParamAnalyzer.parseLinkageType(repObj.getJSONObject("Donor").get("LinkageType")));
                if (repMod.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.H_AT_OH)) {
                    repMod.setHeadAtom("O");
                }
                if (repMod.getSecondPosition().getChildLinkageType().equals((Object)LinkageType.H_AT_OH)) {
                    repMod.setTailAtom("O");
                }
            }
            repMod.setMinRepeatCount((Integer)repObj.get("Min"));
            repMod.setMaxRepeatCount((Integer)repObj.get("Max"));
            String start = (String)repObj.getJSONObject("Donor").get("Node");
            String end = (String)repObj.getJSONObject("Acceptor").get("Node");
            Node endNode = this.nodeIndex.get(end);
            Node startNode = this.nodeIndex.get(start);
            Linkage repPos = new Linkage();
            repPos.setChildLinkages(JSONParamAnalyzer.parsePosition(repObj.getJSONObject("Donor").getJSONArray("Position")));
            repPos.setChildLinkageType(JSONParamAnalyzer.parseLinkageType(repObj.getJSONObject("Donor").get("LinkageType")));
            repPos.setParentLinkages(JSONParamAnalyzer.parsePosition(repObj.getJSONObject("Acceptor").getJSONArray("Position")));
            repPos.setParentLinkageType(JSONParamAnalyzer.parseLinkageType(repObj.getJSONObject("Acceptor").get("LinkageType")));
            repPos.setProbabilityUpper(JSONParamAnalyzer.parseProbability(repObj.getJSONObject("Probability").get("High")));
            repPos.setProbabilityLower(JSONParamAnalyzer.parseProbability(repObj.getJSONObject("Probability").get("Low")));
            Edge repEdge = new Edge();
            repEdge.addGlycosidicLinkage(repPos);
            repEdge.setSubstituent(repMod);
            repMod.addParentEdge(repEdge);
            _glyCo.addNode(endNode, repEdge, startNode);
        }
        return _glyCo;
    }
}

