/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util;

import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoExporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACShortExporter;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStyleDescriptor;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed.IUPACCondensedExporter;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended.IUPACExtendedExporter;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeExporter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph.GlyContainerToWURCSGraph;
import org.glycoinfo.GlycanFormatconverter.util.validator.IUPACValidator;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.util.validation.WURCSValidator;

public class ExporterEntrance {
    private final GlyContainer glyCo;

    public ExporterEntrance(GlyContainer _glyCo) {
        this.glyCo = _glyCo;
    }

    public String toIUPAC(IUPACStyleDescriptor _style) throws GlycanException, GlyCoExporterException, TrivialNameException {
        if (_style == null) {
            throw new GlyCoExporterException((Object)((Object)_style) + " is incorrect format.");
        }
        GlyContainer copyGlyco = this.glyCo.copy();
        IUPACValidator iupacVali = new IUPACValidator();
        iupacVali.validateGlycan(copyGlyco, _style);
        if (_style.equals((Object)IUPACStyleDescriptor.SHORT)) {
            IUPACShortExporter shortExpo = new IUPACShortExporter();
            shortExpo.start(copyGlyco);
            return shortExpo.getIUPACShort();
        }
        if (_style.equals((Object)IUPACStyleDescriptor.CONDENSED)) {
            IUPACCondensedExporter condExpo = new IUPACCondensedExporter(false);
            condExpo.start(copyGlyco);
            return condExpo.getIUPACCondensed();
        }
        if (_style.equals((Object)IUPACStyleDescriptor.EXTENDED)) {
            IUPACExtendedExporter extExpo = new IUPACExtendedExporter();
            extExpo.start(copyGlyco);
            return extExpo.getIUPACExtended();
        }
        if (_style.equals((Object)IUPACStyleDescriptor.GREEK)) {
            IUPACExtendedExporter extExpo = new IUPACExtendedExporter();
            extExpo.start(copyGlyco);
            return extExpo.toGreek();
        }
        if (_style.equals((Object)IUPACStyleDescriptor.GLYCANWEB)) {
            IUPACCondensedExporter condExpo = new IUPACCondensedExporter(true);
            condExpo.start(copyGlyco);
            return condExpo.getIUPACCondensed();
        }
        return "";
    }

    public String toLinearCode() throws GlyCoExporterException, ConverterExchangeException, GlycanException {
        LinearCodeExporter lcExpo = new LinearCodeExporter();
        lcExpo.start(this.glyCo);
        return lcExpo.getLinearCode();
    }

    public String toWURCS() throws GlycanException, WURCSException {
        GlyContainerToWURCSGraph gc2wg = new GlyContainerToWURCSGraph();
        gc2wg.start(this.glyCo);
        WURCSFactory wf = new WURCSFactory(gc2wg.getGraph());
        String wurcs = wf.getWURCS();
        WURCSValidator wv = new WURCSValidator();
        wv.start(wurcs);
        if (!wv.getReport().getErrors().isEmpty()) {
            StringBuilder message = new StringBuilder("");
            Iterator<String> iterError = wv.getReport().getErrors().iterator();
            while (iterError.hasNext()) {
                message.append(iterError.next());
                if (!iterError.hasNext()) continue;
                message.append("\n");
            }
            throw new WURCSFormatException(message.toString());
        }
        return wurcs;
    }
}

