/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;

public class GlyContainerOptimizer {
    public GlyContainer start(GlyContainer _glyCo) throws GlycanException {
        for (Node node : _glyCo.getAllNodes()) {
            this.optimizeDuplicateSubstituent((Monosaccharide)node);
            this.optimizeSubstituent((Monosaccharide)node);
            this.optimizeGlycoSidicLinkage((Monosaccharide)node);
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            this.optimizeUndefinedUnit(und);
        }
        return _glyCo;
    }

    public void optimizeMonosaccharide(Monosaccharide _mono) {
    }

    public void optimizeDuplicateSubstituent(Monosaccharide _mono) throws GlycanException {
        HashMap<Integer, ArrayList<Edge>> subMap = this.extractDupeSubstituents(_mono);
        for (Integer key : subMap.keySet()) {
            BaseSubstituentTemplate bsubT;
            ArrayList<Edge> edges = subMap.get(key);
            if (edges.size() < 2) continue;
            if (edges.size() > 2) {
                throw new GlycanException("This node have multiple substituents for same position.");
            }
            Substituent sub1 = (Substituent)edges.get(0).getSubstituent();
            Substituent sub2 = (Substituent)edges.get(1).getSubstituent();
            if (sub1.getSubstituent() == null) {
                throw new GlycanException("Substituent could not defined.");
            }
            if (sub2.getSubstituent() == null) {
                throw new GlycanException("Substituent could not defined.");
            }
            if (sub1.getSubstituent().equals(BaseSubstituentTemplate.AMINE)) {
                bsubT = this.convertOtoNsubstituent(sub2);
                sub2.setTemplate(bsubT);
                sub2.setHeadAtom("N");
                _mono.removeChildEdge(edges.get(0));
            }
            if (!sub2.getSubstituent().equals(BaseSubstituentTemplate.AMINE)) continue;
            bsubT = this.convertOtoNsubstituent(sub1);
            sub1.setTemplate(bsubT);
            sub2.setHeadAtom("N");
            _mono.removeChildEdge(edges.get(1));
        }
    }

    private HashMap<Integer, ArrayList<Edge>> extractDupeSubstituents(Node _node) {
        HashMap<Integer, ArrayList<Edge>> subMap = new HashMap<Integer, ArrayList<Edge>>();
        for (Edge childEdge : _node.getChildEdges()) {
            ArrayList<Object> subs;
            Substituent sub;
            if (childEdge.getSubstituent() == null || (sub = (Substituent)childEdge.getSubstituent()) instanceof GlycanRepeatModification || sub.getSubstituent() instanceof BaseCrossLinkedTemplate || sub.getFirstPosition().getParentLinkages().size() > 1 || Double.compare(sub.getFirstPosition().getParentProbabilityLower(), 1.0) != 0) continue;
            int position = sub.getFirstPosition().getParentLinkages().get(0);
            if (subMap.containsKey(position)) {
                subs = subMap.get(position);
                subs.add(childEdge);
                subMap.put(position, subs);
                continue;
            }
            subs = new ArrayList<Edge>();
            subs.add(childEdge);
            subMap.put(position, subs);
        }
        return subMap;
    }

    public void optimizeSubstituent(Monosaccharide _mono) throws GlycanException {
        for (Edge edge : _mono.getChildEdges()) {
            if (edge.getSubstituent() == null || edge.getChild() != null) continue;
            Substituent sub = (Substituent)edge.getSubstituent();
            this.optimizeSubstituentAtoms(sub);
            if (sub instanceof GlycanRepeatModification) continue;
            if (sub.getFirstPosition() != null && sub.getSecondPosition() == null) {
                Linkage lin = edge.getGlycosidicLinkages().get(0);
                lin.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                lin.setParentLinkageType(LinkageType.DEOXY);
                sub.getFirstPosition().setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                sub.getFirstPosition().setParentLinkageType(LinkageType.DEOXY);
                if (sub.getHeadAtom().equals("O")) {
                    lin.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                    lin.setParentLinkageType(LinkageType.H_AT_OH);
                    sub.getFirstPosition().setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                    sub.getFirstPosition().setParentLinkageType(LinkageType.H_AT_OH);
                }
                if (this.withH_LOSE(_mono, sub)) {
                    lin.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                    lin.setParentLinkageType(LinkageType.H_LOSE);
                    sub.getFirstPosition().setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                    sub.getFirstPosition().setParentLinkageType(LinkageType.H_LOSE);
                }
            }
            if (!this.isCrossLinkedSubstituent(edge)) continue;
            this.optimizeCrossLinkedSubstituent(edge, sub);
        }
    }

    public void optimizeSubstituentFragmentLinkageType(Substituent sub, Edge _coreSide) throws GlycanException {
        this.optimizeSubstituentAtoms(sub);
        if (sub.getFirstPosition() != null && sub.getSecondPosition() == null) {
            Linkage lin = _coreSide.getGlycosidicLinkages().get(0);
            lin.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
            lin.setParentLinkageType(LinkageType.DEOXY);
            sub.getFirstPosition().setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
            sub.getFirstPosition().setParentLinkageType(LinkageType.DEOXY);
            if (sub.getHeadAtom().equals("O")) {
                lin.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                lin.setParentLinkageType(LinkageType.H_AT_OH);
                sub.getFirstPosition().setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                sub.getFirstPosition().setParentLinkageType(LinkageType.H_AT_OH);
            }
        }
    }

    public void optimizeCrossLinkedSubstituent(Edge _edge, Substituent _sub) throws GlycanException {
        Linkage first = _sub.getFirstPosition();
        Linkage second = _sub.getSecondPosition();
        first.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
        second.setParentLinkageType(LinkageType.NONMONOSACCHARIDE);
        if (_edge.getChild() != null) {
            if (second.getChildLinkages().contains(1) || second.getChildLinkages().isEmpty()) {
                second.setChildLinkageType(LinkageType.H_AT_OH);
            } else {
                second.setChildLinkageType(LinkageType.DEOXY);
            }
            if (first.getChildLinkages().contains(1) || first.getChildLinkages().isEmpty()) {
                first.setParentLinkageType(LinkageType.H_AT_OH);
            } else {
                first.setParentLinkageType(LinkageType.DEOXY);
            }
            if (_sub.getSubstituent().equals(BaseCrossLinkedTemplate.PHOSPHOETHANOLAMINE)) {
                first.setParentLinkageType(LinkageType.H_AT_OH);
                second.setChildLinkageType(LinkageType.H_AT_OH);
            }
            if (_sub.getSubstituent().equals(BaseCrossLinkedTemplate.AMINO)) {
                first.setParentLinkageType(LinkageType.DEOXY);
                second.setChildLinkageType(LinkageType.DEOXY);
            }
        } else if (_sub.getSubstituent().equals(BaseCrossLinkedTemplate.AMINO)) {
            if (!_sub.getHeadAtom().equals("O")) {
                first.setParentLinkageType(LinkageType.DEOXY);
            } else {
                first.setParentLinkageType(LinkageType.H_AT_OH);
            }
            if (!_sub.getTailAtom().equals("O")) {
                second.setChildLinkageType(LinkageType.DEOXY);
            } else {
                second.setChildLinkageType(LinkageType.H_AT_OH);
            }
        } else {
            first.setParentLinkageType(LinkageType.H_AT_OH);
            second.setChildLinkageType(LinkageType.H_AT_OH);
        }
        for (Linkage lin : _edge.getGlycosidicLinkages()) {
            lin.setChildLinkageType(first.getParentLinkageType());
            lin.setParentLinkageType(second.getChildLinkageType());
        }
    }

    public void optimizeGlycoSidicLinkage(Monosaccharide _mono) throws GlycanException {
        for (Edge edge : _mono.getChildEdges()) {
            if (edge.getChild() == null) continue;
            Substituent sub = (Substituent)edge.getSubstituent();
            if (edge.getChild() != null && sub == null) {
                for (Linkage lin : edge.getGlycosidicLinkages()) {
                    lin.setChildLinkageType(LinkageType.DEOXY);
                    lin.setParentLinkageType(LinkageType.H_AT_OH);
                }
            }
            if (sub == null) continue;
            this.optimizeSubstituentAtoms(sub);
            if (this.isRepeating(edge)) {
                GlycanRepeatModification repMod = (GlycanRepeatModification)sub;
                for (Linkage lin : edge.getGlycosidicLinkages()) {
                    lin.setParentLinkageType(LinkageType.H_AT_OH);
                    if (repMod.getSubstituent() != null) {
                        lin.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
                        continue;
                    }
                    lin.setChildLinkageType(LinkageType.DEOXY);
                }
            }
            if (!this.isCrossLinkedSubstituent(edge)) continue;
            this.optimizeCrossLinkedSubstituent(edge, sub);
        }
    }

    public void optimizeUndefinedUnit(GlycanUndefinedUnit _und) throws GlycanException {
        Edge connect = _und.getConnection();
        Node root = _und.getRootNodes().get(0);
        if (connect != null) {
            if (root instanceof Monosaccharide) {
                for (Linkage lin : connect.getGlycosidicLinkages()) {
                    lin.setChildLinkageType(LinkageType.DEOXY);
                    lin.setParentLinkageType(LinkageType.H_AT_OH);
                }
            }
            if (root instanceof Substituent) {
                this.optimizeSubstituentFragmentLinkageType((Substituent)root, connect);
            }
        }
        for (Node node : _und.getRootNodes()) {
            if (!(node instanceof Monosaccharide)) continue;
            this.optimizeSubstituent((Monosaccharide)node);
            this.optimizeGlycoSidicLinkage((Monosaccharide)node);
        }
    }

    public void optimizeSubstituentAtoms(Substituent _sub) {
        SubstituentInterface subFace = _sub.getSubstituent();
        if (subFace == null) {
            return;
        }
        if (_sub.getHeadAtom() == null) {
            _sub.setHeadAtom("");
        }
        if (_sub.getTailAtom() == null) {
            _sub.setTailAtom("");
        }
        if (subFace instanceof BaseSubstituentTemplate) {
            BaseSubstituentTemplate baseSub = (BaseSubstituentTemplate)subFace;
            if (baseSub.getMAP().startsWith("*O")) {
                _sub.setHeadAtom("O");
            }
            if (baseSub.getMAP().startsWith("*N")) {
                _sub.setHeadAtom("N");
            }
            if (baseSub.equals(BaseSubstituentTemplate.CFORMYL) || baseSub.equals(BaseSubstituentTemplate.CMETHYL)) {
                _sub.setHeadAtom("C");
            }
        }
        if (subFace instanceof BaseCrossLinkedTemplate) {
            BaseCrossLinkedTemplate baseCross = (BaseCrossLinkedTemplate)subFace;
            if (baseCross.getMAP().startsWith("*O")) {
                _sub.setHeadAtom("O");
            }
            if (baseCross.getMAP().startsWith("*N")) {
                _sub.setHeadAtom("N");
            }
        }
    }

    public boolean withH_LOSE(Monosaccharide _mono, Substituent _sub) {
        if (_sub.getHeadAtom().equals("O")) {
            return false;
        }
        if (_sub.getHeadAtom().equals("C")) {
            return true;
        }
        Linkage lin = _sub.getFirstPosition();
        int pos = lin.getParentLinkages().get(0);
        boolean ret = false;
        for (GlyCoModification gMod : _mono.getModifications()) {
            boolean isHLOSE;
            boolean bl = isHLOSE = gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_5) || gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_6) || gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_7) || gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_8) || gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_X);
            if (gMod.getPositionOne() != pos || !isHLOSE) continue;
            ret = true;
        }
        return ret;
    }

    public boolean isCrossLinkedSubstituent(Edge _edge) {
        if (_edge.getSubstituent() == null) {
            return false;
        }
        Substituent sub = (Substituent)_edge.getSubstituent();
        if (sub.getSubstituent() == null) {
            return false;
        }
        if (sub.getSubstituent().equals(BaseCrossLinkedTemplate.ANHYDRO)) {
            return false;
        }
        return sub.getSubstituent() instanceof BaseCrossLinkedTemplate;
    }

    public boolean isRepeating(Edge _edge) {
        if (_edge.getSubstituent() == null) {
            return false;
        }
        Substituent sub = (Substituent)_edge.getSubstituent();
        return sub instanceof GlycanRepeatModification;
    }

    private void optimizeUnsaturation(Monosaccharide _mono) throws GlycanException {
        List list;
        HashMap modList = new HashMap();
        for (GlyCoModification gMod : _mono.getModifications()) {
            if (!modList.containsKey(gMod.getPositionOne())) {
                list = new ArrayList<GlyCoModification>();
                list.add(gMod);
                modList.put(gMod.getPositionOne(), list);
                continue;
            }
            ((List)modList.get(gMod.getPositionOne())).add(gMod);
        }
        for (Integer key : modList.keySet()) {
            GlyCoModification gMod;
            list = (List)modList.get(key);
            if (list.size() != 1) continue;
            if (((GlyCoModification)list.get(0)).getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_FL)) {
                _mono.removeModification((GlyCoModification)list.get(0));
                gMod = new GlyCoModification(ModificationTemplate.UNSATURATION_FU, (int)key);
                _mono.addModification(gMod);
            }
            if (((GlyCoModification)list.get(0)).getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_EL)) {
                _mono.removeModification((GlyCoModification)list.get(0));
                gMod = new GlyCoModification(ModificationTemplate.UNSATURATION_EU, (int)key);
                _mono.addModification(gMod);
            }
            if (!((GlyCoModification)list.get(0)).getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_ZL)) continue;
            _mono.removeModification((GlyCoModification)list.get(0));
            gMod = new GlyCoModification(ModificationTemplate.UNSATURATION_ZU, (int)key);
            _mono.addModification(gMod);
        }
    }

    private boolean hasUnsaturationWithDeoxy(List<GlyCoModification> _gModList) {
        boolean haveDeoxy = false;
        boolean haveUnsaturation = false;
        for (GlyCoModification gMod : _gModList) {
            if (gMod.getModificationTemplate().equals((Object)ModificationTemplate.DEOXY)) {
                haveDeoxy = true;
            }
            if (!gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_FU) && !gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_ZU) && !gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_EU)) continue;
            haveUnsaturation = true;
        }
        return haveDeoxy && haveUnsaturation;
    }

    private BaseSubstituentTemplate convertOtoNsubstituent(Substituent _sub) throws GlycanException {
        String oldNotation = _sub.getSubstituent().getIUPACnotation();
        if (_sub.getSubstituent().equals(BaseSubstituentTemplate.ACYL)) {
            throw new GlycanException("GlycanFormatConverter can not support N linked acyl group.");
        }
        if (_sub.getSubstituent().equals(BaseSubstituentTemplate.ETHANOL)) {
            return BaseSubstituentTemplate.ETHANOLAMINE;
        }
        if (_sub.getSubstituent().equals(BaseSubstituentTemplate.CMETHYL)) {
            return BaseSubstituentTemplate.NMETHYL;
        }
        return BaseSubstituentTemplate.forIUPACNotationWithIgnore("N" + oldNotation);
    }

    private void checkStatus(Node _node) {
        if (_node instanceof Monosaccharide) {
            Monosaccharide mono = (Monosaccharide)_node;
            for (Edge edge : mono.getChildEdges()) {
                Substituent sub = (Substituent)edge.getSubstituent();
                if (sub == null) continue;
                if (sub.getFirstPosition() != null) {
                    System.out.println(sub.getFirstPosition().getParentLinkages() + " " + sub.getFirstPosition().getChildLinkages() + " " + (Object)((Object)sub.getFirstPosition().getParentLinkageType()) + " " + (Object)((Object)sub.getFirstPosition().getChildLinkageType()));
                }
                if (sub.getSecondPosition() != null) {
                    System.out.println(sub.getSecondPosition().getParentLinkages() + " " + sub.getSecondPosition().getChildLinkages() + " " + (Object)((Object)sub.getSecondPosition().getParentLinkageType()) + " " + (Object)((Object)sub.getSecondPosition().getChildLinkageType()));
                }
                System.out.println(sub.getSubstituent());
                System.out.println("head atom : " + sub.getHeadAtom() + "/ tail atom : " + sub.getTailAtom());
            }
        }
    }
}

