/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.analyzer;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;

public class IUPACSubstituentNotationAnalyzer
extends SubstituentUtility {
    private ArrayList<Substituent> substituents;

    public ArrayList<Substituent> getSubstituents() {
        return this.substituents;
    }

    public void start(Monosaccharide _mono, ArrayList<String> _substituents) throws GlycanException {
        this.makeSubstituent(_mono, _substituents);
    }

    public void start(String _substituent) throws GlycanException {
        ArrayList<String> temp = this.resolveSubstituents(_substituent, true);
        this.makeSubstituent(null, temp);
    }

    public ArrayList<String> resolveSubstituents(String _notations, boolean _isSubstituent) {
        String notation = "";
        ArrayList<String> subs = new ArrayList<String>();
        ArrayList<String> mods = new ArrayList<String>();
        boolean isLink = false;
        boolean isNotation = false;
        for (int i = 0; i < _notations.length(); ++i) {
            char unit = _notations.charAt(i);
            if (this.isInteger(unit)) {
                isLink = true;
            }
            if (this.isAlphabet(unit)) {
                isNotation = true;
            }
            if ((notation = notation + unit).contains("en") || notation.equals("??")) {
                mods.add(notation);
                notation = "";
                isNotation = false;
                isLink = false;
                continue;
            }
            if (i == _notations.length() - 1) {
                subs.add(notation);
                break;
            }
            if (isLink && isNotation && this.isInteger(_notations.charAt(i + 1))) {
                if (notation.split(",").length == 1) {
                    subs.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                    continue;
                }
                if (notation.split(",").length == this.toInteger(unit)) {
                    subs.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                    continue;
                }
                if (this.isCyclic(notation) && this.isAlphabet(unit)) {
                    subs.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                    continue;
                }
            }
            if (isLink || !isNotation || !this.isInteger(_notations.charAt(i + 1))) continue;
            subs.add(notation);
            notation = "";
            isNotation = false;
            isLink = false;
        }
        return _isSubstituent ? subs : mods;
    }

    private void makeSubstituent(Monosaccharide _mono, ArrayList<String> _substituents) throws GlycanException {
        this.substituents = new ArrayList();
        String regex = "([\\d?:/,(%)-]+(?![RSX]\\)))?([(a-zA-Z?\\-)]+)+(\\d)?([\\d?])?";
        for (String unit : _substituents) {
            Enum subT;
            int number;
            Matcher matSub = Pattern.compile(regex).matcher(unit);
            if (!matSub.find()) continue;
            String positions = matSub.group(1);
            String notation = matSub.group(2);
            int n = number = matSub.group(3) != null ? Integer.parseInt(matSub.group(3)) : 1;
            if (positions == null) {
                String planeNotation = this.makePlaneNotation(notation);
                subT = BaseSubstituentTemplate.forIUPACNotation(planeNotation);
                BaseStereoIndex bsi = null;
                if (!_mono.getStereos().isEmpty()) {
                    bsi = BaseStereoIndex.forCode(_mono.getStereos().getFirst());
                    if (bsi != null && bsi.getSize() == 6) {
                        positions = "2";
                    }
                    if (bsi != null && bsi.getSize() != 6 && _mono.getSuperClass().equals((Object)SuperClass.HEX)) {
                        bsi = null;
                    }
                }
                if (bsi == null && _mono.getSuperClass().equals((Object)SuperClass.HEX)) {
                    positions = "2";
                }
                Linkage firstLink = this.makeLinkage(positions, "1", 1.0, 1.0);
                Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink);
                sub.setHeadAtom(this.makeHeadAtomFromNotation(notation, planeNotation));
                this.substituents.add(sub);
                continue;
            }
            for (String position : positions.split(":")) {
                String[] probs;
                Linkage firstLink;
                String planeNotation;
                if (positions.contains(":") && position.contains(",") || position.contains(",") && number == 1) {
                    planeNotation = this.makePlaneNotation(notation);
                    subT = BaseCrossLinkedTemplate.forIUPACNotation(planeNotation);
                    this.checkSupportSubstituent((SubstituentInterface)((Object)subT));
                    String[] pos = position.split(",");
                    String[] firstPos = this.extractPos(pos[0]);
                    String[] secondPos = this.extractPos(pos[1]);
                    String[] firstProb = this.trimProbability(pos[0]);
                    String[] secondProb = this.trimProbability(pos[1]);
                    firstLink = this.makeLinkage(firstPos[0], firstPos[1], this.extractProbability(firstProb[0]), this.extractProbability(firstProb[1]));
                    Linkage secondLink = this.makeLinkage(secondPos[0], secondPos[1], this.extractProbability(secondProb[0]), this.extractProbability(secondProb[1]));
                    Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink, secondLink);
                    sub.setHeadAtom(this.makeHeadAtomFromNotation(notation, planeNotation));
                    this.isDeoxySubstituentWithHLose(_mono, sub, this.makeHeadAtomFromNotation(notation, planeNotation));
                    this.substituents.add(sub);
                    continue;
                }
                if (position.contains("/")) {
                    planeNotation = this.makePlaneNotation(notation);
                    subT = BaseSubstituentTemplate.forIUPACNotation(planeNotation);
                    probs = this.trimProbability(position);
                    String pos = this.extractPos(position)[0];
                    Linkage firstLink2 = this.makeLinkage(pos, "1", this.extractProbability(probs[0]), this.extractProbability(probs[1]));
                    Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink2);
                    sub.setHeadAtom(this.makeHeadAtomFromNotation(notation, planeNotation));
                    this.isDeoxySubstituentWithHLose(_mono, sub, this.makeHeadAtomFromNotation(notation, planeNotation));
                    this.substituents.add(sub);
                    continue;
                }
                for (String multi : position.split(",")) {
                    String planeNotation2 = this.makePlaneNotation(notation);
                    subT = BaseSubstituentTemplate.forIUPACNotation(planeNotation2);
                    probs = this.trimProbability(multi);
                    String pos = this.extractPos(multi)[0];
                    firstLink = this.makeLinkage(matSub.group(1).equals("?") ? "-1" : pos, "1", this.extractProbability(probs[0]), this.extractProbability(probs[1]));
                    Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink);
                    sub.setHeadAtom(this.makeHeadAtomFromNotation(notation, planeNotation2));
                    this.modifyHeadAtom(_mono, sub, pos);
                    this.isDeoxySubstituentWithHLose(_mono, sub, this.makeHeadAtomFromNotation(notation, planeNotation2));
                    this.substituents.add(sub);
                }
            }
        }
    }

    private Linkage makeLinkage(String _parentPos, String _childPos, double _probabilityLow, double _probabilityHigh) {
        Linkage ret = new Linkage();
        ret.setProbabilityLower(_probabilityLow == 1.0 ? 1.0 : (_probabilityLow == -1.0 ? -1.0 : _probabilityLow * 0.01));
        ret.setProbabilityUpper(_probabilityHigh == 1.0 ? 1.0 : (_probabilityHigh == -1.0 ? -1.0 : _probabilityHigh * 0.01));
        ret.addChildLinkage(Integer.parseInt(_childPos));
        for (String parentPos : _parentPos.split("/")) {
            ret.addParentLinkage(Integer.parseInt(parentPos.equals("?") ? "-1" : parentPos));
        }
        return ret;
    }

    private double extractProbability(String _pribability) {
        double ret = 1.0;
        if (_pribability == null) {
            return ret;
        }
        ret = (_pribability = _pribability.replace("%", "")).equals("?") ? -1.0 : Double.parseDouble(_pribability.replace("%", ""));
        return ret;
    }

    private String[] trimProbability(String _linkagepos) {
        String[] ret = new String[]{"1.0D", "1.0D"};
        if (!_linkagepos.contains("(")) {
            return ret;
        }
        String probability = _linkagepos.substring(_linkagepos.indexOf("(") + 1, _linkagepos.indexOf(")"));
        for (String unit : probability.split(",")) {
            if (ret[0] != null) {
                ret[1] = unit.replace("%", "");
            }
            ret[0] = unit.replace("%", "");
        }
        if (ret[1] == null) {
            ret[1] = ret[0];
        }
        return ret;
    }

    private String[] extractPos(String _position) {
        String[] ret = new String[2];
        if (_position == null) {
            return null;
        }
        if (_position.contains("(")) {
            _position = _position.substring(0, _position.indexOf("("));
        }
        if (_position.contains("-")) {
            ret = _position.split("-");
        } else {
            ret[0] = _position;
            ret[1] = "1";
        }
        return ret;
    }

    private String makeHeadAtomFromNotation(String _notation, String _planeNotaiton) {
        if (_notation.equals("N") && _planeNotaiton.equals("N")) {
            return _planeNotaiton;
        }
        if (_notation.startsWith("(")) {
            String bracket = _notation.substring(0, _notation.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            _notation = _notation.replaceFirst(regex, "");
            _planeNotaiton = _planeNotaiton.replaceFirst(regex, "");
        }
        String ret = _notation.replaceFirst(_planeNotaiton, "");
        return ret;
    }

    private void modifyHeadAtom(Monosaccharide _mono, Substituent _sub, String _position) {
        if (_position.equals("?") || _position.equals("")) {
            return;
        }
        if (_mono == null) {
            return;
        }
        for (GlyCoModification gMod : _mono.getModifications()) {
            if (gMod.getPositionOne() != Integer.parseInt(_position) || !this.isHLOSE(gMod)) continue;
            _sub.setHeadAtom("C");
        }
    }

    private String makePlaneNotation(String _notation) throws GlycanException {
        if (_notation.equals("N") || _notation.matches("C(l|Fo|Me)")) {
            return _notation;
        }
        if (_notation.startsWith("C")) {
            return _notation.substring(1);
        }
        if (_notation.startsWith("(")) {
            String bracket = _notation.substring(0, _notation.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            if ((_notation = _notation.replaceFirst(regex, "")).equals("CE")) {
                return bracket + _notation;
            }
            if (_notation.startsWith("C")) {
                throw new GlycanException("IUPAC importer can not support " + _notation);
            }
            return bracket + _notation;
        }
        return _notation;
    }

    private boolean isInteger(char _int) {
        return String.valueOf(_int).matches("\\d|\\?");
    }

    private boolean isAlphabet(char _alphabet) {
        return String.valueOf(_alphabet).matches("[A-Za-z]");
    }

    private Integer toInteger(char _unit) {
        if (!String.valueOf(_unit).matches("\\d")) {
            return -1;
        }
        return Integer.parseInt(String.valueOf(_unit));
    }

    private boolean isCyclic(String _notation) {
        return _notation.matches("([\\d?]-[\\d?]),([\\d?]-[\\d?]).+");
    }

    private void checkSupportSubstituent(SubstituentInterface _subInter) throws GlycanException {
        if (_subInter instanceof BaseSubstituentTemplate) {
            return;
        }
        if (_subInter.equals(BaseCrossLinkedTemplate.X_PYRUVATE) || _subInter.equals(BaseCrossLinkedTemplate.R_PYRUVATE) || _subInter.equals(BaseCrossLinkedTemplate.S_PYRUVATE) || _subInter.equals(BaseCrossLinkedTemplate.X_DEOXYPYRUVATE) || _subInter.equals(BaseCrossLinkedTemplate.R_DEOXYPYRUVATE) || _subInter.equals(BaseCrossLinkedTemplate.S_DEOXYPYRUVATE)) {
            throw new GlycanException("IUPAC importer can not support " + _subInter);
        }
    }

    private void isDeoxySubstituentWithHLose(Monosaccharide _mono, Substituent _sub, String _headAtom) throws GlycanException {
        SubstituentInterface subInter = _sub.getSubstituent();
        boolean ret = false;
        if (_headAtom.equals("N")) {
            return;
        }
        if (_headAtom.equals("") && !subInter.equals(BaseSubstituentTemplate.CFORMYL) && !subInter.equals(BaseSubstituentTemplate.CMETHYL)) {
            return;
        }
        for (GlyCoModification gMod : _mono.getModifications()) {
            if (this.isHLOSE(gMod)) continue;
            ret = true;
            break;
        }
        if (_mono.getModifications().isEmpty()) {
            throw new GlycanException("The (C)-type linkage of substituent requires some kind of H_LOSE modification at linkage position.");
        }
        if (ret) {
            throw new GlycanException("The (C)-type linkage of substituent requires some kind of H_LOSE modification at linkage position.");
        }
    }

    private boolean isHLOSE(GlyCoModification _gMod) {
        return _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_5) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_6) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_7) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_8) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_X);
    }
}

