/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph;

import java.util.ArrayList;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph.SubstituentToModification;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSExchangeException;
import org.glycoinfo.WURCSFramework.wurcs.graph.DirectionDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class EdgeToWURCSEdge {
    private Edge parentEdge;
    private Edge childEdge;
    private Monosaccharide parent;
    private Monosaccharide child;
    private Substituent sub;
    private LinkedList<WURCSEdge> parentEdges = new LinkedList();
    private LinkedList<WURCSEdge> childEdges = new LinkedList();
    private Modification mod;
    private int parentSidePos = 0;
    private int childSidePos = 0;
    private double probabilityLow = 1.0;
    private double probabilityUpper = 1.0;

    public void setLinkage(Edge _edge) {
        this.parentEdge = _edge;
        this.childEdge = _edge;
    }

    public Monosaccharide getParent() {
        return this.parent;
    }

    public Monosaccharide getChild() {
        return this.child;
    }

    public Substituent getSubstituent() {
        return this.sub;
    }

    public LinkedList<WURCSEdge> getParentEdges() {
        return this.parentEdges;
    }

    public LinkedList<WURCSEdge> getChildEdges() {
        return this.childEdges;
    }

    public Modification getModification() {
        return this.mod;
    }

    public void start(Edge _edge) throws WURCSException {
        this.setLinkage(_edge);
        this.setParent(_edge);
        this.setChild(_edge);
        if (this.isRingModification(_edge)) {
            return;
        }
        this.makeModification();
        this.setWURCSEdge(true);
        if (this.child == null) {
            return;
        }
        this.init();
        this.setWURCSEdge(false);
    }

    protected void setWURCSEdge(boolean _isParent) throws WURCSException {
        if (_isParent) {
            this.parentEdges = this.makeWURCSEdges(this.parentEdge, true);
        } else {
            this.childEdges = this.makeWURCSEdges(this.childEdge, false);
        }
    }

    protected LinkedList<WURCSEdge> makeWURCSEdges(Edge _edge, boolean _isParent) throws WURCSException {
        LinkedList<WURCSEdge> wedges = new LinkedList<WURCSEdge>();
        Linkage parentLinkage = _edge.getGlycosidicLinkages().get(0);
        if (_isParent) {
            if (this.probabilityLow == 1.0) {
                this.probabilityLow = parentLinkage.getParentProbabilityLower();
            }
            if (this.probabilityUpper == 1.0) {
                this.probabilityUpper = parentLinkage.getParentProbabilityUpper();
            }
        }
        if (_edge.getGlycosidicLinkages().size() == 1) {
            int mapPos = _isParent ? this.parentSidePos : this.childSidePos;
            ArrayList<Integer> positions = _isParent ? parentLinkage.getParentLinkages() : parentLinkage.getChildLinkages();
            WURCSEdge wedge = this.makeWURCSEdge(positions, mapPos);
            wedges.add(wedge);
            return wedges;
        }
        ArrayList<Integer> parentPositions = _edge.getGlycosidicLinkages().get(0).getParentLinkages();
        ArrayList<Integer> childPositions = _edge.getGlycosidicLinkages().get(1).getParentLinkages();
        WURCSEdge parentWEdge = this.makeWURCSEdge(parentPositions, this.parentSidePos);
        WURCSEdge childWEdge = this.makeWURCSEdge(childPositions, this.childSidePos);
        wedges.add(parentWEdge);
        wedges.add(childWEdge);
        return wedges;
    }

    protected WURCSEdge makeWURCSEdge(ArrayList<Integer> _positions, int _mapPosition) throws WURCSException {
        WURCSEdge wedge = new WURCSEdge();
        for (Integer pos : _positions) {
            LinkagePosition linkPos = new LinkagePosition(pos, DirectionDescriptor.L, _mapPosition);
            if (_mapPosition != 0) {
                linkPos = new LinkagePosition(pos, DirectionDescriptor.N, false, _mapPosition, false);
            }
            if (this.probabilityLow != 1.0) {
                linkPos.setProbabilityLower(this.probabilityLow);
            }
            if (this.probabilityUpper != 1.0) {
                linkPos.setProbabilityUpper(this.probabilityUpper);
            }
            if (this.probabilityUpper != 1.0 || this.probabilityLow != 1.0) {
                linkPos.setProbabilityPosition(2);
            } else {
                linkPos.setProbabilityPosition(1);
            }
            wedge.addLinkage(linkPos);
        }
        return wedge;
    }

    protected void setParent(Edge _edge) {
        Node parent = _edge.getParent();
        this.parentEdge = _edge;
        if (parent instanceof Monosaccharide) {
            this.parent = (Monosaccharide)parent;
        }
    }

    protected void setChild(Edge _edge) {
        Node child = _edge.getChild();
        Node substituent = _edge.getSubstituent();
        this.childEdge = _edge;
        if (child != null) {
            this.child = (Monosaccharide)child;
        }
        if (substituent == null) {
            return;
        }
        if (!(substituent instanceof Substituent)) {
            return;
        }
        this.sub = (Substituent)_edge.getSubstituent();
    }

    protected void makeModification() throws WURCSExchangeException {
        Modification mod = new Modification("");
        if (this.sub != null) {
            SubstituentToModification subst2mod = new SubstituentToModification();
            if (!(this.sub instanceof GlycanRepeatModification) && !(this.sub.getSubstituent() instanceof BaseCrossLinkedTemplate)) {
                this.probabilityLow = this.sub.getFirstPosition().getParentProbabilityLower();
                this.probabilityUpper = this.sub.getFirstPosition().getParentProbabilityUpper();
            }
            subst2mod.setParentEdge(this.parentEdge);
            subst2mod.start(this.sub);
            String map = subst2mod.getMAPCode();
            mod = new Modification(map);
            this.parentSidePos = subst2mod.getParentSidePosition();
            this.childSidePos = subst2mod.getChildSidePosition();
        }
        this.mod = mod;
    }

    private boolean isRingModification(Edge _edge) {
        if (_edge.getSubstituent() == null) {
            return false;
        }
        Substituent sub = (Substituent)_edge.getSubstituent();
        if (sub instanceof GlycanRepeatModification) {
            return false;
        }
        if (sub.getSubstituent() instanceof BaseSubstituentTemplate) {
            return false;
        }
        Monosaccharide acceptor = (Monosaccharide)_edge.getParent();
        if (acceptor.getRingStart() == -1 || acceptor.getRingEnd() == -1) {
            return false;
        }
        return sub.getFirstPosition().getParentLinkages().contains(acceptor.getRingStart()) && sub.getSecondPosition().getParentLinkages().contains(acceptor.getRingEnd());
    }

    private void init() {
        this.probabilityLow = 1.0;
        this.probabilityUpper = 1.0;
    }
}

