/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;

public class GlyContainerEdgeAnalyzer {
    private GlyContainer glyCo;

    public GlyContainerEdgeAnalyzer(GlyContainer _glyCo) {
        this.glyCo = _glyCo;
    }

    public void start(HashMap<WURCSComponent, Node> _backbone2Node, Backbone _root) throws GlycanException {
        Backbone root = _root;
        LinkedList<Backbone> subRoots = new LinkedList<Backbone>();
        for (WURCSComponent wc : _backbone2Node.keySet()) {
            Backbone bb = (Backbone)wc;
            if (root.equals(bb) || !bb.isRoot() || !_backbone2Node.get(bb).getParentEdges().isEmpty()) continue;
            if (this.countMonosaccharideChildren(_backbone2Node.get(bb)) > 1) {
                subRoots.addFirst(bb);
                continue;
            }
            subRoots.addLast(bb);
        }
        if (subRoots.isEmpty()) {
            return;
        }
        for (Backbone subRoot : subRoots) {
            for (Edge edge : this.extractSubGraph(_backbone2Node.get(subRoot), new ArrayList<Edge>())) {
                Edge reverseEdge = this.makeReverseEdge(edge);
                this.glyCo.addNode(edge.getChild(), reverseEdge, edge.getParent());
                if (edge.getChild().getParentEdges().contains(edge)) {
                    edge.getChild().removeParentEdge(edge);
                }
                if (!edge.getParent().getChildEdges().contains(edge)) continue;
                edge.getParent().removeChildEdge(edge);
            }
        }
    }

    private ArrayList<Edge> extractSubGraph(Node _node, ArrayList<Edge> _picked) {
        if (_node.getChildEdges().isEmpty() && _node.getParentEdges().size() > 1) {
            return _picked;
        }
        for (Edge childEdge : _node.getChildEdges()) {
            if (childEdge.getChild() == null && childEdge.getSubstituent() != null) continue;
            if (!_picked.contains(childEdge)) {
                _picked.add(childEdge);
            }
            _picked = this.extractSubGraph(childEdge.getChild(), _picked);
        }
        return _picked;
    }

    private Edge makeReverseEdge(Edge _edge) throws GlycanException {
        Edge ret = new Edge();
        Substituent sub = (Substituent)_edge.getSubstituent();
        ret.setSubstituent(sub);
        Linkage flipedLinkage = new Linkage();
        for (Linkage lin : _edge.getGlycosidicLinkages()) {
            flipedLinkage.setChildLinkages(lin.getParentLinkages());
            flipedLinkage.setParentLinkages(lin.getChildLinkages());
            flipedLinkage.setChildProbabilityUpper(lin.getParentProbabilityUpper());
            flipedLinkage.setChildProbabilityLower(lin.getParentProbabilityLower());
            flipedLinkage.setProbabilityUpper(lin.getChildProbabilityUpper());
            flipedLinkage.setProbabilityLower(lin.getChildProbabilityLower());
            flipedLinkage.setChildLinkageType(lin.getParentLinkageType());
            flipedLinkage.setParentLinkageType(lin.getChildLinkageType());
        }
        ret.addGlycosidicLinkage(flipedLinkage);
        return ret;
    }

    private int countMonosaccharideChildren(Node _node) {
        int ret = 0;
        for (Edge edge : _node.getChildEdges()) {
            if (edge.getSubstituent() != null && edge.getChild() == null) continue;
            ++ret;
        }
        return ret;
    }
}

