/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph.MonosaccharideAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph.SubstituentToModification;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSExchangeException;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;

public class MonosaccharideToBackbone {
    private Backbone m_oBackbone;
    private int m_iAnomericPosition = 0;
    private char m_cAnomericSymbol = (char)120;
    private char m_cConfigurationalSymbol = (char)88;
    private Monosaccharide m_oMonosaccharide;
    private boolean m_bRootOfSubgraph = false;
    private LinkedList<Modification> m_aUnknownPosCoreMod = new LinkedList();

    public Monosaccharide getMonosaccaride() {
        return this.m_oMonosaccharide;
    }

    public Backbone getBackbone() {
        return this.m_oBackbone;
    }

    public LinkedList<Modification> getCoreModification() {
        return this.m_aUnknownPosCoreMod;
    }

    public void setRootOfSubgraph() {
        this.m_bRootOfSubgraph = true;
    }

    private boolean hasParent() {
        if (this.m_bRootOfSubgraph) {
            return true;
        }
        if (this.m_oMonosaccharide.getParentNode() != null) {
            return true;
        }
        for (GlycoEdge t_objChildEdge : this.m_oMonosaccharide.getChildEdges()) {
            for (Linkage t_objLink : t_objChildEdge.getGlycosidicLinkages()) {
                for (Integer t_iLinkPos : t_objLink.getParentLinkages()) {
                    int t_iRingStart = this.m_oMonosaccharide.getRingStart();
                    if (t_iRingStart == -1 || t_iLinkPos != t_iRingStart) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void start(Monosaccharide a_oMonosaccharide) throws WURCSExchangeException {
        int t_nCAtom;
        this.m_oMonosaccharide = a_oMonosaccharide;
        this.m_iAnomericPosition = a_oMonosaccharide.getRingStart();
        this.m_cAnomericSymbol = a_oMonosaccharide.getAnomer().getSymbol().charAt(0);
        if (this.m_iAnomericPosition == 0) {
            this.m_cAnomericSymbol = (char)111;
        }
        if ((t_nCAtom = a_oMonosaccharide.getSuperclass().getCAtomCount()) == 0) {
            this.m_oBackbone = new Backbone();
            this.m_oBackbone.setAnomericSymbol(this.m_cAnomericSymbol);
            BackboneCarbon bc = new BackboneCarbon(this.m_oBackbone, CarbonDescriptor.SSX_UNDEF_ALL, true);
            this.m_oBackbone.addBackboneCarbon(bc);
            return;
        }
        MonosaccharideAnalyzer t_oMSAnal = new MonosaccharideAnalyzer();
        t_oMSAnal.analyze(a_oMonosaccharide);
        this.m_iAnomericPosition = t_oMSAnal.getAnomericPosition();
        this.m_cAnomericSymbol = t_oMSAnal.getAnomericSymbol();
        this.m_cConfigurationalSymbol = t_oMSAnal.getConfigurationalSymbol();
        String t_strSkeletonCode = t_oMSAnal.getSkeletonCode();
        for (String string : t_oMSAnal.getCoreModificationUnknownPosition()) {
            this.m_aUnknownPosCoreMod.add(new Modification(string));
        }
        if (this.m_iAnomericPosition == -1) {
            if (t_strSkeletonCode.contains("o")) {
                this.m_iAnomericPosition = t_strSkeletonCode.indexOf("o") + 1;
                t_strSkeletonCode = t_strSkeletonCode.replaceFirst("o", "a");
            } else if (t_strSkeletonCode.contains("O")) {
                this.m_iAnomericPosition = t_strSkeletonCode.indexOf("O") + 1;
                t_strSkeletonCode = t_strSkeletonCode.replaceFirst("O", "a");
            }
        }
        StringBuilder t_sbSkeletonCode = new StringBuilder(t_strSkeletonCode);
        if (a_oMonosaccharide.getParentEdge() != null) {
            this.replaceCarbonDescriptorByEdge(t_sbSkeletonCode, a_oMonosaccharide.getParentEdge(), true);
        }
        for (GlycoEdge t_oChildEdge : a_oMonosaccharide.getChildEdges()) {
            this.replaceCarbonDescriptorByEdge(t_sbSkeletonCode, t_oChildEdge, false);
        }
        Backbone backbone = new Backbone();
        backbone.setAnomericPosition(this.m_iAnomericPosition);
        backbone.setAnomericSymbol(this.m_cAnomericSymbol);
        for (int i = 0; i < t_nCAtom; ++i) {
            char t_cCD = t_sbSkeletonCode.charAt(i);
            CarbonDescriptor t_enumCD = CarbonDescriptor.forCharacter(t_cCD, i == 0 || i == t_nCAtom - 1);
            BackboneCarbon t_oBC = new BackboneCarbon(backbone, t_enumCD);
            backbone.addBackboneCarbon(t_oBC);
        }
        this.m_oBackbone = backbone;
    }

    private void replaceCarbonDescriptorByEdge(StringBuilder a_sbSC, GlycoEdge a_oEdge, boolean a_bIsParentSideEdge) throws WURCSExchangeException {
        char t_cAnomStereo;
        GlycoNode t_oNode = a_bIsParentSideEdge ? a_oEdge.getParent() : a_oEdge.getChild();
        Substituent t_oSubst = t_oNode instanceof Substituent ? (Substituent)t_oNode : null;
        boolean t_bSwapChirality = false;
        for (Linkage t_oLink : a_oEdge.getGlycosidicLinkages()) {
            LinkageType t_oType1;
            char t_cCD;
            int t_iPos;
            ArrayList<Integer> t_aPositions = a_bIsParentSideEdge ? t_oLink.getChildLinkages() : t_oLink.getParentLinkages();
            if (t_aPositions.size() > 1) continue;
            t_bSwapChirality = this.compareConnectAtom(t_oLink, t_oSubst, a_bIsParentSideEdge) < 0;
            Linkage t_oParentLink = t_oLink;
            if (a_oEdge.getParent() instanceof SugarUnitRepeat) {
                t_oParentLink = ((SugarUnitRepeat)a_oEdge.getParent()).getRepeatLinkage().getGlycosidicLinkages().get(0);
            }
            if ((t_iPos = t_aPositions.get(0).intValue()) == -1) continue;
            char t_cNewCD = t_cCD = a_sbSC.charAt(t_iPos - 1);
            LinkageType t_oType0 = a_bIsParentSideEdge ? t_oLink.getChildLinkageType() : t_oParentLink.getParentLinkageType();
            LinkageType linkageType = t_oType1 = a_bIsParentSideEdge ? t_oParentLink.getParentLinkageType() : t_oLink.getChildLinkageType();
            if (t_oType0 == LinkageType.H_LOSE) {
                t_cNewCD = this.replaceCarbonDescriptorByHydrogenLose(t_cCD, t_bSwapChirality);
            } else if (t_oType0 == LinkageType.DEOXY && t_oType1 != LinkageType.H_AT_OH) {
                t_cNewCD = t_cCD == 'c' ? (char)'x' : (t_cCD == 'C' ? (char)'X' : t_cNewCD);
            }
            a_sbSC.replace(t_iPos - 1, t_iPos, t_cNewCD + "");
        }
        if (!a_bIsParentSideEdge) {
            return;
        }
        if (this.m_iAnomericPosition == 0 || this.m_iAnomericPosition == -1) {
            return;
        }
        if (this.m_cAnomericSymbol != 'a' && this.m_cAnomericSymbol != 'b') {
            return;
        }
        char t_cAnomCD = a_sbSC.charAt(this.m_iAnomericPosition - 1);
        if (t_cAnomCD != 'x' && t_cAnomCD != 'X') {
            return;
        }
        char c = t_cAnomStereo = this.m_cAnomericSymbol == 'a' ? (char)'1' : '2';
        if (this.m_cConfigurationalSymbol == 'L') {
            char c2 = t_cAnomStereo = t_cAnomStereo == '1' ? (char)'2' : '1';
        }
        if (t_bSwapChirality) {
            char c3 = t_cAnomStereo = t_cAnomStereo == '1' ? (char)'2' : '1';
        }
        if (t_cAnomCD == 'X') {
            t_cAnomStereo = t_cAnomStereo == '1' ? (char)'5' : '6';
        }
        a_sbSC.replace(this.m_iAnomericPosition - 1, this.m_iAnomericPosition, t_cAnomStereo + "");
    }

    private char replaceCarbonDescriptorByLinkageType(char a_cCD, LinkageType a_oType0, LinkageType a_oType1) {
        int t_cNewCD = a_cCD;
        if (a_oType0 == LinkageType.DEOXY && a_oType1 != LinkageType.H_AT_OH) {
            int n = a_cCD == 99 ? 120 : (t_cNewCD = a_cCD == 67 ? 88 : t_cNewCD);
        }
        if (a_oType0 == LinkageType.H_LOSE) {
            t_cNewCD = a_cCD == 49 ? 53 : (a_cCD == 50 ? 54 : (a_cCD == 51 ? 55 : (a_cCD == 52 ? 56 : (a_cCD == 120 ? 88 : (a_cCD == 99 ? 67 : (a_cCD == 109 ? 104 : (a_cCD == 104 ? 99 : t_cNewCD)))))));
        }
        return (char)t_cNewCD;
    }

    private char replaceCarbonDescriptorByHydrogenLose(char a_cCD, boolean a_bSwapChirality) {
        int t_cNewCD;
        int n = a_cCD == '1' ? 53 : (a_cCD == '2' ? 54 : (a_cCD == '3' ? 55 : (a_cCD == '4' ? 56 : (a_cCD == 'x' ? 88 : (a_cCD == 'c' ? 67 : (a_cCD == 'm' ? 104 : (t_cNewCD = a_cCD == 'h' ? 99 : (int)a_cCD)))))));
        if (a_bSwapChirality) {
            t_cNewCD = t_cNewCD == 53 ? 54 : (t_cNewCD == 54 ? 53 : (t_cNewCD == 55 ? 56 : (t_cNewCD == 56 ? 55 : t_cNewCD)));
        }
        return (char)t_cNewCD;
    }

    private int compareConnectAtom(Linkage a_oLink, Substituent a_oSubst, boolean a_bIsParentSide) throws WURCSExchangeException {
        LinkageType t_oChildType;
        LinkageType t_oParentType = a_bIsParentSide ? a_oLink.getChildLinkageType() : a_oLink.getParentLinkageType();
        LinkageType linkageType = t_oChildType = a_bIsParentSide ? a_oLink.getParentLinkageType() : a_oLink.getChildLinkageType();
        if (t_oParentType == LinkageType.H_AT_OH || t_oChildType == LinkageType.H_AT_OH) {
            return 0;
        }
        if (a_oSubst == null) {
            return 0;
        }
        return this.compareConnectAtomOfSubstituent(a_oSubst, a_bIsParentSide);
    }

    private int compareConnectAtomOfSubstituent(Substituent a_oSubst, boolean a_bSubstituentIsParent) throws WURCSExchangeException {
        SubstituentToModification t_oSubstToMod = new SubstituentToModification();
        t_oSubstToMod.start(a_oSubst);
        String t_strConnAtom = a_bSubstituentIsParent ? t_oSubstToMod.getTailAtom() : t_oSubstToMod.getHeadAtom();
        int t_iNumberOfFirstAtom = AtomicProperties.forSymbol(t_strConnAtom).getAtomicNumber();
        int t_iComp = 16 - AtomicProperties.forSymbol(t_strConnAtom).getAtomicNumber();
        if (t_iNumberOfFirstAtom < 16) {
            return 1;
        }
        return -1;
    }
}

