/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.validator.importer;

import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;

public class IUPACExtendedImporterValidator {
    public void validateExtended(GlyContainer _glyCo) throws GlyCoImporterException {
        for (Node node : _glyCo.getAllNodes()) {
            this.checkKetal(node);
        }
    }

    public void checkKetal(Node _node) throws GlyCoImporterException {
        Monosaccharide mono = (Monosaccharide)_node;
        int count = 0;
        if (mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
            ++count;
        }
        if (mono.getRingStart() == -1 && mono.getRingEnd() == -1) {
            ++count;
        }
        if (mono.getAnomericPosition() == 0) {
            ++count;
        }
        for (GlyCoModification gMod : mono.getModifications()) {
            if (gMod.getPositionOne() != 2 || !gMod.getModificationTemplate().equals((Object)ModificationTemplate.KETONE_U)) continue;
            ++count;
        }
        if (count == 4) {
            throw new GlyCoImporterException("IUPAC-Extended format can not handle ketose with open chain or unknown anomeric state.");
        }
    }
}

