/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.exchange;

import java.util.Iterator;
import java.util.TreeMap;
import org.glycoinfo.WURCSFramework.util.WURCSDataConverter;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.exchange.MSArrayToSequence;
import org.glycoinfo.WURCSFramework.util.subsumption.MSStateDeterminationUtility;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GLIN;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GRES;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.MSPERI;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.WURCSSequence2;

public class WURCSArrayToSequence2 {
    private WURCSSequence2 m_oSequence;
    private TreeMap<Integer, UniqueRES> m_mapRESIDtoURES = new TreeMap();

    public WURCSSequence2 getSequence() {
        return this.m_oSequence;
    }

    /*
     * WARNING - void declaration
     */
    public void start(WURCSArray a_oWURCSArray) {
        WURCSExporter t_oExport = new WURCSExporter();
        WURCSSequence2 t_oSequence = new WURCSSequence2(t_oExport.getWURCSString(a_oWURCSArray), a_oWURCSArray.getUniqueRESCount(), a_oWURCSArray.getRESCount(), a_oWURCSArray.getLINCount());
        TreeMap<Integer, MSPERI> t_mapURESIDToMS = new TreeMap<Integer, MSPERI>();
        MSStateDeterminationUtility t_oMSUtil = new MSStateDeterminationUtility();
        for (UniqueRES uniqueRES : a_oWURCSArray.getUniqueRESs()) {
            MSArrayToSequence t_oMSA2S = new MSArrayToSequence();
            t_oMSA2S.start(uniqueRES);
            MSPERI t_oPERI = t_oMSA2S.getSequenceMS();
            t_mapURESIDToMS.put(uniqueRES.getUniqueRESID(), t_oPERI);
            Iterator iterator = t_oMSUtil.getPossiblePositions(uniqueRES).iterator();
            while (iterator.hasNext()) {
                int t_iPos = (Integer)iterator.next();
                t_oPERI.addPossiblePosition(t_iPos);
            }
        }
        TreeMap<Integer, GRES> t_mapRESIDToGRES = new TreeMap<Integer, GRES>();
        for (RES t_oRES : a_oWURCSArray.getRESs()) {
            int t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oRES.getRESIndex());
            this.m_mapRESIDtoURES.put(t_oRESID, a_oWURCSArray.getUniqueRESs().get(t_oRES.getUniqueRESID() - 1));
            MSPERI t_oMS = (MSPERI)t_mapURESIDToMS.get(t_oRES.getUniqueRESID());
            GRES t_oGRES = new GRES(t_oRESID, t_oMS);
            t_mapRESIDToGRES.put(t_oRESID, t_oGRES);
            t_oSequence.addGRES(t_oGRES);
        }
        boolean bl = false;
        for (LIN t_oLIN : a_oWURCSArray.getLINs()) {
            int t_oRESID;
            GRES t_oGRES;
            GLIPs t_oDonorGLIPs;
            void var7_10;
            if (t_oLIN.getListOfGLIPs().size() > 2) continue;
            ++var7_10;
            GLIPs t_oAcceptorGLIPs = t_oLIN.getListOfGLIPs().getFirst();
            if (this.compareGLIPs(t_oAcceptorGLIPs, t_oDonorGLIPs = t_oLIN.getListOfGLIPs().getLast()) > 0) {
                GLIPs tmp = t_oDonorGLIPs;
                t_oDonorGLIPs = t_oAcceptorGLIPs;
                t_oAcceptorGLIPs = tmp;
            }
            if (t_oAcceptorGLIPs == t_oDonorGLIPs) {
                t_oDonorGLIPs = null;
            }
            GLIN t_oGLIN = new GLIN((int)var7_10, t_oLIN.getMAPCode());
            t_oSequence.addGLIN(t_oGLIN);
            if (t_oLIN.isRepeatingUnit()) {
                t_oGLIN.setRepeatCountMin(t_oLIN.getMinRepeatCount());
                t_oGLIN.setRepeatCountMax(t_oLIN.getMaxRepeatCount());
            }
            for (GLIP t_oGLIP : t_oAcceptorGLIPs.getGLIPs()) {
                if (!t_oGLIN.getAcceptorPositions().contains(t_oGLIP.getBackbonePosition())) {
                    t_oGLIN.addAcceptorPosition(t_oGLIP.getBackbonePosition());
                }
                if (!(t_oGRES = (GRES)t_mapRESIDToGRES.get(t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oGLIP.getRESIndex()))).getAcceptorGLINs().contains(t_oGLIN)) {
                    t_oGRES.addAcceptorGLIN(t_oGLIN);
                }
                if (t_oGLIN.getAcceptor().contains(t_oGRES)) continue;
                t_oGLIN.addAcceptor(t_oGRES);
            }
            if (t_oDonorGLIPs == null) continue;
            for (GLIP t_oGLIP : t_oDonorGLIPs.getGLIPs()) {
                if (!t_oGLIN.getDonorPositions().contains(t_oGLIP.getBackbonePosition())) {
                    t_oGLIN.addDonorPosition(t_oGLIP.getBackbonePosition());
                }
                if (!(t_oGRES = (GRES)t_mapRESIDToGRES.get(t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oGLIP.getRESIndex()))).getDonorGLINs().contains(t_oGLIN)) {
                    t_oGRES.addDonorGLIN(t_oGLIN);
                }
                if (t_oGLIN.getDonor().contains(t_oGRES)) continue;
                t_oGLIN.addDonor(t_oGRES);
            }
        }
        this.m_oSequence = t_oSequence;
    }

    private int compareGLIPs(GLIPs a_oGLIPs1, GLIPs a_oGLIPs2) {
        int t_iRESID1 = WURCSDataConverter.convertRESIndexToID(a_oGLIPs1.getGLIPs().getLast().getRESIndex());
        int t_iRESID2 = WURCSDataConverter.convertRESIndexToID(a_oGLIPs2.getGLIPs().getLast().getRESIndex());
        int t_iAnomPos1 = this.m_mapRESIDtoURES.get(t_iRESID1).getAnomericPosition();
        int t_iAnomPos2 = this.m_mapRESIDtoURES.get(t_iRESID2).getAnomericPosition();
        int t_iPos1 = a_oGLIPs1.getGLIPs().getLast().getBackbonePosition();
        int t_iPos2 = a_oGLIPs2.getGLIPs().getLast().getBackbonePosition();
        if (t_iPos1 != t_iAnomPos1 && t_iPos2 == t_iAnomPos2) {
            return -1;
        }
        if (t_iPos1 == t_iAnomPos1 && t_iPos2 != t_iAnomPos2) {
            return 1;
        }
        if (t_iAnomPos1 > 0 && t_iAnomPos2 <= 0) {
            if (t_iPos1 != t_iAnomPos1) {
                return -1;
            }
            if (t_iPos1 == t_iAnomPos1) {
                return 1;
            }
        }
        if (t_iAnomPos1 <= 0 && t_iAnomPos2 > 0) {
            if (t_iPos2 != t_iAnomPos2) {
                return 1;
            }
            if (t_iPos2 == t_iAnomPos2) {
                return -1;
            }
        }
        if (t_iPos1 != t_iPos2) {
            return t_iPos2 - t_iPos1;
        }
        if (t_iRESID1 != t_iRESID2) {
            return t_iRESID1 - t_iRESID2;
        }
        return 0;
    }
}

