/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.comparator;

import java.util.Comparator;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;

public class BackboneComparator
implements Comparator<Backbone> {
    @Override
    public int compare(Backbone b1, Backbone b2) {
        String strCode2;
        if (!b1.hasUnknownLength() && b2.hasUnknownLength()) {
            return -1;
        }
        if (b1.hasUnknownLength() && !b2.hasUnknownLength()) {
            return 1;
        }
        int t_iComp = b2.getLength() - b1.getLength();
        if (t_iComp != 0) {
            return t_iComp;
        }
        t_iComp = this.compareBackboneScore(b1, b2);
        if (t_iComp != 0) {
            return t_iComp;
        }
        String strCode1 = b1.getSkeletonCode();
        if (!strCode1.equals(strCode2 = b2.getSkeletonCode())) {
            return strCode2.compareTo(strCode1);
        }
        char t_cAnom1 = b1.getAnomericSymbol();
        char t_cAnom2 = b2.getAnomericSymbol();
        t_iComp = t_cAnom2 - t_cAnom1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        return 0;
    }

    public int compareBackboneScore(Backbone b1, Backbone b2) {
        int score1 = b1.getBackboneScore();
        int score2 = b2.getBackboneScore();
        return score1 - score2;
    }
}

