/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.comparator;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSVisitorCollectSequenceComparator;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class WURCSVisitorCollectSequenceComparatorForSubtree
extends WURCSVisitorCollectSequenceComparator {
    private boolean m_bHasRelationship = true;
    private HashMap<WURCSVisitorCollectSequence, LinkedList<WURCSVisitorCollectSequence>> t_mapChildToParents = new HashMap();
    private HashMap<WURCSVisitorCollectSequence, LinkedList<WURCSVisitorCollectSequence>> t_mapParentToChildren = new HashMap();
    private HashMap<WURCSVisitorCollectSequence, Integer> t_mapParentSeqToHeight = new HashMap();
    private HashMap<WURCSVisitorCollectSequence, Integer> t_mapParentSeqToNumDescendant = new HashMap();
    private Comparator<WURCSVisitorCollectSequence> m_compParents = new Comparator<WURCSVisitorCollectSequence>(){

        @Override
        public int compare(WURCSVisitorCollectSequence o1, WURCSVisitorCollectSequence o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            boolean t_bHasParent1 = WURCSVisitorCollectSequenceComparatorForSubtree.this.t_mapChildToParents.containsKey(o1);
            boolean t_bHasParent2 = WURCSVisitorCollectSequenceComparatorForSubtree.this.t_mapChildToParents.containsKey(o2);
            if (!t_bHasParent1 && t_bHasParent2) {
                return -1;
            }
            if (t_bHasParent1 && !t_bHasParent2) {
                return 1;
            }
            if (!t_bHasParent1 && !t_bHasParent2) {
                return 0;
            }
            return this.compareParents((LinkedList)WURCSVisitorCollectSequenceComparatorForSubtree.this.t_mapChildToParents.get(o1), (LinkedList)WURCSVisitorCollectSequenceComparatorForSubtree.this.t_mapChildToParents.get(o2));
        }

        private int compareParents(LinkedList<WURCSVisitorCollectSequence> a_aParents1, LinkedList<WURCSVisitorCollectSequence> a_aParents2) {
            Collections.sort(a_aParents1, this);
            Collections.sort(a_aParents2, this);
            int t_nParents = a_aParents1.size();
            if (t_nParents < a_aParents2.size()) {
                t_nParents = a_aParents2.size();
            }
            for (int i = 0; i < t_nParents; ++i) {
                WURCSVisitorCollectSequence t_oSeq2;
                if (i >= a_aParents1.size()) {
                    return -1;
                }
                if (i >= a_aParents2.size()) {
                    return 1;
                }
                WURCSVisitorCollectSequence t_oSeq1 = a_aParents1.get(i);
                int t_iComp = this.compare(t_oSeq1, t_oSeq2 = a_aParents2.get(i));
                if (t_iComp == 0) continue;
                return t_iComp;
            }
            return 0;
        }
    };

    public WURCSVisitorCollectSequenceComparatorForSubtree(LinkedList<WURCSVisitorCollectSequence> a_aSequences) throws WURCSVisitorException {
        for (int i = 0; i < a_aSequences.size() - 1; ++i) {
            WURCSVisitorCollectSequence t_oSeq1 = a_aSequences.get(i);
            for (int j = i + 1; j < a_aSequences.size(); ++j) {
                WURCSVisitorCollectSequence t_oSeqChild;
                WURCSVisitorCollectSequence t_oSeq2 = a_aSequences.get(j);
                int t_iComp = WURCSVisitorCollectSequenceComparatorForSubtree.compareSubtreeRelationship(t_oSeq1, t_oSeq2);
                if (t_iComp == 0) continue;
                WURCSVisitorCollectSequence t_oSeqParent = t_iComp < 0 ? t_oSeq1 : t_oSeq2;
                WURCSVisitorCollectSequence wURCSVisitorCollectSequence = t_oSeqChild = t_iComp < 0 ? t_oSeq2 : t_oSeq1;
                if (!this.t_mapChildToParents.containsKey(t_oSeqChild)) {
                    this.t_mapChildToParents.put(t_oSeqChild, new LinkedList());
                }
                if (!this.t_mapChildToParents.get(t_oSeqChild).contains(t_oSeqParent)) {
                    this.t_mapChildToParents.get(t_oSeqChild).add(t_oSeqParent);
                }
                if (!this.t_mapParentToChildren.containsKey(t_oSeqParent)) {
                    this.t_mapParentToChildren.put(t_oSeqParent, new LinkedList());
                }
                if (this.t_mapParentToChildren.get(t_oSeqParent).contains(t_oSeqChild)) continue;
                this.t_mapParentToChildren.get(t_oSeqParent).add(t_oSeqChild);
            }
        }
        if (this.t_mapChildToParents.isEmpty()) {
            this.m_bHasRelationship = false;
            return;
        }
        for (WURCSVisitorCollectSequence t_oSeqParent : a_aSequences) {
            if (!this.t_mapParentToChildren.containsKey(t_oSeqParent)) {
                this.t_mapParentSeqToHeight.put(t_oSeqParent, 0);
                this.t_mapParentSeqToNumDescendant.put(t_oSeqParent, 0);
                continue;
            }
            LinkedList<WURCSVisitorCollectSequence> t_aSeqChildren = this.t_mapParentToChildren.get(t_oSeqParent);
            int t_iHeight = 0;
            int t_nDescendant = 0;
            while (!t_aSeqChildren.isEmpty()) {
                t_nDescendant += t_aSeqChildren.size();
                LinkedList t_aSeqChildrenNew = new LinkedList();
                for (WURCSVisitorCollectSequence t_oSeqChild : t_aSeqChildren) {
                    if (!this.t_mapParentToChildren.containsKey(t_oSeqChild)) continue;
                    t_aSeqChildrenNew.addAll(this.t_mapParentToChildren.get(t_oSeqChild));
                }
                if (t_aSeqChildrenNew.contains(t_oSeqParent)) {
                    throw new WURCSVisitorException("A cyclic subtree relationship is found.");
                }
                t_aSeqChildren = t_aSeqChildrenNew;
                ++t_iHeight;
            }
            this.t_mapParentSeqToHeight.put(t_oSeqParent, t_iHeight);
            this.t_mapParentSeqToNumDescendant.put(t_oSeqParent, t_nDescendant);
        }
    }

    public boolean hasRelationship() {
        return this.m_bHasRelationship;
    }

    private static int compareSubtreeRelationship(WURCSVisitorCollectSequence a_oSeq1, WURCSVisitorCollectSequence a_oSeq2) {
        LinkedList<ModificationAlternative> t_lSubtrees1 = a_oSeq1.getSubtreeLinkageModifications();
        LinkedList<ModificationAlternative> t_lSubtrees2 = a_oSeq2.getSubtreeLinkageModifications();
        for (ModificationAlternative t_oModAlt : t_lSubtrees1) {
            if (!t_lSubtrees2.contains(t_oModAlt)) continue;
            boolean t_bIsParent1 = false;
            boolean t_bIsParent2 = false;
            for (WURCSEdge t_oEdge : t_oModAlt.getLeadInEdges()) {
                if (a_oSeq1.getNodes().contains(t_oEdge.getBackbone())) {
                    t_bIsParent1 = true;
                }
                if (!a_oSeq2.getNodes().contains(t_oEdge.getBackbone())) continue;
                t_bIsParent2 = true;
            }
            if (t_bIsParent1 && !t_bIsParent2) {
                return -1;
            }
            if (t_bIsParent1 || !t_bIsParent2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(WURCSVisitorCollectSequence o1, WURCSVisitorCollectSequence o2) {
        int t_iComp = 0;
        if (o1.equals(o2)) {
            return 0;
        }
        t_iComp = this.m_compParents.compare(o1, o2);
        if (t_iComp != 0) {
            return t_iComp;
        }
        int t_iHeight1 = this.t_mapParentSeqToHeight.get(o1);
        int t_iHeight2 = this.t_mapParentSeqToHeight.get(o2);
        t_iComp = t_iHeight2 - t_iHeight1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        int t_nDescendant1 = this.t_mapParentSeqToNumDescendant.get(o1);
        int t_nDescendant2 = this.t_mapParentSeqToNumDescendant.get(o2);
        t_iComp = t_nDescendant2 - t_nDescendant1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        return super.compare(o1, o2);
    }
}

