/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSVisitorCollectSequenceComparator;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSVisitorCollectSequenceComparatorForSubtree;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverser;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverserNoBranch;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WURCSVisitorCollectSequence
implements WURCSVisitor {
    private static final Logger logger = LoggerFactory.getLogger(WURCSVisitorCollectSequence.class);
    private LinkedList<LinkedList<WURCSEdge>> m_aMultiEdges = new LinkedList();
    private LinkedList<WURCSComponent> m_aNodes = new LinkedList();
    private LinkedList<Modification> m_aRepeats = new LinkedList();
    private LinkedList<Modification> m_aLeaves = new LinkedList();
    private LinkedList<Modification> m_aRoots = new LinkedList();
    private LinkedList<ModificationAlternative> m_aSubtreeLinkages = new LinkedList();
    private LinkedList<ModificationAlternative> m_aCompositionLinkages = new LinkedList();
    private LinkedList<ModificationAlternative> m_aCompositionSubstituents = new LinkedList();
    private LinkedList<Integer> m_aBranchingPoints = new LinkedList();
    private int m_nBranchBackbone = 0;
    private int m_nBranchModification = 0;
    private int m_iDepth = 0;
    private int m_nTerminal = 0;
    private LinkedList<WURCSComponent> m_aParentNodes = new LinkedList();
    private LinkedList<WURCSEdge> m_aBranchEdges = new LinkedList();

    protected void setParentNodes(LinkedList<WURCSComponent> a_aParentNodes) {
        this.m_aParentNodes.addAll(a_aParentNodes);
    }

    public LinkedList<LinkedList<WURCSEdge>> getMultiEdges() {
        return this.m_aMultiEdges;
    }

    public LinkedList<WURCSComponent> getNodes() {
        return this.m_aNodes;
    }

    public LinkedList<Modification> getRepeatModifications() {
        return this.m_aRepeats;
    }

    public LinkedList<Modification> getLeafModifications() {
        return this.m_aLeaves;
    }

    public LinkedList<Modification> getRootModifications() {
        return this.m_aRoots;
    }

    public LinkedList<ModificationAlternative> getSubtreeLinkageModifications() {
        return this.m_aSubtreeLinkages;
    }

    public LinkedList<ModificationAlternative> getCompositionLinkageModifications() {
        return this.m_aCompositionLinkages;
    }

    public LinkedList<ModificationAlternative> getCompositionSubstituentModifications() {
        return this.m_aCompositionSubstituents;
    }

    public int getBranchCountOnBackbone() {
        return this.m_nBranchBackbone;
    }

    public int getBranchCountOnModification() {
        return this.m_nBranchModification;
    }

    public int getDepth() {
        return this.m_iDepth;
    }

    public int getTerminalCount() {
        return this.m_nTerminal;
    }

    public LinkedList<Integer> getBranchingPoints() {
        return this.m_aBranchingPoints;
    }

    public boolean hasIllegalRepeat() {
        logger.debug("check repeat: {}", (Object)this.m_aRepeats);
        for (Modification t_oRep : this.m_aRepeats) {
            WURCSEdge t_oStartEdge = t_oRep.getEdges().getFirst();
            WURCSEdge t_oEndEdge = t_oRep.getEdges().getLast();
            if (t_oStartEdge.isAnomeric()) {
                t_oEndEdge = t_oRep.getEdges().getFirst();
                t_oStartEdge = t_oRep.getEdges().getLast();
            }
            int t_iStartID = this.m_aNodes.indexOf(t_oStartEdge.getBackbone());
            int t_iEndID = this.m_aNodes.indexOf(t_oEndEdge.getBackbone());
            logger.debug("{} vs {}", (Object)t_iStartID, (Object)t_iEndID);
            if (t_iStartID - t_iEndID >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Backbone a_objBackbone) throws WURCSVisitorException {
        if (this.m_aParentNodes.contains(a_objBackbone)) {
            throw new WURCSVisitorException("The backbone is already added in parent sequence.");
        }
        if (this.m_aNodes.contains(a_objBackbone)) {
            throw new WURCSVisitorException("The backbone is already added.");
        }
        this.m_aNodes.addLast(a_objBackbone);
        ++this.m_iDepth;
        logger.debug("{}:{}({})", this.m_iDepth, a_objBackbone.getSkeletonCode(), a_objBackbone);
        for (WURCSEdge t_oEdge : a_objBackbone.getParentEdges()) {
            Modification t_oMod = t_oEdge.getModification();
            if (!t_oMod.isRoot()) continue;
            this.m_aRoots.add(t_oMod);
        }
        LinkedList<WURCSEdge> t_aChildGlycosidicEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : a_objBackbone.getChildEdges()) {
            Modification t_oMod = t_oEdge.getModification();
            if (t_oMod instanceof InterfaceRepeat) {
                this.m_aRepeats.addLast(t_oMod);
                continue;
            }
            if (t_oMod instanceof ModificationAlternative) {
                ModificationAlternative t_oModAlt = (ModificationAlternative)t_oMod;
                if (t_oModAlt.isGlycosidicLinkageForComposition() && !this.m_aCompositionLinkages.contains(t_oModAlt)) {
                    this.m_aCompositionLinkages.add(t_oModAlt);
                }
                if (t_oModAlt.isSubstituentForSubtree() && !this.m_aCompositionSubstituents.contains(t_oModAlt)) {
                    this.m_aCompositionSubstituents.add(t_oModAlt);
                }
                if (t_oModAlt.isGlycosidicLinkageForSubtree() && !this.m_aSubtreeLinkages.contains(t_oModAlt)) {
                    this.m_aSubtreeLinkages.add(t_oModAlt);
                }
            }
            if (!t_oMod.isGlycosidic() || this.m_aNodes.contains(t_oMod) || this.m_aParentNodes.contains(t_oMod)) continue;
            if (t_oMod.isLeaf()) {
                this.m_aLeaves.addLast(t_oMod);
                continue;
            }
            t_aChildGlycosidicEdges.add(t_oEdge);
        }
        if (t_aChildGlycosidicEdges.size() == 0) {
            ++this.m_nTerminal;
        }
        if (t_aChildGlycosidicEdges.size() < 2) {
            return;
        }
        ++this.m_nBranchBackbone;
        this.m_aBranchingPoints.addLast(this.m_iDepth);
        this.traverseBranches(t_aChildGlycosidicEdges);
    }

    @Override
    public void visit(Modification a_objModification) throws WURCSVisitorException {
        if (!a_objModification.isGlycosidic()) {
            return;
        }
        if (this.m_aNodes.contains(a_objModification)) {
            throw new WURCSVisitorException("The modification is already added.");
        }
        this.m_aNodes.addLast(a_objModification);
        ++this.m_iDepth;
        logger.debug("{}:{}", (Object)this.m_iDepth, (Object)a_objModification.getMAPCode());
        LinkedList<WURCSEdge> t_aChildEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : a_objModification.getChildEdges()) {
            if (this.m_aNodes.contains(t_oEdge.getBackbone()) || this.m_aParentNodes.contains(t_oEdge.getBackbone())) continue;
            t_aChildEdges.add(t_oEdge);
        }
        if (t_aChildEdges.size() < 2) {
            return;
        }
        ++this.m_nBranchModification;
        this.traverseBranches(t_aChildEdges);
    }

    @Override
    public void visit(WURCSEdge a_objWURCSEdge) throws WURCSVisitorException {
        for (LinkedList linkedList : this.m_aMultiEdges) {
            if (!linkedList.contains(a_objWURCSEdge)) continue;
            throw new WURCSVisitorException("The edge is already added.");
        }
        LinkedList<WURCSEdge> t_aEdge = new LinkedList<WURCSEdge>();
        t_aEdge.addLast(a_objWURCSEdge);
        this.m_aMultiEdges.addLast(t_aEdge);
    }

    @Override
    public void start(WURCSGraph a_objGraph) throws WURCSVisitorException {
        this.clear();
        try {
            this.traverseRootBackbones(a_objGraph.getRootBackbones());
        }
        catch (WURCSException e) {
            throw new WURCSVisitorException(e.getMessage());
        }
    }

    @Override
    public WURCSGraphTraverser getTraverser(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        return new WURCSGraphTraverserNoBranch(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_aMultiEdges = new LinkedList();
        this.m_aNodes = new LinkedList();
        this.m_aRepeats = new LinkedList();
        this.m_aLeaves = new LinkedList();
        this.m_aRoots = new LinkedList();
        this.m_nBranchBackbone = 0;
        this.m_nBranchModification = 0;
        this.m_aBranchingPoints = new LinkedList();
        this.m_iDepth = 0;
        this.m_nTerminal = 0;
        this.m_aBranchEdges = new LinkedList();
    }

    public void start(WURCSEdge a_oEdge) throws WURCSVisitorException {
        LinkedList<WURCSEdge> t_oMulti = new LinkedList<WURCSEdge>();
        t_oMulti.add(a_oEdge);
        this.start(t_oMulti);
    }

    public void start(LinkedList<WURCSEdge> a_aEdges) throws WURCSVisitorException {
        this.m_aMultiEdges.addLast(a_aEdges);
        WURCSGraphTraverser t_oTraverser = this.getTraverser(this);
        t_oTraverser.traverse(a_aEdges.getFirst().getNextComponent());
    }

    public void start(Backbone a_oBackbone) throws WURCSVisitorException {
        this.m_aMultiEdges.addLast(new LinkedList());
        WURCSGraphTraverser t_oTraverser = this.getTraverser(this);
        t_oTraverser.traverse(a_oBackbone);
    }

    private void traverseRootBackbones(ArrayList<Backbone> a_aRootBackbones) throws WURCSVisitorException {
        LinkedList<WURCSVisitorCollectSequence> t_aSequences = new LinkedList<WURCSVisitorCollectSequence>();
        for (Backbone t_oRoot : a_aRootBackbones) {
            WURCSVisitorCollectSequence t_oSeq = new WURCSVisitorCollectSequence();
            t_oSeq.start(t_oRoot);
            t_aSequences.add(t_oSeq);
        }
        WURCSVisitorCollectSequenceComparatorForSubtree t_compForSubtree = new WURCSVisitorCollectSequenceComparatorForSubtree(t_aSequences);
        if (t_compForSubtree.hasRelationship()) {
            this.addSequences(t_aSequences, t_compForSubtree);
            return;
        }
        this.addSequences(t_aSequences);
    }

    private void traverseBranches(LinkedList<WURCSEdge> a_aBranchStartEdges) throws WURCSVisitorException {
        this.m_aBranchEdges.addAll(a_aBranchStartEdges);
        LinkedList t_aAllMultipleEdges = new LinkedList();
        for (WURCSEdge t_oEdge : a_aBranchStartEdges) {
            boolean bl = false;
            for (LinkedList linkedList : t_aAllMultipleEdges) {
                for (WURCSEdge t_oMultipleEdge : linkedList) {
                    if (t_oEdge.equals(t_oMultipleEdge) || !t_oEdge.getBackbone().equals(t_oMultipleEdge.getBackbone()) || !t_oEdge.getModification().equals(t_oMultipleEdge.getModification())) continue;
                    bl = true;
                }
                if (!bl) continue;
                linkedList.add(t_oEdge);
                break;
            }
            if (bl) continue;
            LinkedList<WURCSEdge> t_aNewEdges = new LinkedList<WURCSEdge>();
            t_aNewEdges.add(t_oEdge);
            t_aAllMultipleEdges.add(t_aNewEdges);
        }
        LinkedList<WURCSVisitorCollectSequence> t_aSequences = new LinkedList<WURCSVisitorCollectSequence>();
        for (LinkedList linkedList : t_aAllMultipleEdges) {
            WURCSVisitorCollectSequence t_oSeq = new WURCSVisitorCollectSequence();
            t_oSeq.setParentNodes(this.m_aParentNodes);
            t_oSeq.setParentNodes(this.m_aNodes);
            t_oSeq.start(linkedList);
            t_aSequences.add(t_oSeq);
        }
        this.addSequences(t_aSequences);
    }

    private void addSequences(LinkedList<WURCSVisitorCollectSequence> a_aSequences) {
        this.addSequences(a_aSequences, new WURCSVisitorCollectSequenceComparator());
    }

    private void addSequences(LinkedList<WURCSVisitorCollectSequence> a_aSequences, Comparator<WURCSVisitorCollectSequence> a_comparator) {
        Collections.sort(a_aSequences, a_comparator);
        int t_iMaxDepth = 0;
        for (WURCSVisitorCollectSequence t_oSeq : a_aSequences) {
            this.m_aMultiEdges.addAll(t_oSeq.getMultiEdges());
            this.m_aNodes.addAll(t_oSeq.getNodes());
            this.m_aLeaves.addAll(t_oSeq.getLeafModifications());
            this.m_aRepeats.addAll(t_oSeq.getRepeatModifications());
            for (ModificationAlternative t_oModAlt : t_oSeq.getSubtreeLinkageModifications()) {
                if (!this.m_aSubtreeLinkages.contains(t_oModAlt)) continue;
                this.m_aSubtreeLinkages.add(t_oModAlt);
            }
            if (t_iMaxDepth < t_oSeq.getDepth()) {
                t_iMaxDepth = t_oSeq.getDepth();
            }
            Iterator iterator = t_oSeq.getBranchingPoints().iterator();
            while (iterator.hasNext()) {
                int t_iBranchingDepth = (Integer)iterator.next();
                this.m_aBranchingPoints.addLast(t_iBranchingDepth += this.m_iDepth);
            }
            this.m_nBranchBackbone += t_oSeq.getBranchCountOnBackbone();
            this.m_nBranchModification += t_oSeq.getBranchCountOnModification();
            this.m_nTerminal += t_oSeq.getTerminalCount();
        }
        this.m_iDepth += t_iMaxDepth;
    }
}

