/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis;

import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomCyclic;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPBondType;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;

public class ValenceBondCalculator {
    private HashMap<MAPAtomAbstract, LinkedList<MAPConnection>> m_mapAtomToConnections;

    public ValenceBondCalculator(MAPGraph a_oGraph) {
        this.m_mapAtomToConnections = a_oGraph.getAtomToConnections();
    }

    public int countValence(MAPAtomAbstract a_oAtom) {
        if (a_oAtom instanceof MAPAtomCyclic) {
            return -1;
        }
        int t_nValence = 0;
        int t_nAromatic = 0;
        for (MAPConnection t_oConn : this.m_mapAtomToConnections.get(a_oAtom)) {
            MAPBondType t_enumBT = t_oConn.getBondType();
            if (t_enumBT == MAPBondType.UNKNOWN) {
                return -1;
            }
            if (t_enumBT == MAPBondType.AROMATIC) {
                ++t_nAromatic;
                continue;
            }
            t_nValence += t_enumBT.getNumber();
        }
        if (t_nAromatic == 1 || t_nAromatic > 3) {
            return -1;
        }
        if (t_nAromatic == 2) {
            t_nValence = (int)((double)t_nValence + (double)t_nAromatic * 1.5);
        }
        if (t_nAromatic == 3) {
            if (t_nValence > 0) {
                return -1;
            }
            t_nValence = 4;
        }
        return t_nValence;
    }

    public int countRemainingValence(MAPAtomAbstract a_oAtom) {
        int t_nBasicValence = a_oAtom.getValence();
        if (t_nBasicValence == -1) {
            return -1;
        }
        int t_nValence = this.countValence(a_oAtom);
        if (t_nValence == -1) {
            return -1;
        }
        int t_iDiff = t_nBasicValence - t_nValence;
        if (t_nBasicValence > 4) {
            if (t_iDiff > 6) {
                t_iDiff -= 6;
            }
            if (t_iDiff > 4) {
                t_iDiff -= 4;
            }
            if (t_iDiff > 2) {
                t_iDiff -= 2;
            }
        }
        return t_iDiff;
    }

    public int countConnections(MAPAtomAbstract a_oAtom) {
        int t_iDiff = this.countRemainingValence(a_oAtom);
        if (t_iDiff == -1) {
            return -1;
        }
        LinkedList<MAPConnection> t_aConns = this.m_mapAtomToConnections.get(a_oAtom);
        int t_nConnection = t_aConns.size() + t_iDiff;
        return t_nConnection;
    }

    public boolean hasTautomaricConnections(MAPAtomAbstract a_oAtom) {
        int t_nDoubleBondNOS = 0;
        int t_nSingleBondNOSWithHydrogen = 0;
        for (MAPConnection t_oConn : this.m_mapAtomToConnections.get(a_oAtom)) {
            MAPAtomAbstract t_oAtom = t_oConn.getAtom();
            if (!t_oAtom.getSymbol().equals("N") && !t_oAtom.getSymbol().equals("O") && !t_oAtom.getSymbol().equals("S")) continue;
            if (t_oConn.getBondType() == MAPBondType.DOUBLE && this.countRemainingValence(t_oAtom) == 0) {
                ++t_nDoubleBondNOS;
            }
            if (t_oConn.getBondType() != MAPBondType.SINGLE || this.countRemainingValence(t_oAtom) != 1) continue;
            ++t_nSingleBondNOSWithHydrogen;
        }
        return t_nDoubleBondNOS > 0 && t_nSingleBondNOSWithHydrogen > 0;
    }
}

