/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.util.WURCSStringUtils;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.util.map.MAPFactory;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;
import org.glycoinfo.WURCSFramework.util.validation.WURCSFactoryForValidation;
import org.glycoinfo.WURCSFramework.util.validation.WURCSValidationReport;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.DirectionDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtom;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomCyclic;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPBondType;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WURCSValidator {
    private static final Logger logger = LoggerFactory.getLogger(WURCSValidator.class);
    private WURCSValidationReport m_repo = this.getNewReport();
    private WURCSFactoryForValidation m_factory;
    private Map<String, MAPFactory> m_mapMAPStringToFactory = new HashMap<String, MAPFactory>();
    private int m_nMaxBranches = 10;

    public void setMaxBranchCount(int a_nBranches) {
        this.m_nMaxBranches = a_nBranches;
    }

    public WURCSValidationReport getReport() {
        return this.m_repo;
    }

    protected WURCSFactoryForValidation getWURCSFactory() {
        return this.m_factory;
    }

    protected WURCSValidationReport getNewReport() {
        return new WURCSValidationReport();
    }

    public void start(String a_strWURCS) {
        this.getReport().setInputString(a_strWURCS);
        try {
            String t_strOutWURCS;
            block7: {
                this.m_factory = new WURCSFactoryForValidation(a_strWURCS);
                WURCSGraph graph = this.m_factory.getGraph();
                this.validate(graph);
                if (this.getReport().hasError() || this.getReport().hasUnverifiable()) {
                    return;
                }
                this.m_factory.normalizeMAP();
                t_strOutWURCS = this.m_factory.getWURCS();
                do {
                    this.getReport().addOutputString(t_strOutWURCS);
                    WURCSFactory factoryNew = new WURCSFactory(t_strOutWURCS);
                    String t_strOutWURCSNew = factoryNew.getWURCS();
                    if (t_strOutWURCS.equals(t_strOutWURCSNew)) {
                        if (this.getReport().getOutputStrings().size() > 1) {
                            this.getReport().addWarning("The normalization process was performed recursively.");
                        }
                        break block7;
                    }
                    t_strOutWURCS = t_strOutWURCSNew;
                } while (!this.getReport().getOutputStrings().contains(t_strOutWURCS));
                this.getReport().addWarning("The normalization process is circulated. The most prior one in the results is selected as standard.");
                ArrayList<String> t_lOutWURCSs = new ArrayList<String>(this.getReport().getOutputStrings());
                Collections.sort(t_lOutWURCSs);
                t_strOutWURCS = (String)t_lOutWURCSs.get(0);
            }
            this.getReport().setStandardString(t_strOutWURCS);
        }
        catch (WURCSException e) {
            logger.error("Error in parsing WURCS.", e);
            this.getReport().addError("Error in parsing WURCS due to the exception.", a_strWURCS, e);
        }
        catch (Exception e) {
            logger.error("Something wrong with the WURCS.", (Object)a_strWURCS, (Object)e);
            this.getReport().addError("Something wrong with the WURCS.", a_strWURCS, e);
        }
    }

    private void validate(WURCSGraph a_graph) {
        try {
            this.validateGraph(a_graph);
        }
        catch (WURCSVisitorException e) {
            logger.error("Error in analyzing WURCSGraph.", e);
            this.getReport().addError("Error in analyzing WURCSGraph due to the exception.", this.m_factory.getWURCS(), e);
        }
        for (Backbone t_bb : a_graph.getBackbones()) {
            this.validateBackbone(t_bb);
        }
        for (Modification t_mod : a_graph.getModifications()) {
            this.validateModification(t_mod);
        }
    }

    protected void validateGraph(WURCSGraph a_graph) throws WURCSVisitorException {
    }

    protected void validateBackbone(Backbone a_bb) {
        this.validateBackboneCarbons(a_bb);
        this.validateAnomer(a_bb);
        this.validateConnectionsOnCarbonDescriptors(a_bb);
        this.validateCarbonConnections(a_bb);
    }

    protected void validateModification(Modification a_mod) {
        this.validateMAP(a_mod);
        this.validateRepeat(a_mod);
    }

    protected MAPFactory getMAPFactory(String a_strMAP) {
        if (this.m_mapMAPStringToFactory.containsKey(a_strMAP)) {
            return this.m_mapMAPStringToFactory.get(a_strMAP);
        }
        MAPFactory t_factory = null;
        try {
            t_factory = new MAPFactory(a_strMAP);
        }
        catch (WURCSFormatException e) {
            logger.error("Error in parsing MAP string: {}", (Object)a_strMAP, (Object)e);
            this.getReport().addError("Error in parsing MAP string.", a_strMAP, e);
        }
        this.m_mapMAPStringToFactory.put(a_strMAP, t_factory);
        return t_factory;
    }

    private void validateBackboneCarbons(Backbone a_bb) {
        if (a_bb.getBackboneCarbons().isEmpty()) {
            this.getReport().addError("A Backbone has no carbon.");
        }
    }

    private void validateAnomer(Backbone a_bb) {
        int apos = a_bb.getAnomericPosition();
        char asymb = a_bb.getAnomericSymbol();
        String strMS = this.m_factory.getInfo(a_bb).getMSString();
        int posApos = strMS.indexOf(45) + 2;
        int posAsymb = posApos + 1;
        if (asymb != 'a' && asymb != 'b' && asymb != 'u' && asymb != 'd' && asymb != 'x' && asymb != 'o') {
            this.getReport().addError("Invalid anomeric symbol is used, which must be 'a', 'b', 'u', 'd', 'x' and 'o'.", WURCSStringUtils.highlight(strMS, posAsymb));
        }
        if (asymb == 'o' && apos != 0) {
            this.getReport().addError("Anomeric position must not be specified when anomeric symbol 'o' is specified.", WURCSStringUtils.highlight(strMS, posApos));
        }
        if (apos > 0) {
            boolean hasRing = false;
            for (WURCSEdge edge0 : a_bb.getEdges()) {
                Modification mod;
                int pos;
                if (edge0.getLinkages().size() != 1 || (pos = edge0.getLinkages().get(0).getBackbonePosition()) != apos || (mod = edge0.getModification()).isGlycosidic() || mod.getEdges().size() != 2) continue;
                hasRing = true;
            }
            if (!hasRing) {
                this.getReport().addError("There is no ring making anomer despite existing anomeric information.", WURCSStringUtils.highlight(strMS, posApos));
            }
        }
        if (a_bb.hasUnknownLength()) {
            return;
        }
        ArrayList<Integer> t_lPossU = new ArrayList<Integer>();
        ArrayList<Integer> t_lPossO = new ArrayList<Integer>();
        ArrayList<Integer> t_lPossAnom = new ArrayList<Integer>();
        for (int i = 0; i < a_bb.getBackboneCarbons().size(); ++i) {
            BackboneCarbon t_bc = a_bb.getBackboneCarbons().get(i);
            int pos = i + 1;
            if (t_bc.getDescriptor().getChar() == 'u' || t_bc.getDescriptor().getChar() == 'U') {
                t_lPossU.add(pos);
            }
            if (t_bc.getDescriptor().getChar() == 'o' || t_bc.getDescriptor().getChar() == 'O') {
                t_lPossO.add(pos);
            }
            if (t_bc.getDescriptor().getChar() != 'a') continue;
            t_lPossAnom.add(pos);
        }
        logger.debug("Checking (potential) anomeric CarbonDescriptors:");
        logger.debug("Target SkeletonCode: {}", (Object)a_bb.getSkeletonCode());
        logger.debug("Unknown position(s): {}", (Object)t_lPossU);
        logger.debug("Calbonyl position(s): {}", (Object)t_lPossO);
        logger.debug("Anomeric position(s): {}", (Object)t_lPossAnom);
        if (!t_lPossU.isEmpty() && !t_lPossAnom.isEmpty()) {
            ArrayList<Integer> lPoss = new ArrayList<Integer>();
            lPoss.addAll(t_lPossU);
            lPoss.addAll(t_lPossAnom);
            this.getReport().addError("CarbonDescriptors 'a' and 'u' must not exist at the same time in the same SkeletonCode.", WURCSStringUtils.highlight(strMS, lPoss));
        }
        if (!t_lPossAnom.isEmpty()) {
            if (t_lPossAnom.size() > 1) {
                this.getReport().addError("CarbonDescritptor 'a' must be only one per SkeletonCode.", WURCSStringUtils.highlight(strMS, t_lPossAnom));
            }
            if ((Integer)t_lPossAnom.get(0) != apos) {
                ArrayList<Integer> t_lPoss = new ArrayList<Integer>();
                t_lPoss.addAll(t_lPossAnom);
                t_lPoss.add(posApos);
                this.getReport().addError("Anomeric position and position of CarbonDescriptor 'a' in SkeletonCode must be matched.", WURCSStringUtils.highlight(strMS, t_lPoss));
            }
            if (apos < 1 && asymb == 'o') {
                this.getReport().addError("Anomeric information must be specified when SkeletonCode has CarbonDescriptor 'a'.", WURCSStringUtils.highlight(strMS, t_lPossAnom));
            }
        } else if (apos != 0 || asymb != 'o') {
            this.getReport().addError("SkeletonCode with no CarbonDescriptor 'a' must not have anomeric information.", WURCSStringUtils.highlight(strMS, posApos, posAsymb));
        }
    }

    private void validateConnectionsOnCarbonDescriptors(Backbone a_bb) {
        if (a_bb.hasUnknownLength()) {
            return;
        }
        HashMap t_mapPosToEdges = new HashMap();
        ArrayList<WURCSEdge> t_lAltEdges = new ArrayList<WURCSEdge>();
        ArrayList<WURCSEdge> t_lRepEdges = new ArrayList<WURCSEdge>();
        for (WURCSEdge t_edge : a_bb.getEdges()) {
            ModificationAlternative t_modAlt;
            Object t_mod;
            int t_iPos = -1;
            if (t_edge.getLinkages().size() == 1) {
                t_iPos = t_edge.getLinkages().getFirst().getBackbonePosition();
            }
            if (t_iPos != -1 && t_iPos > a_bb.getBackboneCarbons().size()) {
                this.getReport().addError("The connected modification has wrong linkage position for the Backbone.", t_iPos + " on " + a_bb.getSkeletonCode());
            }
            if ((t_mod = t_edge.getModification()) instanceof InterfaceRepeat) {
                t_lRepEdges.add(t_edge);
                continue;
            }
            if (t_mod instanceof ModificationAlternative && ((t_modAlt = (ModificationAlternative)t_mod).getLeadInEdges().contains(t_edge) || t_modAlt.getLeadOutEdges().contains(t_edge))) {
                t_lAltEdges.add(t_edge);
            }
            if (!t_mapPosToEdges.containsKey(t_iPos)) {
                t_mapPosToEdges.put(t_iPos, new ArrayList());
            }
            ((List)t_mapPosToEdges.get(t_iPos)).add(t_edge);
        }
        boolean t_bHasUnknownCarbon = false;
        int t_nMinConnsTotal = 0;
        int t_nMaxConnsTotal = 0;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            int t_nMinConns;
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            char t_cCD = t_bc.getDescriptor().getChar();
            String t_strTargetInfo = WURCSStringUtils.highlight(this.m_factory.getInfo(a_bb).getMSString(), t_iPos);
            if (t_cCD == '?') {
                this.getReport().addWarning("Unknown CarbonDescriptor is contained.", t_strTargetInfo);
                t_bHasUnknownCarbon = true;
                continue;
            }
            int t_nMods = t_bc.getDescriptor().getNumberOfModifications();
            t_nMods -= t_bc.getDescriptor().getNumberOfHydrogens();
            int t_nUniqueMods = t_bc.getDescriptor().getNumberOfUniqueModifications();
            if ((t_nUniqueMods -= t_bc.getDescriptor().getNumberOfHydrogens() > 0 ? 1 : 0) < 0) {
                t_nUniqueMods = 0;
            }
            int n = t_nMinConns = t_nUniqueMods == 0 ? 0 : t_nUniqueMods - 1;
            if (t_cCD == 'A') {
                --t_nMinConns;
            }
            int t_nMaxConns = t_nMods;
            if (t_cCD == 'Q') {
                t_nMinConns = t_bc.getDescriptor().isTerminal() != false ? 1 : 0;
                t_nMaxConns = t_nMinConns + 2;
            }
            t_nMinConnsTotal += t_nMinConns;
            t_nMaxConnsTotal += t_nMaxConns;
            ArrayList t_lModEdges = (ArrayList)t_mapPosToEdges.get(t_iPos);
            if (t_lModEdges == null) {
                t_lModEdges = new ArrayList();
            }
            int t_nAlt = 0;
            for (WURCSEdge edge : t_lModEdges) {
                if (!t_lAltEdges.contains(edge)) continue;
                ++t_nAlt;
            }
            String t_strMessage = null;
            if (t_lModEdges.size() > t_nMaxConns) {
                t_strMessage = t_nMaxConns == 0 ? "No modification is allowed to be connected to the CarbonDescriptor \"" + t_cCD + "\"." : (t_nMaxConns == 1 ? "Only one modification is allowed to be connected to the CarbonDescriptor \"" + t_cCD + "\"." : "Too many modifications are connected to the CarbonDescriptor \"" + t_cCD + "\".");
            } else if (t_lModEdges.size() < t_nMinConns) {
                t_strMessage = "At least " + t_nMods + " modifications (containing an omitted hydroxyl group) must be connected to the CarbonDescriptor \"" + t_cCD + "\".";
            }
            if (t_strMessage != null) {
                if (t_nAlt > 0) {
                    this.getReport().addWarning(t_strMessage, t_strTargetInfo);
                    continue;
                }
                this.getReport().addError(t_strMessage, t_strTargetInfo);
                continue;
            }
            if (t_cCD == 'Q') continue;
            int t_nNoDirection = 0;
            int t_nDirection = 0;
            HashSet<DirectionDescriptor> t_setDDs = new HashSet<DirectionDescriptor>();
            for (WURCSEdge t_edge : t_lModEdges) {
                DirectionDescriptor dd = t_edge.getLinkages().get(0).getDirection();
                if (dd == DirectionDescriptor.N || dd == DirectionDescriptor.L) {
                    ++t_nNoDirection;
                } else {
                    ++t_nDirection;
                    t_setDDs.add(dd);
                    if (t_bc.getDescriptor().getStereo() != null || t_bc.getDescriptor() == CarbonDescriptor.DZ2_CISTRANS_XU) {
                        this.getReport().addWarning("DirectionDescriptor must not be specified for the CarbonDescriptor \"" + t_cCD + "\".", t_strTargetInfo);
                    }
                }
                if (dd.getOrbital() == null || dd.getOrbital().equals(t_bc.getDescriptor().getHybridOrbital())) continue;
                this.getReport().addError("The DirectionDescriptor \"" + dd.getName() + "\" can not be used for the CarbonDescriptor \"" + t_cCD + "\".", t_strTargetInfo);
            }
            if (t_nDirection != t_setDDs.size()) {
                if (!t_setDDs.contains((Object)DirectionDescriptor.X)) {
                    this.getReport().addError("Every DirectionDescriptor except for 'n' on the same linkage position must be different.", t_strTargetInfo);
                } else if (t_setDDs.size() > 2) {
                    this.getReport().addError("The DirectionDescriptor \"x\" must not be specified with the other DirectionDescriptor on the same linkage position.", t_strTargetInfo);
                }
            }
            if (t_nMods != t_nUniqueMods && t_nNoDirection >= t_nUniqueMods) {
                this.getReport().addError("The linkages on the CarbonDescriptor must have direction.", t_strTargetInfo);
            }
            HashMap<String, Integer> t_mapModToCount = new HashMap<String, Integer>();
            for (int i = 1; i <= 3; ++i) {
                String t_strMod = t_bc.getDescriptor().getModification(i);
                if (t_strMod == null) continue;
                if (!t_mapModToCount.containsKey(t_strMod)) {
                    t_mapModToCount.put(t_strMod, 0);
                }
                int t_nMod = (Integer)t_mapModToCount.get(t_strMod) + 1;
                t_mapModToCount.put(t_strMod, t_nMod);
            }
            HashSet<String> t_setMODStrings = new HashSet<String>();
            for (WURCSEdge t_edge : t_lModEdges) {
                if (t_edge.getModification().canOmitMAP()) {
                    t_setMODStrings.add("");
                    continue;
                }
                int t_iModPos = t_edge.getLinkages().get(0).getModificationPosition();
                String t_strMAP = t_edge.getModification().getMAPCode();
                MAPFactory factory = this.getMAPFactory(t_strMAP);
                if (factory == null) continue;
                MAPGraph graph = factory.getMAPGraph();
                MAPConnection conn = null;
                for (MAPStar star : graph.getStars()) {
                    if (t_iModPos != star.getStarIndex()) continue;
                    conn = star.getConnection();
                    break;
                }
                String t_strTargetMAP = this.m_factory.getInfo(t_edge.getModification()).getString();
                if (conn == null) continue;
                if (conn.getBondType() == MAPBondType.AROMATIC || conn.getBondType() == MAPBondType.UNKNOWN) {
                    this.getReport().addWarning("The bond type from the MAP star \"*\" must not be aromatic or unknown.", t_strTargetMAP);
                    continue;
                }
                String t_strConn = "" + conn.getBondType().getSymbol();
                if (!t_mapModToCount.containsKey(t_strConn + "X")) {
                    this.getReport().addError("The modification can not be connected to the CarbonDescriptor \"" + t_cCD + "\".", t_strTargetMAP);
                }
                if ((t_strConn = t_strConn + conn.getAtom().getSymbol()).equals("-O") || t_strConn.equals("=O")) {
                    t_strConn = "";
                }
                t_setMODStrings.add(t_strConn);
            }
            if (t_setMODStrings.size() == t_nUniqueMods || t_setMODStrings.size() == t_nUniqueMods - 1 || t_bc.getDescriptor() == CarbonDescriptor.SZ2_ACID_U && t_setMODStrings.size() == t_nUniqueMods - 2) continue;
            this.getReport().addError("The number of unique modifications connected to the CarbonDescriptor \"" + t_cCD + "\" must be " + t_nUniqueMods + " (containing omitted hydroxyl groups), but " + t_setMODStrings.size() + " unique modifications are connected.", t_strTargetInfo);
        }
        if (!t_mapPosToEdges.containsKey(-1) || t_bHasUnknownCarbon) {
            return;
        }
        String t_strTargetInfo = String.format("RESIndex \"%s\" (%s)", this.m_factory.getInfo(a_bb).getRESIndex(), this.m_factory.getInfo(a_bb).getMSString());
        if (a_bb.getEdges().size() > t_nMaxConnsTotal) {
            if (t_lAltEdges.isEmpty()) {
                this.getReport().addError("Too many linkages on the backbone.", t_strTargetInfo);
            } else {
                this.getReport().addWarning("Too many linkages on the backbone.", t_strTargetInfo);
            }
        } else if (a_bb.getEdges().size() < t_nMinConnsTotal) {
            this.getReport().addError("Too few linkages on the backbone.", t_strTargetInfo);
        }
    }

    private void validateCarbonConnections(Backbone a_bb) {
        if (a_bb.getBackboneCarbons().size() < 2) {
            return;
        }
        int t_iBond2Pre = 0;
        CarbonDescriptor t_cdPre = null;
        boolean t_bHasMismatch = false;
        int t_nUnknown = 0;
        boolean t_bWasUnknown = false;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            CarbonDescriptor t_cd = (CarbonDescriptor)t_bc.getDescriptor();
            t_bHasMismatch = false;
            int t_iPosT2 = t_iPos + t_nUnknown * 2;
            int t_iPosT1 = t_iPosT2 - 1 - (t_bWasUnknown ? 1 : 0);
            if (t_bc.hasUnknownLength()) {
                ++t_nUnknown;
                t_bWasUnknown = true;
            } else {
                t_bWasUnknown = false;
            }
            String t_strTargetInfo = WURCSStringUtils.highlight(this.m_factory.getInfo(a_bb).getMSString(), t_iPosT1, ++t_iPosT2);
            if (t_cdPre == null && t_cd.isTerminal() != null && !t_cd.isTerminal().booleanValue()) {
                this.getReport().addError("The CarbonDescriptor \"" + t_cd + "\" must not be at terminal.", t_strTargetInfo);
                t_bHasMismatch = true;
            }
            int t_iBond1 = t_cd.getBondTypeCarbon1();
            int t_iBond2 = t_cd.getBondTypeCarbon2();
            if (t_iBond2Pre < 0 || t_iBond1 < 0 || t_iBond2 < 0) {
                this.getReport().addWarning("Can not check backbone carbon connections for unknown carbons.", t_strTargetInfo);
                t_bHasMismatch = true;
            } else {
                if (t_iBond1 != t_iBond2Pre) {
                    t_iBond2 = t_cd.getBondTypeCarbon1();
                    t_iBond1 = t_cd.getBondTypeCarbon2();
                }
                if (t_iBond1 != t_iBond2Pre) {
                    this.getReport().addError("Bond order between two connecting backbone carbons is not matched.", t_strTargetInfo);
                    t_bHasMismatch = true;
                }
            }
            t_iBond2Pre = t_iBond2;
            if (t_cdPre == null) {
                if (t_cd == CarbonDescriptor.DZ1_KETENE_U) {
                    t_cd = CarbonDescriptor.DZ2_METHYLENE_U;
                }
                t_cdPre = t_cd;
                continue;
            }
            if (t_bHasMismatch) {
                t_cdPre = t_cd;
                continue;
            }
            if (t_iBond1 == 2) {
                String t_strStereo;
                if (t_cd == CarbonDescriptor.DD1_KETENE) continue;
                String t_strStereoPre = t_cdPre.getStereo();
                if (t_strStereoPre == null) {
                    t_strStereoPre = "N";
                }
                if ((t_strStereo = t_cd.getStereo()) == null) {
                    t_strStereo = "N";
                }
                if (!t_strStereoPre.equals(t_strStereo)) {
                    this.getReport().addError("Two carbons on a double bond must have the same stereochemistry.", t_strTargetInfo);
                }
            }
            t_cdPre = t_cd;
        }
        if (!t_bHasMismatch && t_iBond2Pre != 0) {
            this.getReport().addError("The CarbonDescirptor \"" + t_cdPre + "\" must not be at terminal.", WURCSStringUtils.highlight(this.m_factory.getInfo(a_bb).getMSString(), a_bb.getBackboneCarbons().size()));
        }
    }

    private void validateMAP(Modification a_mod) {
        boolean bl;
        boolean t_bMAPChange;
        String t_strTargetMod = this.m_factory.getInfo(a_mod).getString();
        int t_nEdges = a_mod.getEdges().size();
        if (a_mod instanceof ModificationAlternative) {
            ModificationAlternative modAlt = (ModificationAlternative)a_mod;
            t_nEdges = 0;
            if (!modAlt.getLeadInEdges().isEmpty()) {
                ++t_nEdges;
            }
            if (!modAlt.getLeadOutEdges().isEmpty()) {
                ++t_nEdges;
            }
            for (WURCSEdge t_edge : a_mod.getEdges()) {
                if (modAlt.getLeadInEdges().contains(t_edge) || modAlt.getLeadOutEdges().contains(t_edge)) continue;
                ++t_nEdges;
            }
        }
        logger.debug("# of edges on modification: {}", (Object)t_nEdges);
        if (t_nEdges == 1 && a_mod.getMAPCode().isEmpty()) {
            this.getReport().addError("The modification with single linkage must have MAP, which can not be omitted.", t_strTargetMod);
        }
        if (a_mod.canOmitMAP()) {
            if (t_nEdges > 3) {
                this.getReport().addError("The modification with omitted MAP must not have three or more linkages.", t_strTargetMod);
            }
            return;
        }
        String t_strMAP = a_mod.getMAPCode();
        logger.debug("Check MAP {}", (Object)t_strMAP);
        MAPFactory t_factory = this.getMAPFactory(t_strMAP);
        if (t_factory == null) {
            return;
        }
        if (!t_factory.getMAPString().equals(t_strMAP)) {
            this.getReport().addWarning("The MAP has been updated.", t_strMAP + " -> " + t_factory.getMAPString());
        }
        t_strMAP = t_factory.getMAPString();
        MAPGraph t_graph = t_factory.getMAPGraph();
        int t_nBranchTotal = 0;
        for (MAPAtomAbstract mAPAtomAbstract : t_graph.getAtoms()) {
            if (mAPAtomAbstract instanceof MAPAtomCyclic) continue;
            int nConn = mAPAtomAbstract.getConnections().size();
            t_nBranchTotal += Math.max(nConn - 2, 0);
        }
        if (t_nBranchTotal > this.m_nMaxBranches) {
            this.getReport().addUnverifiable("Too many branches on the MAP.", String.format("%d/%d: %s", t_nBranchTotal, this.m_nMaxBranches, t_strMAP));
            return;
        }
        t_factory = new MAPFactory(t_graph);
        t_factory.normalize();
        boolean bl2 = t_bMAPChange = !t_factory.getMAPString().equals(t_strMAP);
        if (t_bMAPChange) {
            this.getReport().addWarning("The MAP could be normalized.", t_strMAP + " -> " + t_factory.getMAPString());
        }
        for (MAPAtomAbstract t_atomAbs : t_graph.getAtoms()) {
            Iterator t_atom;
            if (!(t_atomAbs instanceof MAPAtom) || AtomicProperties.forSymbol(((MAPAtom)((Object)(t_atom = (MAPAtom)t_atomAbs))).getSymbol()) != null) continue;
            this.getReport().addWarning("Undefined atom symbol is used.", ((MAPAtom)((Object)t_atom)).getSymbol() + " in " + t_strMAP);
        }
        HashSet hashSet = new HashSet();
        ArrayList t_lAromaticAtomGroups = new ArrayList();
        for (MAPAtomAbstract mAPAtomAbstract : t_graph.getAtoms()) {
            if (!mAPAtomAbstract.isAromatic() || hashSet.contains(mAPAtomAbstract)) continue;
            ArrayList t_lAromaticAtomGroup = new ArrayList();
            LinkedList<MAPAtomAbstract> t_lParentAromaticAtoms = new LinkedList<MAPAtomAbstract>();
            t_lParentAromaticAtoms.add(mAPAtomAbstract);
            while (!t_lParentAromaticAtoms.isEmpty()) {
                Iterator t_atomParent = (MAPAtomAbstract)t_lParentAromaticAtoms.removeFirst();
                t_lAromaticAtomGroup.add(t_atomParent);
                for (MAPConnection t_conn : ((MAPAtomAbstract)((Object)t_atomParent)).getChildConnections()) {
                    if (!t_conn.getAtom().isAromatic() || t_lAromaticAtomGroup.contains(t_conn.getAtom())) continue;
                    t_lParentAromaticAtoms.add(t_conn.getAtom());
                }
            }
            t_lAromaticAtomGroups.add(t_lAromaticAtomGroup);
            hashSet.addAll(t_lAromaticAtomGroup);
        }
        for (List list : t_lAromaticAtomGroups) {
            int t_nBranch = 0;
            int t_nCyclic = 0;
            for (MAPAtomAbstract t_atom : list) {
                int t_nAromaticChildren = 0;
                for (MAPConnection t_conn : t_atom.getChildConnections()) {
                    if (!t_conn.getAtom().isAromatic()) continue;
                    ++t_nAromaticChildren;
                }
                if (t_nAromaticChildren > 1) {
                    t_nBranch += t_nAromaticChildren - 1;
                }
                if (!(t_atom instanceof MAPAtomCyclic)) continue;
                ++t_nCyclic;
            }
            if (t_nBranch + 1 == t_nCyclic) continue;
            this.getReport().addError("This MAP has an aromatic group with wrong ring closure count (# of \"$\" is incorrect).", t_strTargetMod);
            break;
        }
        if (this.findStereoInAromatic(t_graph)) {
            this.getReport().addWarning("Aromatic ring have stereochemistry which should be removed.", t_strTargetMod);
        }
        ArrayList<Integer> t_lStarIndices = new ArrayList<Integer>();
        for (MAPStar t_star : t_graph.getStars()) {
            int t_index = t_star.getStarIndex();
            logger.debug("has StarIndex {}", (Object)t_index);
            t_lStarIndices.add(t_index);
        }
        if (t_lStarIndices.isEmpty()) {
            this.getReport().addError("The MAP must have at least one star \"*\".", t_strMAP);
            return;
        }
        if (t_nEdges != t_lStarIndices.size()) {
            this.getReport().addError("The number of linkages connecting to the MAP must be equal to the number of stars \"*\" on the MAP.", t_strTargetMod);
        }
        boolean bl3 = false;
        for (MAPStar t_star : t_graph.getStars()) {
            for (MAPConnection t_conn : t_star.getConnections()) {
                if (!t_graph.getStars().contains(t_conn.getAtom())) continue;
                bl = true;
            }
        }
        if (bl) {
            this.getReport().addError("The MAPStar \"*\" must not connect to the other MAPStar directly.", t_strTargetMod);
        }
        if (t_bMAPChange) {
            this.getReport().addWarning("The validation for the linkages on the MAP can not be checked, because the StarIndices on the MAP may also be changed.");
            return;
        }
        HashSet t_setUniqueStars = new HashSet(t_lStarIndices);
        if (t_setUniqueStars.contains(0) && t_setUniqueStars.size() > 1) {
            this.getReport().addError("\"0\" must not be specified as StarIndex.", t_strMAP);
        }
        for (WURCSEdge t_edge : a_mod.getEdges()) {
            for (LinkagePosition t_link : t_edge.getLinkages()) {
                int t_modPos = t_link.getModificationPosition();
                logger.debug("Check StarIndex {} on linkage", (Object)t_modPos);
                if (t_setUniqueStars.contains(t_modPos)) continue;
                if (t_modPos != 0) {
                    this.getReport().addError("The linkage must not have the StarIndex when the MAP has no StarIndex.", t_strTargetMod);
                    continue;
                }
                this.getReport().addError("The linkage must have one of the StarIndices in the MAP.", t_strTargetMod);
            }
        }
    }

    private boolean findStereoInAromatic(MAPGraph a_graph) {
        for (MAPAtomAbstract t_atom : a_graph.getAtoms()) {
            if (!t_atom.isAromatic()) continue;
            if (t_atom.getStereo() != null) {
                return true;
            }
            for (MAPConnection t_conn : t_atom.getChildConnections()) {
                if (!t_conn.getAtom().isAromatic() || t_conn.getStereo() == null) continue;
                return true;
            }
        }
        return false;
    }

    private void validateRepeat(Modification a_mod) {
        if (!(a_mod instanceof InterfaceRepeat)) {
            return;
        }
        InterfaceRepeat t_rep = (InterfaceRepeat)((Object)a_mod);
        if (t_rep.getMaxRepeatCount() > 0 && t_rep.getMaxRepeatCount() < t_rep.getMinRepeatCount()) {
            this.getReport().addError("The max repeat count must be larger than min repeat count.", this.m_factory.getInfo(a_mod).getString());
        }
    }
}

