/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.ICarbonDescriptor;

public class BackboneCarbon {
    private Backbone m_objBackbone;
    private ICarbonDescriptor m_objCarbonDescriptor;
    private boolean m_bHasUnknownLength;

    public BackboneCarbon(Backbone a_oBackbone, ICarbonDescriptor a_enumCarbonDescriptor) {
        this(a_oBackbone, a_enumCarbonDescriptor, false);
    }

    public BackboneCarbon(Backbone a_oBackbone, ICarbonDescriptor a_enumCarbonDescriptor, boolean a_bHasUnknownLength) {
        this.m_objBackbone = a_oBackbone;
        this.m_objCarbonDescriptor = a_enumCarbonDescriptor;
        this.m_bHasUnknownLength = a_bHasUnknownLength;
    }

    public Backbone getBackbone() {
        return this.m_objBackbone;
    }

    public ICarbonDescriptor getDescriptor() {
        return this.m_objCarbonDescriptor;
    }

    public boolean hasUnknownLength() {
        return this.m_bHasUnknownLength;
    }

    public boolean isChiral() {
        return this.m_objCarbonDescriptor.isChiral();
    }

    public String getCode() {
        String strCode = "" + this.m_objCarbonDescriptor.getChar();
        if (this.hasUnknownLength()) {
            strCode = "<" + strCode + ">";
        }
        return strCode;
    }

    public BackboneCarbon copy(Backbone backbone) {
        return new BackboneCarbon(backbone, this.m_objCarbonDescriptor, this.m_bHasUnknownLength);
    }

    public BackboneCarbon invert(Backbone backbone) {
        return new BackboneCarbon(backbone, this.m_objCarbonDescriptor.getInverted(), this.m_bHasUnknownLength);
    }

    public String toString() {
        return this.getCode();
    }
}

