/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.wurcs.graph.DirectionDescriptor;

public class LinkagePosition {
    private int m_iBackbonePosition = 0;
    private DirectionDescriptor m_enumDirection;
    private int m_iModificationPosition;
    private boolean m_bCanOmitDirection;
    private boolean m_bCanOmitModificationPosition;
    private double m_dProbabilityUpper = 1.0;
    private double m_dProbabilityLower = 1.0;
    public static final int BACKBONESIDE = 1;
    public static final int MODIFICATIONSIDE = 2;
    private int m_iProbabilityPosition = 1;

    public LinkagePosition(int a_iPCB, DirectionDescriptor a_enumDD, boolean a_bCompressDMB, int a_iPCM, boolean a_bCompressPCM) {
        this.m_iBackbonePosition = a_iPCB;
        this.m_enumDirection = a_enumDD;
        this.m_bCanOmitDirection = a_bCompressDMB;
        this.m_iModificationPosition = a_iPCM;
        this.m_bCanOmitModificationPosition = a_bCompressPCM;
    }

    public LinkagePosition(int a_iPCB, DirectionDescriptor a_enumDMB, int a_iPCM) {
        this(a_iPCB, a_enumDMB, true, a_iPCM, true);
    }

    public void setProbabilityUpper(double prob) throws WURCSException {
        if (prob > 1.0) {
            throw new WURCSException("Probability must be lower than 1.0.");
        }
        this.m_dProbabilityUpper = prob;
    }

    public void setProbabilityLower(double prob) throws WURCSException {
        if (prob > 1.0) {
            throw new WURCSException("Probability must be lower than 1.0.");
        }
        this.m_dProbabilityLower = prob;
    }

    public void setProbabilityPosition(int pos) throws WURCSException {
        if (pos != 1 && pos != 2) {
            throw new WURCSException("Probability position must be 1 (backbone side) or 2 (modification side).");
        }
        this.m_iProbabilityPosition = pos;
    }

    public DirectionDescriptor getDirection() {
        return this.m_enumDirection;
    }

    public boolean canOmitDirection() {
        return this.m_bCanOmitDirection;
    }

    public boolean canOmitModificationPosition() {
        return this.m_bCanOmitModificationPosition;
    }

    public int getBackbonePosition() {
        return this.m_iBackbonePosition;
    }

    public int getModificationPosition() {
        return this.m_iModificationPosition;
    }

    public double getProbabilityUpper() {
        return this.m_dProbabilityUpper;
    }

    public double getProbabilityLower() {
        return this.m_dProbabilityLower;
    }

    public int getProbabilityPosition() {
        return this.m_iProbabilityPosition;
    }

    public LinkagePosition copy() {
        return new LinkagePosition(this.m_iBackbonePosition, this.m_enumDirection, this.m_bCanOmitDirection, this.m_iModificationPosition, this.m_bCanOmitModificationPosition);
    }

    public void invertBackbonePosition(int length) {
        if (this.m_iBackbonePosition == -1) {
            return;
        }
        if (this.m_iBackbonePosition != 1 && this.m_iBackbonePosition != length) {
            this.m_enumDirection = this.m_enumDirection.equals((Object)DirectionDescriptor.U) ? DirectionDescriptor.D : (this.m_enumDirection.equals((Object)DirectionDescriptor.D) ? DirectionDescriptor.U : this.m_enumDirection);
        }
        this.m_iBackbonePosition = length + 1 - this.m_iBackbonePosition;
    }
}

