/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class WURCSGraph {
    private ArrayList<Backbone> m_aBackbones = new ArrayList();
    private ArrayList<Modification> m_aModifications = new ArrayList();

    public ArrayList<Backbone> getRootBackbones() throws WURCSException {
        ArrayList<Backbone> t_aResult = new ArrayList<Backbone>();
        Iterator<Backbone> t_iterBackbone = this.getBackboneIterator();
        while (t_iterBackbone.hasNext()) {
            Backbone t_objBackbone = t_iterBackbone.next();
            boolean t_bIsRoot = true;
            for (WURCSEdge t_oEdge : t_objBackbone.getEdges()) {
                if (!t_oEdge.isReverse()) continue;
                t_bIsRoot = false;
            }
            if (!t_bIsRoot) continue;
            t_aResult.add(t_objBackbone);
        }
        if (t_aResult.size() > 0) {
            return t_aResult;
        }
        throw new WURCSException("WURCSGraph seems not to have at least one root residue");
    }

    public Iterator<Backbone> getBackboneIterator() {
        return this.m_aBackbones.iterator();
    }

    public Iterator<Modification> getModificationIterator() {
        return this.m_aModifications.iterator();
    }

    public boolean isConnected() throws WURCSException {
        ArrayList<Backbone> t_objRoots = this.getRootBackbones();
        return t_objRoots.size() <= 1;
    }

    public boolean removeBackbone(Backbone a_objBackbone) throws WURCSException {
        this.removeEdgesAroundComponent(a_objBackbone);
        return this.m_aBackbones.remove(a_objBackbone);
    }

    public boolean removeModification(Modification a_objModification) throws WURCSException {
        this.removeEdgesAroundComponent(a_objModification);
        return this.m_aModifications.remove(a_objModification);
    }

    private void removeEdgesAroundComponent(WURCSComponent a_objResidue) throws WURCSException {
        if (a_objResidue == null) {
            throw new WURCSException("Invalide residue.");
        }
        while (!a_objResidue.getEdges().isEmpty()) {
            WURCSEdge t_objLinkage = a_objResidue.getEdges().getFirst();
            Backbone t_objResidue = t_objLinkage.getBackbone();
            if (t_objResidue == null) {
                throw new WURCSException("A linkage with a null residue exists.");
            }
            t_objResidue.removeEdge(t_objLinkage);
            a_objResidue.removeEdge(t_objLinkage);
        }
    }

    public ArrayList<Backbone> getBackbones() {
        return this.m_aBackbones;
    }

    public ArrayList<Modification> getModifications() {
        return this.m_aModifications;
    }

    public boolean addBackbone(Backbone a_objResidue) throws WURCSException {
        if (a_objResidue == null) {
            throw new WURCSException("Invalide residue.");
        }
        if (this.m_aBackbones.contains(a_objResidue)) {
            return false;
        }
        a_objResidue.removeAllEdges();
        return this.m_aBackbones.add(a_objResidue);
    }

    public boolean addResidues(Backbone a_objBackbone, WURCSEdge a_objLinkage, Modification a_objModification) throws WURCSException {
        if (a_objBackbone == null || a_objModification == null) {
            throw new WURCSException("Invalide residue.");
        }
        if (a_objLinkage == null) {
            throw new WURCSException("Invalide linkage.");
        }
        if (!this.m_aBackbones.contains(a_objBackbone)) {
            a_objBackbone.removeAllEdges();
            this.m_aBackbones.add(a_objBackbone);
        }
        if (!this.m_aBackbones.contains(a_objBackbone)) {
            throw new WURCSException("Critical error imposible to add residue.");
        }
        if (!this.m_aModifications.contains(a_objModification)) {
            a_objModification.removeAllEdges();
            this.m_aModifications.add(a_objModification);
        }
        if (!this.m_aModifications.contains(a_objModification)) {
            throw new WURCSException("Critical error imposible to add residue.");
        }
        a_objModification.addEdge(a_objLinkage);
        a_objBackbone.addEdge(a_objLinkage);
        a_objLinkage.setModification(a_objModification);
        a_objLinkage.setBackbone(a_objBackbone);
        return true;
    }

    public WURCSGraph copy() throws WURCSException {
        HashMap<Backbone, Backbone> t_hashOrigToCopyB = new HashMap<Backbone, Backbone>();
        HashMap<Modification, Modification> t_hashOrigToCopyM = new HashMap<Modification, Modification>();
        WURCSGraph copy = this.copy(t_hashOrigToCopyB, t_hashOrigToCopyM);
        return copy;
    }

    public WURCSGraph copy(HashMap<Backbone, Backbone> a_hashOrigToCopyB) throws WURCSException {
        HashMap<Modification, Modification> t_hashOrigToCopyM = new HashMap<Modification, Modification>();
        WURCSGraph copy = this.copy(a_hashOrigToCopyB, t_hashOrigToCopyM);
        return copy;
    }

    public WURCSGraph copy(HashMap<Backbone, Backbone> a_hashOrigToCopyBackbone, HashMap<Modification, Modification> a_hashOrigToCopyModification) throws WURCSException {
        WURCSGraph copy = new WURCSGraph();
        for (Backbone t_origBack : this.m_aBackbones) {
            Backbone t_copyBack = t_origBack.copy();
            a_hashOrigToCopyBackbone.put(t_origBack, t_copyBack);
            for (WURCSEdge t_origEdge : t_origBack.getEdges()) {
                Modification t_origModif = t_origEdge.getModification();
                if (!a_hashOrigToCopyModification.containsKey(t_origModif)) {
                    a_hashOrigToCopyModification.put(t_origModif, t_origModif.copy());
                }
                Modification t_copyModif = a_hashOrigToCopyModification.get(t_origModif);
                WURCSEdge t_copyEdge = t_origEdge.copy();
                copy.addResidues(t_copyBack, t_copyEdge, t_copyModif);
                if (!(t_origModif instanceof ModificationAlternative)) continue;
                if (((ModificationAlternative)t_origModif).getLeadInEdges().contains(t_origEdge)) {
                    ((ModificationAlternative)t_copyModif).addLeadInEdge(t_copyEdge);
                }
                if (!((ModificationAlternative)t_origModif).getLeadOutEdges().contains(t_origEdge)) continue;
                ((ModificationAlternative)t_copyModif).addLeadOutEdge(t_copyEdge);
            }
            if (!t_origBack.getEdges().isEmpty()) continue;
            copy.addBackbone(t_copyBack);
        }
        return copy;
    }
}

