/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class CrossLinkedSubstituentDictionary {
    private static HashMap<String, ResidueType> dictionary = new HashMap();

    public static ResidueType getCrossLinkedSubstituent(String type_name) throws Exception {
        if (!CrossLinkedSubstituentDictionary.hasCrossLinkedSubstituent(type_name)) {
            throw new Exception("Invalid type: <" + type_name + ">");
        }
        return CrossLinkedSubstituentDictionary.findCrossLinkedSubstituent(type_name);
    }

    public static boolean hasCrossLinkedSubstituent(String type_name) {
        return CrossLinkedSubstituentDictionary.findCrossLinkedSubstituent(type_name) != null;
    }

    public static ResidueType findCrossLinkedSubstituent(String type_name) {
        return dictionary.get(type_name.toLowerCase());
    }

    public static Collection<ResidueType> getCrossLinkedSubstituents() {
        return dictionary.values();
    }

    private CrossLinkedSubstituentDictionary() {
    }

    public static void loadDictionary(String filename) {
        CrossLinkedSubstituentDictionary.initDictionary();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                CrossLinkedSubstituentDictionary.add(new ResidueType(line));
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            dictionary.clear();
        }
    }

    private static void add(ResidueType type) {
        dictionary.put(type.getName().toLowerCase(), type);
        for (String s : type.getSynonyms()) {
            dictionary.put(s.toLowerCase(), type);
        }
    }

    private static void initDictionary() {
        dictionary.clear();
    }

    static {
        CrossLinkedSubstituentDictionary.initDictionary();
    }
}

