/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class NonSymbolicResidueDictionary {
    private static HashMap<String, ResidueType> dictionary = new HashMap();
    private static HashMap<String, ArrayList<ResidueType>> all_residues_map = new HashMap();

    public static ResidueType getResidueType(String type_name) throws Exception {
        ResidueType ret = NonSymbolicResidueDictionary.findResidueType(type_name);
        if (ret == null) {
            throw new Exception("Invalid type: <" + type_name + ">");
        }
        return ret;
    }

    public static boolean hasResidueType(String type_name) {
        return NonSymbolicResidueDictionary.findResidueType(type_name) != null;
    }

    public static ResidueType findResidueType(String type_name) {
        return dictionary.get(type_name.toLowerCase());
    }

    public static Collection<ResidueType> getResidues() {
        return dictionary.values();
    }

    public static HashMap<String, ArrayList<ResidueType>> getAllResidues() {
        return all_residues_map;
    }

    private NonSymbolicResidueDictionary() {
    }

    public static void loadDictionary(String filename) {
        NonSymbolicResidueDictionary.initDictionary();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                NonSymbolicResidueDictionary.add(new ResidueType(line));
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            dictionary.clear();
        }
    }

    private static void add(ResidueType type) {
        dictionary.put(type.getName().toLowerCase(), type);
        for (String s : type.getSynonyms()) {
            dictionary.put(s.toLowerCase(), type);
        }
        String superclass = type.getSuperclass();
        if (!all_residues_map.containsKey(superclass)) {
            all_residues_map.put(superclass, new ArrayList());
        }
        all_residues_map.get(superclass).add(type);
    }

    private static void initDictionary() {
        dictionary.clear();
        all_residues_map.clear();
        NonSymbolicResidueDictionary.add(new ResidueType());
    }

    static {
        NonSymbolicResidueDictionary.initDictionary();
    }
}

