/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.importer.glycontainer2glycan;

import java.util.ArrayList;
import org.eurocarbdb.application.glycanbuilder.linkage.Bond;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;

public class Edge2Bond {
    public ArrayList<Bond> startForNormalLinkage(Edge _edge) {
        ArrayList<Bond> bonds = new ArrayList<Bond>();
        for (Linkage gfcLin : _edge.getGlycosidicLinkages()) {
            Bond bond = new Bond();
            bond.setProbabilityHigh(gfcLin.getParentProbabilityUpper());
            bond.setProbabilityLow(gfcLin.getParentProbabilityLower());
            bond.setChildPosition(this.int2char(gfcLin.getChildLinkages().get(0)));
            bond.setParentPositions(this.convertAcceptroPositin(gfcLin.getParentLinkages()));
            bonds.add(bond);
        }
        return bonds;
    }

    public ArrayList<ArrayList<Bond>> startForBridgeLinkage(Edge _edge) {
        ArrayList<ArrayList<Bond>> ret = new ArrayList<ArrayList<Bond>>();
        Linkage lin = _edge.getGlycosidicLinkages().get(0);
        ArrayList<Bond> b2d = new ArrayList<Bond>();
        Bond bridgeToDonor = new Bond();
        bridgeToDonor.setParentPositions(this.convertAcceptroPositin(new ArrayList<Integer>(1)));
        bridgeToDonor.setChildPosition(this.int2char(lin.getChildLinkages().get(0)));
        b2d.add(bridgeToDonor);
        ArrayList<Bond> a2b = new ArrayList<Bond>();
        Bond acceptorToBridge = new Bond();
        acceptorToBridge.setParentPositions(this.convertAcceptroPositin(lin.getParentLinkages()));
        acceptorToBridge.setChildPosition(this.int2char(-1));
        a2b.add(acceptorToBridge);
        ret.add(b2d);
        ret.add(a2b);
        return ret;
    }

    public ArrayList<char[]> startForCyclicSubLinkage(Edge _edge) {
        ArrayList<char[]> bonds = new ArrayList<char[]>();
        for (Linkage lin : _edge.getGlycosidicLinkages()) {
            if (_edge.getGlycosidicLinkages().indexOf(lin) == 0) {
                bonds.add(this.int2charArray(lin.getParentLinkages().get(0)));
            }
            if (_edge.getGlycosidicLinkages().indexOf(lin) != 1) continue;
            bonds.add(this.int2charArray(lin.getParentLinkages().get(0)));
            if (lin.getChildLinkages().get(0) == 0) {
                bonds.add(this.int2charArray(-1));
                continue;
            }
            bonds.add(this.int2charArray(lin.getChildLinkages().get(0)));
        }
        return bonds;
    }

    public char startForModification(Integer _position) {
        return this.int2char(_position);
    }

    private char int2char(Integer _int) {
        char ret = '?';
        if (_int != -1) {
            ret = String.valueOf(_int).charAt(0);
        }
        return ret;
    }

    private char[] int2charArray(Integer _int) {
        char[] ret = new char[]{this.int2char(_int)};
        return ret;
    }

    private char[] convertAcceptroPositin(ArrayList<Integer> _positions) {
        char[] ret = new char[_positions.size()];
        for (Integer pos : _positions) {
            if (pos == -1) {
                ret[_positions.indexOf((Object)pos)] = 63;
                continue;
            }
            ret[_positions.indexOf((Object)pos)] = this.int2char(pos);
        }
        return ret;
    }
}

