/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext
extends AttributeAccessorSupport {
    private static final long serialVersionUID = -5827157174866681233L;
    private static final String DEFAULT_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.support.GenericXmlContextLoader";
    private static final Log logger = LogFactory.getLog(TestContext.class);
    private final ContextCache contextCache;
    private final ContextLoader contextLoader;
    private final String[] locations;
    private final Class<?> testClass;
    private Object testInstance;
    private Method testMethod;
    private Throwable testException;

    TestContext(Class<?> testClass, ContextCache contextCache) {
        Assert.notNull(testClass, (String)"Test class must not be null");
        Assert.notNull((Object)contextCache, (String)"ContextCache must not be null");
        ContextConfiguration contextConfiguration = testClass.getAnnotation(ContextConfiguration.class);
        String[] locations = null;
        ContextLoader contextLoader = null;
        if (contextConfiguration == null) {
            if (logger.isInfoEnabled()) {
                logger.info("@ContextConfiguration not found for class [" + testClass + "]");
            }
        } else {
            Class<ContextLoader> contextLoaderClass;
            if (logger.isTraceEnabled()) {
                logger.trace("Retrieved @ContextConfiguration [" + contextConfiguration + "] for class [" + testClass + "]");
            }
            if (ContextLoader.class.equals(contextLoaderClass = contextConfiguration.loader())) {
                try {
                    contextLoaderClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(DEFAULT_CONTEXT_LOADER_CLASS_NAME);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException("Could not load default ContextLoader class [org.springframework.test.context.support.GenericXmlContextLoader]. Specify @ContextConfiguration's 'loader' attribute or make the default loader class available.");
                }
            }
            contextLoader = (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass);
            locations = this.retrieveContextLocations(contextLoader, testClass);
        }
        this.testClass = testClass;
        this.contextCache = contextCache;
        this.contextLoader = contextLoader;
        this.locations = locations;
    }

    private String[] retrieveContextLocations(ContextLoader contextLoader, Class<?> clazz) {
        Assert.notNull((Object)contextLoader, (String)"ContextLoader must not be null");
        Assert.notNull(clazz, (String)"Class must not be null");
        ArrayList<String> locationsList = new ArrayList<String>();
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        Assert.notNull((Object)declaringClass, (String)("Could not find an 'annotation declaring class' for annotation type [" + annotationType + "] and class [" + clazz + "]"));
        while (declaringClass != null) {
            ContextConfiguration contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace("Retrieved @ContextConfiguration [" + contextConfiguration + "] for declaring class [" + declaringClass + "]");
            }
            String[] locations = contextLoader.processLocations(declaringClass, contextConfiguration.locations());
            locationsList.addAll(0, Arrays.asList(locations));
            declaringClass = contextConfiguration.inheritLocations() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return locationsList.toArray(new String[locationsList.size()]);
    }

    private ApplicationContext loadApplicationContext() throws Exception {
        Assert.notNull((Object)this.contextLoader, (String)"Can not build an ApplicationContext with a NULL 'contextLoader'. Consider annotating your test class with @ContextConfiguration.");
        Assert.notNull((Object)this.locations, (String)"Can not build an ApplicationContext with a NULL 'locations' array. Consider annotating your test class with @ContextConfiguration.");
        return this.contextLoader.loadContext(this.locations);
    }

    private String contextKeyString(Serializable key) {
        return ObjectUtils.nullSafeToString((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext getApplicationContext() {
        ApplicationContext context = null;
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            context = this.contextCache.get(this.contextKeyString((Serializable)this.locations));
            if (context == null) {
                try {
                    context = this.loadApplicationContext();
                    this.contextCache.put(this.contextKeyString((Serializable)this.locations), context);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to load ApplicationContext", ex);
                }
            }
        }
        return context;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Object getTestInstance() {
        return this.testInstance;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    public final Throwable getTestException() {
        return this.testException;
    }

    public void markApplicationContextDirty() {
        this.contextCache.setDirty(this.contextKeyString((Serializable)this.locations));
    }

    void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("locations", (Object)this.locations).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).toString();
    }
}

