/*
 * Decompiled with CFR 0.152.
 */
package test.bcb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import test.common.ExplorerFileViewPanel;

public class BreadCrumbTest
extends JFrame {
    protected BreadcrumbFileSelector bar = new BreadcrumbFileSelector();
    protected ExplorerFileViewPanel<File> filePanel;
    protected JScrollPane fileListScrollPane;

    public BreadCrumbTest() {
        super("BreadCrumb test");
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final List newPath = BreadCrumbTest.this.bar.getModel().getItems();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            System.out.println("\t" + ((File)item.getData()).getAbsolutePath());
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                                @Override
                                protected List<StringValuePair<File>> doInBackground() throws Exception {
                                    return BreadCrumbTest.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        List leafs = (List)this.get();
                                        BreadCrumbTest.this.filePanel.setFolder(leafs);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.filePanel = new ExplorerFileViewPanel<File>(this.bar, CommandButtonDisplayState.MEDIUM, null);
        this.filePanel.setUseNativeIcons(true);
        this.fileListScrollPane = new JScrollPane(this.filePanel);
        this.add((Component)this.fileListScrollPane, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        JButton setPath = new JButton("Select and set path...");
        setPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFileChooser folderChooser = new JFileChooser();
                        folderChooser.setFileSelectionMode(1);
                        if (folderChooser.showOpenDialog(BreadCrumbTest.this) == 0) {
                            File selected = folderChooser.getSelectedFile();
                            BreadCrumbTest.this.bar.setPath(selected);
                        }
                    }
                });
            }
        });
        controls.add(setPath);
        this.add((Component)controls, "South");
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                BreadCrumbTest test = new BreadCrumbTest();
                test.setSize(550, 385);
                test.setLocationRelativeTo(null);
                test.setVisible(true);
                test.setDefaultCloseOperation(3);
            }
        });
    }
}

