/*
 * Decompiled with CFR 0.152.
 */
package test.bcb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarExceptionHandler;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbSvnSelector;
import org.pushingpixels.flamingo.api.common.AbstractFileViewPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import test.MessageListDialog;
import test.common.ExplorerFileViewPanel;

public class SvnBreadCrumbTest
extends JFrame {
    private ExplorerFileViewPanel<String> filePanel;
    private BreadcrumbSvnSelector bar = new BreadcrumbSvnSelector();
    protected JComboBox svnCombo;

    public SvnBreadCrumbTest() {
        super("BreadCrumb test");
        this.bar.setThrowsExceptions(true);
        this.bar.addExceptionHandler(new BreadcrumbBarExceptionHandler(){

            @Override
            public void onException(Throwable t) {
                MessageListDialog.showMessageDialog((Frame)SvnBreadCrumbTest.this, "Error", t);
            }
        });
        SvnComboListModel svnComboModel = new SvnComboListModel();
        svnComboModel.addElement(new SvnRepoInfo("SVNKit", "http://svn.svnkit.com/repos/svnkit", "anonymous", "anonymous"));
        svnComboModel.addElement(new SvnRepoInfo("KDE", "svn://anonsvn.kde.org/home/kde/trunk", "anonymous", "anonymous"));
        svnComboModel.addElement(new SvnRepoInfo("Apache", "http://svn.apache.org/repos/asf", "anonymous", "anonymous"));
        this.svnCombo = new JComboBox(svnComboModel);
        this.svnCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SvnRepoInfo repo = (SvnRepoInfo)value;
                String name = repo == null ? "" : repo.name;
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.svnCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SvnRepoInfo selected = (SvnRepoInfo)SvnBreadCrumbTest.this.svnCombo.getSelectedItem();
                        SvnBreadCrumbTest.this.setCursor(Cursor.getPredefinedCursor(3));
                        SvnBreadCrumbTest.this.bar.setConnectionParams(selected.url, selected.user, selected.password, true);
                        SvnBreadCrumbTest.this.setCursor(Cursor.getDefaultCursor());
                    }
                });
            }
        });
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final List newPath = SvnBreadCrumbTest.this.bar.getModel().getItems();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            System.out.println("\t" + (String)item.getData());
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<String>>, Void> worker = new SwingWorker<List<StringValuePair<String>>, Void>(){

                                @Override
                                protected List<StringValuePair<String>> doInBackground() {
                                    return SvnBreadCrumbTest.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        List leafs = (List)this.get();
                                        SvnBreadCrumbTest.this.filePanel.setFolder(leafs);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new BorderLayout(3, 0));
        toolbar.setFloatable(false);
        toolbar.add((Component)this.svnCombo, "West");
        toolbar.add((Component)this.bar, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.filePanel = new ExplorerFileViewPanel<String>((JBreadcrumbBar)this.bar, CommandButtonDisplayState.MEDIUM, null){

            @Override
            protected void configureCommandButton(AbstractFileViewPanel.Leaf leaf, final JCommandButton button, ResizableIcon icon) {
                long size = (Long)leaf.getLeafProp("size");
                Date date = (Date)leaf.getLeafProp("date");
                SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy");
                button.setExtraText(size + " bytes, " + sdf.format(date));
                button.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.process(e);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.process(e);
                    }

                    protected void process(MouseEvent e) {
                        JPopupMenu popupMenu = new JPopupMenu();
                        JMenuItem showContents = new JMenuItem("Show file contents");
                        showContents.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SwingWorker<InputStream, Void> worker = new SwingWorker<InputStream, Void>(){

                                            @Override
                                            protected InputStream doInBackground() throws Exception {
                                                String leafName = button.getText();
                                                BreadcrumbBarModel model = bar.getModel();
                                                String path = (String)model.getItem(model.getItemCount() - 1).getData();
                                                return bar.getCallback().getLeafContent(path + "/" + leafName);
                                            }

                                            @Override
                                            protected void done() {
                                                try {
                                                    String line;
                                                    InputStream is = (InputStream)this.get();
                                                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                                                    JTextArea textArea = new JTextArea();
                                                    while ((line = reader.readLine()) != null) {
                                                        textArea.append(line + "\n");
                                                    }
                                                    textArea.setCaretPosition(0);
                                                    JDialog contDialog = new JDialog((Frame)SvnBreadCrumbTest.this, false);
                                                    contDialog.add((Component)new JScrollPane(textArea), "Center");
                                                    contDialog.setSize(500, 400);
                                                    contDialog.setLocationRelativeTo(null);
                                                    contDialog.setVisible(true);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                        };
                                        worker.execute();
                                    }
                                });
                            }
                        });
                        popupMenu.add(showContents);
                        popupMenu.show(button, e.getX(), e.getY());
                    }
                });
            }
        };
        JScrollPane fileListScrollPane = new JScrollPane(this.filePanel);
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SvnBreadCrumbTest test = new SvnBreadCrumbTest();
                test.setSize(700, 400);
                test.setLocation(300, 100);
                test.setVisible(true);
                test.setDefaultCloseOperation(3);
            }
        });
    }

    public class SvnComboListModel
    extends DefaultComboBoxModel {
        private List<SvnRepoInfo> svnRepoList = new ArrayList<SvnRepoInfo>();

        @Override
        public Object getElementAt(int index) {
            return this.svnRepoList.get(index);
        }

        @Override
        public int getSize() {
            return this.svnRepoList.size();
        }

        @Override
        public void addElement(SvnRepoInfo svnRepoInfo) {
            int index = this.svnRepoList.size();
            this.svnRepoList.add(svnRepoInfo);
            this.fireContentsChanged(this, index, index);
        }
    }

    protected static class SvnRepoInfo {
        public String name;
        public String url;
        public String user;
        public String password;

        public SvnRepoInfo(String name, String url, String user, String password) {
            this.name = name;
            this.url = url;
            this.user = user;
            this.password = password;
        }
    }
}

