/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.AbstractFileViewPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.ProgressListener;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.IcoWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;
import test.common.IconWrapperResizableIcon;

public class ExplorerFileViewPanel<T>
extends AbstractFileViewPanel<T> {
    protected JBreadcrumbBar<T> bar;
    protected static Map<String, ResizableIcon> iconMapping = new HashMap<String, ResizableIcon>();
    protected static ResizableIcon defaultIcon;
    protected boolean useNativeIcons;

    public ExplorerFileViewPanel(JBreadcrumbBar<T> bar, int startingDimension, ProgressListener progressListener) {
        super(startingDimension, progressListener);
        this.bar = bar;
        this.useNativeIcons = false;
    }

    public ExplorerFileViewPanel(JBreadcrumbBar<T> bar, CommandButtonDisplayState startingState, ProgressListener progressListener) {
        super(startingState, progressListener);
        this.bar = bar;
        this.useNativeIcons = false;
    }

    public void setUseNativeIcons(boolean useNativeIcons) {
        this.useNativeIcons = useNativeIcons;
    }

    @Override
    protected boolean toShowFile(StringValuePair<T> pair) {
        return true;
    }

    @Override
    protected ResizableIcon getResizableIcon(AbstractFileViewPanel.Leaf leaf, InputStream stream, CommandButtonDisplayState state, Dimension dimension) {
        int prefSize = state.getPreferredIconSize();
        if (prefSize > 0) {
            dimension = new Dimension(prefSize, prefSize);
        }
        if (this.useNativeIcons) {
            Object sourceProp = leaf.getLeafProp("source");
            if (sourceProp instanceof File) {
                return new IconWrapperResizableIcon(FileSystemView.getFileSystemView().getSystemIcon((File)sourceProp));
            }
            return null;
        }
        String name = leaf.getLeafName();
        int lastPointIndex = name.lastIndexOf(46);
        String ext = "*";
        if (lastPointIndex >= 0) {
            ext = name.substring(lastPointIndex + 1);
        }
        if ((ext = ext.toLowerCase()).compareTo("jpg") == 0 || ext.compareTo("jpeg") == 0 || ext.compareTo("gif") == 0 || ext.compareTo("png") == 0 || ext.compareTo("bmp") == 0) {
            return ImageWrapperResizableIcon.getIcon(stream, dimension);
        }
        if (ext.compareTo("svg") == 0) {
            return SvgBatikResizableIcon.getSvgIcon(stream, dimension);
        }
        if (ext.compareTo("svgz") == 0) {
            return SvgBatikResizableIcon.getSvgzIcon(stream, dimension);
        }
        if (ext.compareTo("ico") == 0) {
            return IcoWrapperResizableIcon.getIcon(stream, dimension);
        }
        ResizableIcon icon = iconMapping.get(ext);
        if (icon == null) {
            try {
                File iconFile = new File("C:/jtools/icons/File Icons Vs3/" + ext.toUpperCase() + ".ico");
                if (!iconFile.exists()) {
                    if (defaultIcon == null) {
                        defaultIcon = IcoWrapperResizableIcon.getIcon(new FileInputStream(new File("C:/jtools/icons/File Icons Vs3/Default.ico")), dimension);
                    }
                    return defaultIcon;
                }
                icon = IcoWrapperResizableIcon.getIcon(new FileInputStream(iconFile), dimension);
                iconMapping.put(ext, icon);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        }
        return icon;
    }

    @Override
    protected void configureCommandButton(AbstractFileViewPanel.Leaf leaf, JCommandButton button, ResizableIcon icon) {
        String filename = leaf.getLeafName();
        String ext = "Generic";
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            ext = filename.substring(lastDot + 1).toUpperCase();
        }
        button.setExtraText(ext + " file");
    }

    @Override
    protected InputStream getLeafContent(T leaf) {
        return this.bar.getCallback().getLeafContent(leaf);
    }
}

