/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorConvertOp;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import test.common.TestCommandButtons;
import test.svg.transcoded.edit_copy;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;
import test.svg.transcoded.edit_select_all;

public class TestCommandButtonsNoText
extends TestCommandButtons {
    @Override
    protected JCommandButton createActionButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(new edit_paste());
        result.setDisabledIcon(new FilteredResizableIcon(new edit_paste(), new ColorConvertOp(ColorSpace.getInstance(1003), null)));
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Main paste");
            }
        });
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        result.setDisplayState(state);
        result.setFlat(false);
        return result;
    }

    @Override
    protected JCommandButton createActionAndPopupMainActionButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(new edit_cut());
        result.setPopupCallback(new TestCommandButtons.TestPopupCallback());
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        result.setDisplayState(state);
        result.setFlat(false);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Cut");
            }
        });
        return result;
    }

    @Override
    protected JCommandButton createActionAndPopupMainPopupButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(new edit_copy());
        result.setPopupCallback(new TestCommandButtons.TestPopupCallback());
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        result.setDisplayState(state);
        result.setFlat(false);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Copy");
            }
        });
        return result;
    }

    @Override
    protected JCommandButton createPopupButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(new edit_select_all());
        result.setPopupCallback(new TestCommandButtons.TestPopupCallback());
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        result.setDisplayState(state);
        result.setFlat(false);
        return result;
    }

    @Override
    protected void configureControlPanel(JPanel controlPanel) {
        super.configureControlPanel(controlPanel);
        final JCheckBox noText = new JCheckBox("no text");
        noText.setSelected(true);
        noText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestCommandButtonsNoText.apply(TestCommandButtonsNoText.this, new Command(){

                            @Override
                            public void apply(JCommandButton button) {
                                button.setText(noText.isSelected() ? null : "New caption");
                                button.setExtraText(noText.isSelected() ? null : "New extra text");
                            }
                        });
                        TestCommandButtonsNoText.this.getContentPane().invalidate();
                        TestCommandButtonsNoText.this.getContentPane().validate();
                    }
                });
            }
        });
        controlPanel.add(noText);
    }

    private static void apply(Container cont, Command cmd) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JCommandButton) {
                JCommandButton cb = (JCommandButton)comp;
                cmd.apply(cb);
            }
            if (!(comp instanceof Container)) continue;
            TestCommandButtonsNoText.apply((Container)comp, cmd);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestCommandButtonsNoText frame = new TestCommandButtonsNoText();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static interface Command {
        public void apply(JCommandButton var1);
    }
}

