/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.Container;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import test.common.TestCommandButtons;
import test.common.TestRichTooltipPanels;

public class TestCommandButtonsRichTooltips
extends TestCommandButtons {
    @Override
    protected JPanel getButtonPanel() {
        JPanel result = super.getButtonPanel();
        TestCommandButtonsRichTooltips.apply(result, new Command(){

            @Override
            public void apply(JCommandButton button) {
                RichTooltip actionRichTooltip = new RichTooltip();
                actionRichTooltip.setTitle(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textActionTitle"));
                actionRichTooltip.addDescriptionSection(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textParagraph1"));
                actionRichTooltip.addDescriptionSection(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textParagraph2"));
                try {
                    actionRichTooltip.setMainImage(ImageIO.read(TestRichTooltipPanels.class.getResource("/test/resource/address-book-new.png")));
                    actionRichTooltip.setFooterImage(ImageIO.read(TestRichTooltipPanels.class.getResource("/test/resource/help-browser.png")));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                actionRichTooltip.addFooterSection(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textFooterParagraph1"));
                button.setActionRichTooltip(actionRichTooltip);
                RichTooltip popupRichTooltip = new RichTooltip();
                popupRichTooltip.setTitle(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textPopupTitle"));
                popupRichTooltip.addDescriptionSection(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textParagraph1"));
                try {
                    popupRichTooltip.setFooterImage(ImageIO.read(TestRichTooltipPanels.class.getResource("/test/resource/help-browser.png")));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                popupRichTooltip.addFooterSection(TestCommandButtonsRichTooltips.this.resourceBundle.getString("Tooltip.textFooterParagraph1"));
                button.setPopupRichTooltip(popupRichTooltip);
            }
        });
        return result;
    }

    private static void apply(Container cont, Command cmd) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JCommandButton) {
                JCommandButton cb = (JCommandButton)comp;
                cmd.apply(cb);
            }
            if (!(comp instanceof Container)) continue;
            TestCommandButtonsRichTooltips.apply((Container)comp, cmd);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestCommandButtonsRichTooltips frame = new TestCommandButtonsRichTooltips();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static interface Command {
        public void apply(JCommandButton var1);
    }
}

