/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorConvertOp;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;
import test.common.SamplePopupMenu;
import test.common.TestCommandButtons;

public class TestCommandButtonsSizing
extends JPanel {
    private List<Mapping> model = new LinkedList<Mapping>();
    private JScrollPane central;

    public TestCommandButtonsSizing() {
        for (final CommandButtonDisplayState state : new CommandButtonDisplayState[]{CommandButtonDisplayState.BIG, CommandButtonDisplayState.MEDIUM, CommandButtonDisplayState.TILE, CommandButtonDisplayState.SMALL}) {
            for (final JCommandButton.CommandButtonKind commandButtonKind : JCommandButton.CommandButtonKind.values()) {
                this.model.add(new Mapping(state.getDisplayName() + " + " + commandButtonKind.name(), new Creator(){

                    @Override
                    public JComponent create(int fontSize) {
                        return TestCommandButtonsSizing.this.createActionOnlyButton("Sample", state, commandButtonKind, fontSize);
                    }
                }));
            }
        }
        final JList<Object> list = new JList<Object>(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return TestCommandButtonsSizing.this.model.get(index);
            }

            @Override
            public int getSize() {
                return TestCommandButtonsSizing.this.model.size();
            }
        });
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((Mapping)value).caption, index, isSelected, cellHasFocus);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(list), "West");
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TestCommandButtonsSizing.this.central != null) {
                            TestCommandButtonsSizing.this.remove(TestCommandButtonsSizing.this.central);
                        }
                        TestCommandButtonsSizing.this.central = null;
                        int selIndex = list.getSelectedIndex();
                        if (selIndex >= 0) {
                            Mapping sel = (Mapping)list.getSelectedValue();
                            FormLayout lm = new FormLayout("right:pref, 4dlu, left:pref:grow", "");
                            DefaultFormBuilder builder = new DefaultFormBuilder(lm);
                            builder.setDefaultDialogBorder();
                            for (int fontSize = 11; fontSize < 25; ++fontSize) {
                                builder.append(fontSize + " pixels", (Component)sel.creator.create(fontSize));
                            }
                            TestCommandButtonsSizing.this.central = new JScrollPane(builder.getPanel(), 22, 31);
                            TestCommandButtonsSizing.this.add((Component)TestCommandButtonsSizing.this.central, "Center");
                            TestCommandButtonsSizing.this.doLayout();
                            TestCommandButtonsSizing.this.revalidate();
                        }
                    }
                });
            }
        });
    }

    private JCommandButton createActionOnlyButton(String text, CommandButtonDisplayState state, JCommandButton.CommandButtonKind commandButtonKind, int fontSize) {
        SvgBatikResizableIcon mainPasteIcon = SvgBatikResizableIcon.getSvgIcon(TestCommandButtons.class.getClassLoader().getResource("test/svg/edit-paste.svg"), new Dimension(32, 32));
        JCommandButton mainButton = new JCommandButton(text, mainPasteIcon);
        mainButton.setDisabledIcon(new FilteredResizableIcon(mainPasteIcon, new ColorConvertOp(ColorSpace.getInstance(1003), null)));
        mainButton.setExtraText("Extra for " + text.toLowerCase());
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Action invoked");
            }
        });
        mainButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu(commandButton.getComponentOrientation());
            }
        });
        mainButton.setCommandButtonKind(commandButtonKind);
        mainButton.setDisplayState(state);
        mainButton.setFlat(false);
        mainButton.setFont(mainButton.getFont().deriveFont((float)fontSize));
        return mainButton;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Testing command button fonts");
                frame.setSize(800, 600);
                frame.add(new TestCommandButtonsSizing());
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static class Mapping {
        public String caption;
        public Creator creator;

        public Mapping(String caption, Creator creator) {
            this.caption = caption;
            this.creator = creator;
        }
    }

    private static interface Creator {
        public JComponent create(int var1);
    }
}

